/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.InvisibleView;
import com.appframework.components.htmleditor.MyImageView;
import com.appframework.components.htmleditor.MyInlineView;
import com.appframework.components.htmleditor.MyParagraphView;
import javax.swing.JEditorPane;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class StyledHTMLFactory
extends HTMLEditorKit.HTMLFactory {
    private JEditorPane editor;

    public View create(Element element) {
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            if (tag == HTML.Tag.CONTENT) {
                return new MyInlineView(element, this.editor);
            }
            if (tag == HTML.Tag.IMG) {
                return new MyImageView(element);
            }
            if (tag == HTML.Tag.COMMENT) {
                return new InvisibleView(element);
            }
            if (tag instanceof HTML.UnknownTag) {
                return new InvisibleView(element);
            }
            if (tag == HTML.Tag.TITLE || tag == HTML.Tag.META || tag == HTML.Tag.LINK || tag == HTML.Tag.STYLE || tag == HTML.Tag.SCRIPT || tag == HTML.Tag.AREA || tag == HTML.Tag.MAP || tag == HTML.Tag.PARAM || tag == HTML.Tag.APPLET) {
                return new InvisibleView(element);
            }
            if (tag == HTML.Tag.IMPLIED) {
                String string = (String)element.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                if (string != null && string.equals("pre")) {
                    return super.create(element);
                }
                return new MyParagraphView(element);
            }
        }
        return super.create(element);
    }

    public void setEditor(JEditorPane jEditorPane) {
        this.editor = jEditorPane;
    }

    public void removeEditor() {
        this.editor = null;
    }
}

