/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.GWMozillaBrowserCanvas;
import com.appframework.components.htmleditor.SimpleHTMLViewer;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.utils.OS;
import com.webrenderer.BrowserFactory;
import com.webrenderer.IBrowserCanvas;
import com.webrenderer.IMozillaBrowserCanvas;
import com.webrenderer.dom.IElement;
import com.webrenderer.dom.IElementCollection;
import com.webrenderer.event.BrowserListener;
import com.webrenderer.event.MouseListener;
import com.webrenderer.event.NetworkAdapter;
import com.webrenderer.event.NetworkEvent;
import com.webrenderer.event.NetworkListener;
import com.webrenderer.event.WindowListener;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Panel;
import java.awt.event.FocusListener;
import java.io.InputStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.text.html.CSS;
import org.apache.log4j.Logger;

public class WrappedMozillaBrowser
extends Panel
implements GWMozillaBrowserCanvas,
SimpleHTMLViewer {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$WrappedMozillaBrowser == null ? (class$com$appframework$components$htmleditor$WrappedMozillaBrowser = WrappedMozillaBrowser.class$("com.appframework.components.htmleditor.WrappedMozillaBrowser")) : class$com$appframework$components$htmleditor$WrappedMozillaBrowser));
    private static Border UNFOCUSED_BORDER = BorderFactory.createLineBorder(Color.GRAY, 1);
    private static Border FOCUSED_BORDER = BorderFactory.createLineBorder(Color.BLACK, 1);
    protected IMozillaBrowserCanvas browser;
    private boolean firstPageLoaded = false;
    static /* synthetic */ Class class$com$appframework$components$htmleditor$WrappedMozillaBrowser;

    public WrappedMozillaBrowser(IMozillaBrowserCanvas iMozillaBrowserCanvas) {
        this.browser = iMozillaBrowserCanvas;
        this.browser.addNetworkListener((NetworkListener)new NetworkAdapter(){

            public void onDocumentComplete(NetworkEvent networkEvent) {
                WrappedMozillaBrowser.this.firstPageLoaded = true;
            }
        });
        this.buildUI();
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.add("Center", (Canvas)this.browser);
    }

    public synchronized FocusListener[] getFocusListeners() {
        return ((Component)this.browser).getFocusListeners();
    }

    public boolean findInPage(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.browser.findInPage(string, bl, bl2, bl3);
    }

    public void copy() {
        this.browser.copy();
    }

    public void selectAll() {
        this.browser.selectAll();
    }

    public void loadURL(String string) {
        this.browser.loadURL(string);
    }

    public void loadURL(URL uRL) {
        this.browser.loadURL(uRL);
    }

    public void loadHTML(String string, String string2) {
        this.browser.loadHTML(string, string2);
    }

    public void loadHTML(byte[] byArray, String string) {
        this.browser.loadHTML(byArray, string);
    }

    public void loadHTML(InputStream inputStream, String string) {
        this.browser.loadHTML(inputStream, string);
    }

    public void loadURL(int n, String string, byte[] byArray, String string2, String string3) {
        this.browser.loadURL(n, string, byArray, string2, string3);
    }

    public void addBrowserListener(BrowserListener browserListener) {
        this.browser.addBrowserListener(browserListener);
    }

    public void removeBrowserListener(BrowserListener browserListener) {
        this.browser.removeBrowserListener(browserListener);
    }

    public void addWindowListener(WindowListener windowListener) {
        this.browser.addWindowListener(windowListener);
    }

    public void removeWindowListener(WindowListener windowListener) {
        this.browser.removeWindowListener(windowListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.browser.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.browser.removeMouseListener(mouseListener);
    }

    public void setPreferredSize(int n, int n2) {
        this.browser.setPreferredSize(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.browser.getPreferredSize();
    }

    public String getSelectedText() {
        if (this.firstPageLoaded) {
            return this.browser.getSelectedText();
        }
        return null;
    }

    public void grabFocus() {
        this.browser.grabFocus();
    }

    public void increaseTextZoom() {
        this.browser.increaseTextZoom();
    }

    public void decreaseTextZoom() {
        this.browser.decreaseTextZoom();
    }

    public void setBrowserFont(Font font) {
        IElementCollection iElementCollection = this.browser.getDocument().getAll();
        for (int i = 0; i < iElementCollection.length(); ++i) {
            IElement iElement = iElementCollection.item(i);
            if (!iElement.getTagName().equalsIgnoreCase("BODY")) continue;
            iElement.setAttribute("style", (Object)HTMLUtils.getCSSFontStyleFromFont(iElement.getAttribute("style", 0L), font), 0L);
            break;
        }
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        IElementCollection iElementCollection = this.browser.getDocument().getAll();
        for (int i = 0; i < iElementCollection.length(); ++i) {
            IElement iElement = iElementCollection.item(i);
            if (!iElement.getTagName().equalsIgnoreCase("BODY")) continue;
            String string = iElement.getAttribute("style", 0L);
            string = HTMLUtils.checkAndUpdateMarginAttribute(string, CSS.Attribute.MARGIN_LEFT, n);
            string = HTMLUtils.checkAndUpdateMarginAttribute(string, CSS.Attribute.MARGIN_RIGHT, n3);
            string = HTMLUtils.checkAndUpdateMarginAttribute(string, CSS.Attribute.MARGIN_TOP, n2);
            string = HTMLUtils.checkAndUpdateMarginAttribute(string, CSS.Attribute.MARGIN_BOTTOM, n4);
            iElement.setAttribute("style", (Object)string, 0L);
            break;
        }
    }

    public void destroy() {
        logger.debug((Object)("### Destroying native browser: [" + this.browser.hashCode() + "]"));
        if (OS.isMacOS()) {
            BrowserFactory.destroyBrowser((IBrowserCanvas)this.browser);
        }
        this.browser.destroy();
    }

    public String getSource() {
        return this.browser.getDocument().getDocumentSource();
    }

    public void addNetworkListener(NetworkListener networkListener) {
        this.browser.addNetworkListener(networkListener);
    }

    public void removeNetworkListener(NetworkListener networkListener) {
        this.browser.removeNetworkListener(networkListener);
    }

    public void setPage(URL uRL) {
        this.browser.loadURL(uRL);
    }

    public void setStyledText(String string) {
        this.browser.loadHTML(string, "");
    }

    public void clear() {
        this.browser.loadHTML("", "");
    }

    public IMozillaBrowserCanvas getBrowser() {
        return this.browser;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

