/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor.hyperlink;

import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.RTFUtils;
import com.appframework.components.htmleditor.hyperlink.LinkParser;
import com.appframework.utils.Utils;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.log4j.Logger;

public class HTMLUtils {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$hyperlink$HTMLUtils == null ? (class$com$appframework$components$htmleditor$hyperlink$HTMLUtils = HTMLUtils.class$("com.appframework.components.htmleditor.hyperlink.HTMLUtils")) : class$com$appframework$components$htmleditor$hyperlink$HTMLUtils));
    public static final int DEFAULT_JAVA_DPI = 72;
    static /* synthetic */ Class class$com$appframework$components$htmleditor$hyperlink$HTMLUtils;

    static String normalizeTextToHTML(String string) {
        return HTMLUtils.normalizeTextToHTML(string, true);
    }

    public static String normalizeTextToHTML(String string, boolean bl) {
        String string2 = string.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        string2 = string2.replaceAll("\"", "&quot;");
        if (bl) {
            string2 = string2.replaceAll(" ", "&nbsp;");
        }
        return string2;
    }

    static String replaceSpaces(String string) {
        String string2 = "\\ {2,}";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(HTMLUtils.addNbsp(matcher.group().length()));
            n = matcher.end();
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString();
    }

    private static String addNbsp(int n) {
        String string = " ";
        for (int i = 1; i < n; ++i) {
            string = string + "&nbsp;";
        }
        return string;
    }

    static String replaceEOLs(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string;
        int n = string2.indexOf("\n");
        StringBuffer stringBuffer = new StringBuffer();
        if (n == -1) {
            return string2;
        }
        while (n >= 0) {
            stringBuffer.append(string2.substring(0, n));
            stringBuffer.append("<BR>");
            string2 = string2.substring(n + 1);
            n = string2.indexOf("\n");
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static HTML.Tag getNameAttribute(Element element) {
        if (element == null) {
            return null;
        }
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        HTML.Tag tag = object instanceof HTML.Tag ? (HTML.Tag)object : null;
        return tag;
    }

    public static String replaceTags(String string, String string2, String string3) {
        String string4 = "(?i)" + string2;
        String string5 = "<(\\s*)" + string4;
        String string6 = "<" + string3;
        String string7 = string.replaceAll(string5, string6);
        string5 = "<(\\s*)/(\\s*)" + string4 + "(\\s*)>";
        string6 = "</" + string3 + ">";
        string7 = string7.replaceAll(string5, string6);
        return string7;
    }

    public static String fixSpacesBTWUTFCharCodes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "(\\s{0,})&#(\\d{3,4});(\\s{0,})";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        boolean bl = false;
        int n = 0;
        while (matcher.find()) {
            String string3 = matcher.group();
            String string4 = string3.replaceAll("\\s", "&nbsp;");
            stringBuffer.append(string.substring(n, matcher.start()));
            stringBuffer.append(string4);
            n = matcher.end();
            bl = true;
        }
        if (bl) {
            stringBuffer.append(string.substring(n, string.length()));
            return stringBuffer.toString();
        }
        return string;
    }

    public static String encodeInUTF(String string) {
        StringBuffer stringBuffer = new StringBuffer(2 * string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '\u007f') {
                stringBuffer.append('&');
                stringBuffer.append('#');
                stringBuffer.append(String.valueOf((int)c));
                stringBuffer.append(';');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void setupHTMLMessageBody(AbstractItem abstractItem) {
        String string = abstractItem.getHTMLBodyTextFile();
        try {
            FileReader fileReader = new FileReader(string);
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = fileReader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            fileReader.close();
            String string2 = HTMLUtils.replaceTags(stringBuffer.toString(), "DIV", "P");
            string2 = HTMLUtils.replaceTags(string2, "STRONG", "B");
            string2 = HTMLUtils.replaceTags(string2, "EM", "I");
            abstractItem.setMessage(string2);
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
    }

    public static void convertPlainTextToHTMLMessageBody(AbstractItem abstractItem) {
        String string = abstractItem.getMessage().getMessage();
        String string2 = LinkParser.createLinkedText(string);
        abstractItem.setMessage(string2);
    }

    public static String fixChars(String string) {
        return string.replace('\u2011', '-');
    }

    private static StringBuffer readFile(String string, String string2) throws IOException {
        Charset charset = Charset.forName(string2);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), charset);
        StringBuffer stringBuffer = HTMLUtils.readStream(inputStreamReader);
        inputStreamReader.close();
        return stringBuffer;
    }

    public static void removeEscapeChars(URL uRL) {
        try {
            String string = uRL.getPath();
            String string2 = "ISO-8859-1";
            StringBuffer stringBuffer = HTMLUtils.readFile(string, string2);
            stringBuffer = HTMLUtils.checkPageEncoding(stringBuffer, string, string2);
            StringBuffer stringBuffer2 = new StringBuffer();
            char[] cArray = stringBuffer.toString().toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == '\u0000' || c == '\ufffd') continue;
                stringBuffer2.append(c);
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");
            outputStreamWriter.write(stringBuffer2.toString());
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            logger.debug((Object)exception, (Throwable)exception);
        }
    }

    private static StringBuffer checkPageEncoding(StringBuffer stringBuffer, String string, String string2) throws IOException {
        int n;
        String string3 = stringBuffer.toString();
        if (string3.length() > 3) {
            switch (string3.charAt(0)) {
                case '\u00ef': {
                    if (string3.charAt(1) != '\u00bb' || string3.charAt(2) != '\u00bf') break;
                    return HTMLUtils.readFile(string, "UTF-8");
                }
                case '\u00fe': {
                    if (string3.charAt(1) != '\u00ff') break;
                    return HTMLUtils.readFile(string, "UTF-16BE");
                }
                case '\u00ff': {
                    if (string3.charAt(1) != '\u00fe') break;
                    return HTMLUtils.readFile(string, "UTF-16LE");
                }
            }
        }
        if ((n = string3.toLowerCase().indexOf("body")) == -1) {
            return stringBuffer;
        }
        String string4 = stringBuffer.toString().substring(0, n);
        Iterator<String> iterator = Charset.availableCharsets().keySet().iterator();
        while (iterator.hasNext()) {
            String string5 = iterator.next();
            boolean bl = string5.matches("(?i)utf.*16");
            boolean bl2 = string5.matches(string2);
            boolean bl3 = string4.matches("(?i)(?s).*\\<META[^\\<\\>]*" + string5 + "[^\\<\\>]*\\>.*");
            if (bl2 || bl || !bl3) continue;
            return HTMLUtils.readFile(string, string5);
        }
        return stringBuffer;
    }

    private static StringBuffer readStream(InputStreamReader inputStreamReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = inputStreamReader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer;
    }

    public static String getEmptyHTML() {
        return "<html><body></body></html>";
    }

    public static String getEmptyPlainText() {
        return "";
    }

    public static String getPlainText(JTextPane jTextPane) {
        return HTMLUtils.getPlainText(jTextPane.getDocument());
    }

    public static String getPlainText(Document document) {
        String string = "";
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException);
            logger.debug((Object)badLocationException, (Throwable)badLocationException);
        }
        return string;
    }

    public static String getStyledText(JTextPane jTextPane) {
        String string = "";
        try {
            Document document = jTextPane.getDocument();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = document.getLength();
            EditorKit editorKit = jTextPane.getEditorKit();
            editorKit.write(byteArrayOutputStream, document, 0, n);
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
            if (editorKit instanceof RTFEditorKit) {
                string = RTFUtils.insertGWStyleDefinition(string, HTMLConstants.getDefaultFontSize(3));
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to read document from editor kit [" + jTextPane.getEditorKit().getClass() + "]: " + exception));
            logger.debug((Object)exception, (Throwable)exception);
        }
        return string;
    }

    public static void setDefaultFont(JTextPane jTextPane, String string, int n) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontSize(simpleAttributeSet, n);
        StyleConstants.setFontFamily(simpleAttributeSet, string);
        HTMLUtils.setCharacterAttributes(jTextPane, simpleAttributeSet, false);
    }

    private static void setCharacterAttributes(JEditorPane jEditorPane, AttributeSet attributeSet, boolean bl) {
        StyledEditorKit styledEditorKit = (StyledEditorKit)jEditorPane.getEditorKit();
        MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
        if (bl) {
            mutableAttributeSet.removeAttributes(mutableAttributeSet);
        }
        mutableAttributeSet.addAttributes(attributeSet);
    }

    public static String getCSSFontStyleFromFont(String string, Font font) {
        String string2 = HTMLUtils.setAttribute(string, CSS.Attribute.FONT_FAMILY, font.getFamily());
        string2 = HTMLUtils.setAttribute(string2, CSS.Attribute.FONT_SIZE, Integer.toString(font.getSize()));
        string2 = font.isBold() ? HTMLUtils.setAttribute(string2, CSS.Attribute.FONT_WEIGHT, "bold") : HTMLUtils.removeAttribute(string2, CSS.Attribute.FONT_WEIGHT);
        string2 = font.isItalic() ? HTMLUtils.setAttribute(string2, CSS.Attribute.FONT_STYLE, "italic") : HTMLUtils.removeAttribute(string2, CSS.Attribute.FONT_STYLE);
        return string2;
    }

    public static boolean isDefaultComposeHTML() {
        MachineSettings.TextOption textOption = OptionManager.getInstance().getTextOption();
        boolean bl = textOption.isDefaultComposeHTML();
        return bl && !textOption.isHTMLDisallowed();
    }

    private static void copyRTF2HTMLDocumentContent(DefaultStyledDocument defaultStyledDocument, HTMLDocument hTMLDocument, StyledEditorKit styledEditorKit) {
        HTMLUtils.copyRTFParagraphs(defaultStyledDocument.getDefaultRootElement(), defaultStyledDocument, hTMLDocument, styledEditorKit);
    }

    private static void copyHTML2RTFDocumentContent(HTMLDocument hTMLDocument, DefaultStyledDocument defaultStyledDocument, StyledEditorKit styledEditorKit) {
        HTMLUtils.copyHTMLParagraphs(hTMLDocument.getDefaultRootElement(), hTMLDocument, defaultStyledDocument, false, styledEditorKit);
    }

    public static void copyRTFParagraphs(Element element, DefaultStyledDocument defaultStyledDocument, DefaultStyledDocument defaultStyledDocument2, StyledEditorKit styledEditorKit) {
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            if (element2.getName().equals("content")) {
                try {
                    int n2 = element2.getStartOffset();
                    String string = defaultStyledDocument.getText(n2, element2.getEndOffset() - element2.getStartOffset());
                    logger.debug((Object)("element name: [" + element2.getName() + "] " + "element content: [" + string + "]"));
                    logger.debug((Object)("element - " + element2));
                    if (element2.getStartOffset() >= defaultStyledDocument.getLength()) continue;
                    defaultStyledDocument2.insertString(defaultStyledDocument2.getLength(), string, HTMLUtils.copyFontAttributes(styledEditorKit.getInputAttributes(), element2.getAttributes()));
                }
                catch (BadLocationException badLocationException) {
                    logger.error((Object)badLocationException);
                    logger.debug((Object)badLocationException, (Throwable)badLocationException);
                }
            } else {
                logger.debug((Object)("--- ignoring element: [" + element2.getName() + "]"));
            }
            HTMLUtils.copyRTFParagraphs(element2, defaultStyledDocument, defaultStyledDocument2, styledEditorKit);
        }
    }

    private static String getElementText(Element element) {
        String string = "";
        try {
            string = element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException);
            logger.debug((Object)badLocationException, (Throwable)badLocationException);
        }
        return string;
    }

    public static void copyHTMLParagraphs(Element element, DefaultStyledDocument defaultStyledDocument, DefaultStyledDocument defaultStyledDocument2, boolean bl, StyledEditorKit styledEditorKit) {
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            if (element2.getName().equals(HTML.Tag.BODY.toString())) {
                bl = true;
            }
            try {
                if (element2.getName().equals(HTML.Tag.CONTENT.toString()) && bl) {
                    int n2 = element2.getStartOffset();
                    String string = defaultStyledDocument.getText(n2, element2.getEndOffset() - element2.getStartOffset());
                    logger.debug((Object)("--- writing element: [" + element2.getName() + "] " + "content: [" + string + "]"));
                    if (element2.getStartOffset() >= defaultStyledDocument.getLength()) continue;
                    defaultStyledDocument2.insertString(defaultStyledDocument2.getLength(), string, HTMLUtils.copyFontAttributes(styledEditorKit.getInputAttributes(), element2.getAttributes()));
                } else if (element2.getName().equals(HTML.Tag.BR.toString()) && bl) {
                    defaultStyledDocument2.insertString(defaultStyledDocument2.getLength(), Utils.LINE_SEPARATOR, HTMLUtils.copyFontAttributes(styledEditorKit.getInputAttributes(), element2.getAttributes()));
                } else {
                    logger.debug((Object)("--- ignoring element: [" + element2.getName() + "] " + "content: [" + HTMLUtils.getElementText(element2) + "]"));
                }
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException);
                logger.debug((Object)badLocationException, (Throwable)badLocationException);
            }
            HTMLUtils.copyHTMLParagraphs(element2, defaultStyledDocument, defaultStyledDocument2, bl, styledEditorKit);
        }
    }

    private static AttributeSet copyFontAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)attributeSet.copyAttributes();
        StyleConstants.setBold(mutableAttributeSet, StyleConstants.isBold(attributeSet2));
        StyleConstants.setItalic(mutableAttributeSet, StyleConstants.isItalic(attributeSet2));
        StyleConstants.setUnderline(mutableAttributeSet, StyleConstants.isUnderline(attributeSet2));
        StyleConstants.setFontFamily(mutableAttributeSet, StyleConstants.getFontFamily(attributeSet2));
        StyleConstants.setFontSize(mutableAttributeSet, StyleConstants.getFontSize(attributeSet2));
        if (attributeSet2.isDefined(StyleConstants.Foreground)) {
            StyleConstants.setForeground(mutableAttributeSet, StyleConstants.getForeground(attributeSet2));
        } else {
            mutableAttributeSet.removeAttribute(StyleConstants.Foreground);
        }
        return mutableAttributeSet;
    }

    public static void convertDocument(int n, Document document, int n2, Document document2, StyledEditorKit styledEditorKit) {
        if (n2 == 1) {
            HTMLUtils.copyRTF2HTMLDocumentContent((DefaultStyledDocument)document, (HTMLDocument)document2, styledEditorKit);
        } else {
            HTMLUtils.copyHTML2RTFDocumentContent((HTMLDocument)document, (DefaultStyledDocument)document2, styledEditorKit);
        }
    }

    public static String setAttribute(String string, CSS.Attribute attribute, String string2) {
        Style style;
        StyleSheet styleSheet = new StyleSheet();
        if (string != null && string.length() != 0) {
            styleSheet.addRule("body {" + string + "}");
            style = styleSheet.getStyle("body");
        } else {
            styleSheet.addRule("body {}");
            style = styleSheet.getStyle("body");
        }
        if (style.getAttribute(attribute) != null) {
            style.removeAttribute(attribute);
        }
        style.addAttribute(attribute, string2);
        String string3 = "";
        Enumeration<?> enumeration = style.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof CSS.Attribute)) continue;
            string3 = string3 + obj.toString() + ": ";
            string3 = string3 + style.getAttribute(obj) + "; ";
        }
        return string3;
    }

    public static Object getAttribute(String string, CSS.Attribute attribute) {
        Style style;
        StyleSheet styleSheet = new StyleSheet();
        if (string != null && string.length() != 0) {
            styleSheet.addRule("body {" + string + "}");
            style = styleSheet.getStyle("body");
        } else {
            styleSheet.addRule("body {}");
            style = styleSheet.getStyle("body");
        }
        return style.getAttribute(attribute);
    }

    public static String removeAttribute(String string, CSS.Attribute attribute) {
        Style style;
        StyleSheet styleSheet = new StyleSheet();
        if (string != null && string.length() != 0) {
            styleSheet.addRule("body {" + string + "}");
            style = styleSheet.getStyle("body");
        } else {
            styleSheet.addRule("body {}");
            style = styleSheet.getStyle("body");
        }
        if (style.getAttribute(attribute) != null) {
            style.removeAttribute(attribute);
        }
        String string2 = "";
        Enumeration<?> enumeration = style.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof CSS.Attribute)) continue;
            string2 = string2 + obj.toString() + ": ";
            string2 = string2 + style.getAttribute(obj) + "; ";
        }
        return string2;
    }

    public static String checkAndUpdateMarginAttribute(String string, CSS.Attribute attribute, int n) {
        Object object = HTMLUtils.getAttribute(string, attribute);
        if (object == null) {
            return HTMLUtils.setAttribute(string, attribute, Integer.toString(n) + "px");
        }
        String string2 = object.toString();
        if (string2.length() < 3 || !"px".equals(string2.substring(string2.length() - 2, string2.length()))) {
            return string;
        }
        int n2 = Integer.parseInt(string2.substring(0, string2.length() - 2));
        if (n2 < n) {
            return HTMLUtils.setAttribute(string, attribute, Integer.toString(n) + "px");
        }
        return string;
    }

    public static float getFontIncreaseFactor() {
        int n = Math.min(95, Toolkit.getDefaultToolkit().getScreenResolution());
        return (float)n / 72.0f;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

