/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.mvc;

import com.appframework.ActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.mvc.ControllerManager;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.LocalCommand;
import com.appframework.mvc.MVCView;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class MVCController {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$mvc$MVCController == null ? (class$com$appframework$mvc$MVCController = MVCController.class$("com.appframework.mvc.MVCController")) : class$com$appframework$mvc$MVCController));
    protected Level level;
    private MVCView view;
    private boolean enabled = true;
    private ArrayList listenersDescriptors;
    static /* synthetic */ Class class$com$appframework$mvc$MVCController;

    public MVCController(Level level) {
        this(LevelManager.getInstance().createLevel(), level);
    }

    protected MVCController(Level level, Level level2) {
        this.level = level;
        this.level.setParent(level2);
        ControllerManager.getInstance().add(this);
        this.listenersDescriptors = new ArrayList();
        this.initListeners();
        this.registerListeners();
    }

    public MVCController(MVCView mVCView, MVCController mVCController) {
        this(mVCController.getLevel());
        this.setMVCView(mVCView);
    }

    protected void initListeners() {
    }

    protected void addListenerDescriptor(AppEventListenerDescriptor appEventListenerDescriptor) {
        this.listenersDescriptors.add(appEventListenerDescriptor);
    }

    private void registerListeners() {
        for (int i = 0; i < this.listenersDescriptors.size(); ++i) {
            AppEventListenerDescriptor appEventListenerDescriptor = (AppEventListenerDescriptor)this.listenersDescriptors.get(i);
            AppEventManager.getInstance().addListener(appEventListenerDescriptor.getLevel(), appEventListenerDescriptor.getCommandID(), appEventListenerDescriptor.getListener());
        }
    }

    public void unRegisterListeners() {
        for (int i = 0; i < this.listenersDescriptors.size(); ++i) {
            AppEventListenerDescriptor appEventListenerDescriptor = (AppEventListenerDescriptor)this.listenersDescriptors.get(i);
            AppEventManager.getInstance().removeListener(appEventListenerDescriptor.getLevel(), appEventListenerDescriptor.getCommandID(), appEventListenerDescriptor.getListener());
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setMVCView(MVCView mVCView) {
        this.view = mVCView;
    }

    public MVCView getMVCView() {
        return this.view;
    }

    public MVCController getParentController() {
        MVCController mVCController = ControllerManager.getInstance().get(this.level.getParent());
        return mVCController;
    }

    public ActionList getActionList() {
        MVCController mVCController;
        for (mVCController = this; !(mVCController instanceof ActionList) && mVCController != null; mVCController = mVCController.getParentController()) {
        }
        if (mVCController instanceof ActionList) {
            return (ActionList)mVCController;
        }
        throw new IllegalStateException();
    }

    public void processCommand(Command command) {
        this.doProcessCommand(command);
    }

    private void doProcessCommand(Command command) {
        AppEvent appEvent = new AppEvent(command.getID());
        appEvent.setSource(this);
        appEvent.setData(command.getCommandObject());
        appEvent.setAttributes(command.getAttributes());
        if (command instanceof GlobalCommand) {
            appEvent.setLevel(LevelManager.getInstance().getGlobalLevel());
            AppEventManager.getInstance().processGlobalEvent(appEvent);
        } else if (command instanceof LocalCommand) {
            LocalCommand localCommand = (LocalCommand)command;
            appEvent.setLevel(localCommand.getTopController().getLevel());
            AppEventManager.getInstance().processEvent(appEvent);
        } else {
            appEvent.setLevel(LevelManager.getInstance().getFrameLevel(this.getLevel()));
            AppEventManager.getInstance().processEvent(appEvent);
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        for (int i = 0; i < this.listenersDescriptors.size(); ++i) {
            AppEventListenerDescriptor appEventListenerDescriptor = (AppEventListenerDescriptor)this.listenersDescriptors.get(i);
            appEventListenerDescriptor.getListener().setListenerEnabled(bl);
        }
        this.setEnabledForChildrens(bl);
    }

    private void setEnabledForChildrens(boolean bl) {
        List list = this.level.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Level level = (Level)list.get(i);
            ControllerManager.getInstance().get(level).setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

