/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.selection;

import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.appframework.selection.SelectionManager;
import java.util.Hashtable;

public class SelectionManagersFactory {
    private Hashtable managers = new Hashtable();
    private static SelectionManagersFactory instance;

    public static SelectionManagersFactory getInstance() {
        if (instance == null) {
            instance = new SelectionManagersFactory();
        }
        return instance;
    }

    private SelectionManager createManager(Level level) {
        SelectionManager selectionManager = new SelectionManager();
        this.managers.put(level, selectionManager);
        return selectionManager;
    }

    public void releaseManager(Level level) {
        this.managers.remove(level);
    }

    public SelectionManager getManager(MVCController mVCController) {
        Level level = LevelManager.getInstance().getFrameLevel(mVCController.getLevel());
        SelectionManager selectionManager = (SelectionManager)this.managers.get(level);
        if (selectionManager == null) {
            selectionManager = this.createManager(level);
        }
        return selectionManager;
    }

    public void clearAll() {
        this.managers.clear();
    }
}

