/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import org.apache.log4j.Logger;

public final class Assertions {
    public static void assertIllegalState(String string) {
        throw new IllegalStateException("Assertion failed. " + string);
    }

    public static void assertIllegalArgument(String string) {
        throw new IllegalArgumentException("Assertion failed. " + string);
    }

    public static void assertNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("Assertion failed. " + string);
        }
    }

    public static void assertNotNull(Object object, String string, Logger logger) {
        if (object == null) {
            logger.error((Object)("Assertion failed. " + string));
            throw new IllegalArgumentException("Assertion failed. " + string);
        }
    }

    public static final void assertNonZeroLengthArray(Object[] objectArray, String string) {
        Assertions.assertNotNull(objectArray, "Array parameter is null");
        if (objectArray.length == 0) {
            throw new IllegalArgumentException("Assertion failed. " + string);
        }
    }

    public static final void assertNonZeroLengthString(String string, String string2) {
        Assertions.assertNotNull(string, "String parameter is null");
        if (string.length() == 0) {
            throw new IllegalArgumentException("Assertion failed. " + string2);
        }
    }

    public static final void assertNonZeroLengthString(String string, String string2, Logger logger) {
        Assertions.assertNotNull(string, "String parameter is null");
        if (string.length() == 0) {
            logger.error((Object)("Assertion failed. " + string2));
            throw new IllegalArgumentException("Assertion failed. " + string2);
        }
    }

    public static final void assertClass(Object object, Class clazz, Logger logger) {
        if (!clazz.isInstance(object)) {
            String string = "Assertion failed. Illegal argument class type";
            logger.error((Object)string);
            throw new IllegalArgumentException(string);
        }
    }

    public static void assertIllegalMethodAccess() {
        throw new IllegalStateException("Illegall method access");
    }
}

