/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.Application;
import com.appframework.cache.IDObjectsCollection;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.popedit.StringParser;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.DirPathDialog;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.PathManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class Utils {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$utils$Utils == null ? (class$com$appframework$utils$Utils = Utils.class$("com.appframework.utils.Utils")) : class$com$appframework$utils$Utils));
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final String USER_HOME = System.getProperty("user.home");
    private static final String FILE_RUN_BAT = "run.bat";
    public static final String PROTOCOL_PREFIX_FILE = "file:";
    private static boolean bJVM1_5Supported = true;
    private static Class urlConnectClass = class$java$net$HttpURLConnection == null ? (class$java$net$HttpURLConnection = Utils.class$("java.net.HttpURLConnection")) : class$java$net$HttpURLConnection;
    private static Class[] parmTypes = new Class[]{Integer.TYPE};
    private static Method setConnectTimeout = null;
    private static Method setReadTimeout = null;
    private static Object[] fiveSeconds = new Object[]{new Integer(5000)};
    private static Object[] tenSeconds = new Object[]{new Integer(10000)};
    static /* synthetic */ Class class$com$appframework$utils$Utils;
    static /* synthetic */ Class class$java$net$HttpURLConnection;

    public static void runShellAsync(String[] stringArray) {
        new ShellStarter(stringArray).start();
    }

    public static String getExtention(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        String string2 = file.getName();
        int n = string2.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        String string3 = string2.substring(n + 1);
        return string3;
    }

    public static String getClassDirectory(Class clazz) {
        String string = clazz.getName();
        URL uRL = clazz.getResource(string.substring(string.lastIndexOf(".") + 1) + ".class");
        StringBuffer stringBuffer = new StringBuffer(new File(uRL.getFile()).getParent());
        stringBuffer.append(System.getProperty("file.separator"));
        return stringBuffer.toString();
    }

    public static void compareString(String string, String string2) {
        String string3 = "";
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            string3 = string.substring(0, i);
            if (string2.substring(0, i).equals(string3)) continue;
            logger.debug((Object)("the string are different, beginning from index [" + string3.length() + "]"));
            logger.debug((Object)("same part is [" + string3 + "]"));
            logger.debug((Object)("must be [" + string2.substring(i - 1) + "]"));
            logger.debug((Object)("is [" + string.substring(i - 1) + "]"));
            break;
        }
    }

    public static String normalizePreviewFileName(String string) {
        String string2 = string.toUpperCase();
        if (!string2.endsWith(".HTML") && !string2.endsWith(".HTM")) {
            string = string + ".html";
        }
        return string;
    }

    public static File getExistingParentFile(File file) {
        if (file == null) {
            return null;
        }
        File file2 = file;
        while (!file2.exists()) {
            if ((file2 = file2.getParentFile()) != null) continue;
            return null;
        }
        return file2;
    }

    public static String getFileName(String string) {
        File file = new File(string);
        return file.getName();
    }

    public static void invokeCommandAndWait(MVCController mVCController, Command command) {
        if (SwingUtilities.isEventDispatchThread()) {
            new CommandRunner(mVCController, command).run();
        } else {
            try {
                SwingUtilities.invokeAndWait(new CommandRunner(mVCController, command));
            }
            catch (InterruptedException interruptedException) {
                logger.error((Object)interruptedException, (Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.error((Object)invocationTargetException, (Throwable)invocationTargetException);
            }
        }
    }

    public static void invokeCommandLater(MVCController mVCController, Command command) {
        if (SwingUtilities.isEventDispatchThread()) {
            new CommandRunner(mVCController, command).run();
        } else {
            SwingUtilities.invokeLater(new CommandRunner(mVCController, command));
        }
    }

    public static Color invertColor(Color color) {
        return new Color(~color.getRGB());
    }

    public static void finalizeDelete(IDObjectsCollection iDObjectsCollection) {
        Application.disposeFrame(iDObjectsCollection);
    }

    public static void callExternal(String string) {
        String[] stringArray;
        logger.debug((Object)"callExternal entered");
        while (string.indexOf(8209) != -1) {
            string = string.replace('\u2011', '-');
        }
        if (OS.isMacOS()) {
            stringArray = new String[]{"open", string};
        } else if (OS.isWinOS()) {
            stringArray = new String[]{Utils.getRunPath(), string};
        } else if (OS.isLinuxOS()) {
            stringArray = OS.isKDESession() ? new String[]{"kfmclient", "exec", string} : new String[]{"gnome-open", string};
        } else {
            throw new IllegalStateException("Unrecognized OS");
        }
        Utils.runShellAsync(stringArray);
        logger.debug((Object)"callExternal exited");
    }

    private static String getRunPath() {
        String string = PathManager.getInstance().getTempFolderPath() + FILE_RUN_BAT;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            fileOutputStream.write("start \"\" %1".getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static void clearDir(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                Utils.clearDir(file2);
            }
            file2.delete();
        }
    }

    public static boolean fileExists(String string) {
        if (string != null && string != "") {
            return new File(string).exists();
        }
        return false;
    }

    public static boolean sameFiles(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        File file = new File(string);
        File file2 = new File(string2);
        return file.compareTo(file2) == 0;
    }

    public static List getFileList(String string) {
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\u0000') {
            string = string.substring(0, string.length() - 1);
        }
        List list = StringParser.getTokens(string, "\r\n");
        ArrayList<Comparable<File>> arrayList = new ArrayList<Comparable<File>>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Comparable<File> comparable;
            String string2 = (String)list.get(i);
            if (string2.startsWith(PROTOCOL_PREFIX_FILE)) {
                try {
                    comparable = new URI(string2);
                    string2 = ((URI)comparable).getPath();
                }
                catch (URISyntaxException uRISyntaxException) {
                    logger.debug((Object)("failed to create URI for: " + string2));
                    string2 = string2.substring(PROTOCOL_PREFIX_FILE.length() + 2);
                }
            }
            if (((File)(comparable = new File(string2))).exists()) {
                arrayList.add(comparable);
                continue;
            }
            logger.debug((Object)("following file was not found: " + comparable));
        }
        logger.debug((Object)("found files: " + arrayList.size()));
        return arrayList;
    }

    public static HttpURLConnection followRedirects(HttpURLConnection httpURLConnection) throws IOException {
        boolean bl;
        int n = 0;
        do {
            try {
                if (bJVM1_5Supported) {
                    if (setConnectTimeout == null) {
                        setConnectTimeout = urlConnectClass.getMethod("setConnectTimeout", parmTypes);
                    }
                    if (setReadTimeout == null) {
                        setReadTimeout = urlConnectClass.getMethod("setReadTimeout", parmTypes);
                    }
                    setConnectTimeout.invoke((Object)httpURLConnection, fiveSeconds);
                    setReadTimeout.invoke((Object)httpURLConnection, fiveSeconds);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                bJVM1_5Supported = false;
                logger.debug((Object)noSuchMethodException, (Throwable)noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.error((Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.error((Object)invocationTargetException, (Throwable)invocationTargetException);
            }
            httpURLConnection.setInstanceFollowRedirects(false);
            bl = false;
            int n2 = httpURLConnection.getResponseCode();
            if (n2 < 300 || n2 > 305 || n2 == 304) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            if (uRL2 == null || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            httpURLConnection = (HttpURLConnection)uRL2.openConnection();
            ++n;
        } while (bl);
        if (!(httpURLConnection instanceof HttpURLConnection)) {
            throw new IOException(httpURLConnection.getURL() + " redirected to non-http URL");
        }
        return httpURLConnection;
    }

    public static String validateExtention(String string, String string2) {
        String string3;
        String string4 = Utils.getExtention(string);
        if (string4.equals(string) && !(string3 = Utils.getExtention(string2)).equals(string2)) {
            return string + "." + string3;
        }
        return string;
    }

    public static Font deriveFontForSize(Font font, float f) {
        if (font == null) {
            return null;
        }
        return Utils.deriveFont(font, font.getStyle(), f);
    }

    public static Font deriveFont(Font font, int n) {
        if (font == null) {
            return null;
        }
        return Utils.deriveFont(font, n, font.getSize());
    }

    public static Font deriveFont(Font font, int n, float f) {
        if (font == null) {
            return null;
        }
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, font.getFontName());
        hashMap.put(TextAttribute.SIZE, new Float(f));
        hashMap.put(TextAttribute.WEIGHT, (n & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        hashMap.put(TextAttribute.POSTURE, (n & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        return new Font(hashMap);
    }

    public static boolean isValidExtension(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("") || string2.indexOf(47) == -1 && string2.indexOf(46) == -1 && string2.indexOf(32) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean checkArchivePath(String string) {
        String string2 = GWCommandManager.getInstance(string).getArchiveLocation();
        if (!Utils.fileExists(string2)) {
            String string3 = DirPathDialog.getPath(string2, StringResources.PATH_TO_ARCHIVE_FOLDER, StringResources.ENTER_PATH_TO_ARCHIVE_FOLDER_C);
            if (string3 != null) {
                boolean bl;
                File file = new File(string3);
                boolean bl2 = bl = file.mkdirs() || Utils.fileExists(string3);
                if (bl) {
                    OptionManager.getInstance().setArchiveDir(string3, string);
                    return true;
                }
                return Utils.checkArchivePath(string);
            }
            return false;
        }
        return true;
    }

    public static boolean isKDESession() {
        String[] stringArray = new String[]{"/bin/sh", "-c", "echo $KDE_FULL_SESSION"};
        String[] stringArray2 = new String[]{"/bin/sh", "-c", "echo $GDMSESSION"};
        return Utils.commandOutputContains(stringArray, "true") || Utils.commandOutputContains(stringArray2, "kde");
    }

    private static boolean commandOutputContains(String[] stringArray, String string) {
        boolean bl = false;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            String string2 = stringArray[0];
            StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "PROCCESS: " + string2 + " ERROR");
            streamGobbler.start();
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                bl = bl || string3.toLowerCase().indexOf(string) != -1;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream inputStream, String string) {
            this.is = inputStream;
            this.type = string;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(this.type + ">" + string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static class ShellStarter
    extends Thread {
        private String[] commands;

        public ShellStarter(String[] stringArray) {
            this.commands = stringArray;
        }

        public void run() {
            try {
                logger.debug((Object)"EXECUTING SHELL COMMAND: ");
                for (int i = 0; i < this.commands.length; ++i) {
                    logger.debug((Object)this.commands[i]);
                }
                Process process = Runtime.getRuntime().exec(this.commands);
                String string = this.commands[0];
                StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "PROCCESS: " + string + " ERROR");
                StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), "PROCCESS: " + string + " OUTPUT");
                streamGobbler.start();
                streamGobbler2.start();
            }
            catch (IOException iOException) {
                logger.debug((Object)iOException, (Throwable)iOException);
                String string = iOException.getMessage();
                JOptionPane.showMessageDialog(null, string, StringResources.CANNOT_EXECUTE_SHELL_COMMAND_C, 0);
            }
        }
    }

    static class CommandRunner
    implements Runnable {
        private MVCController controller;
        private Command command;

        public CommandRunner(MVCController mVCController, Command command) {
            this.controller = mVCController;
            this.command = command;
        }

        public void run() {
            this.controller.processCommand(this.command);
        }
    }
}

