/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.ActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.ContactTablePopupMenu;
import com.novell.gw.jclient.application.controls.addressbook.table.AbstractAddressBookTable;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.event.TableModelEvent;

public class ContactsTable
extends AbstractAddressBookTable {
    private JPopupMenu popupMenu = new ContactTablePopupMenu(this.getController().getActionList());

    public ContactsTable(MVCController mVCController) {
        super(mVCController, null);
        this.columnsIDs = new int[]{3, 9, 28, 29, 31, 32, 30};
        this.model.fireTableStructureChanged();
        this.setDefaultColumnSize();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ContactsTable.this.doPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ContactsTable.this.doPopup(mouseEvent);
            }
        });
        this.getTableHeader().setReorderingAllowed(false);
        this.getSelectionModel().addListSelectionListener(new AbstractAddressBookTable.ABSelectionListener(this));
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (keyEvent.getKeyCode() == n) {
                    ContactsTable.this.controller.getActionList().performAction("Remove Directory Entry");
                }
            }
        });
    }

    private void doPopup(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.isPopupTrigger() && (n = this.rowAtPoint(mouseEvent.getPoint())) != -1) {
            if (this.getSelectedRowCount() <= 1) {
                this.setRowSelectionInterval(n, n);
            }
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.fireCountChanged();
    }

    private void fireCountChanged() {
        if (this.getController() != null) {
            this.getController().processCommand(new Command(820, new Integer(this.model.getRowCount())));
        }
    }

    protected void performDefaultAction() {
        ActionList actionList = this.getController().getActionList();
        actionList.performAction("Directory Entry Details");
    }

    public void removeListeners() {
        if (this.addressBookItemList != null) {
            this.addressBookItemList.removeItemListListener(this.gwListDataListener);
        }
    }

    protected void addListeners() {
        if (this.addressBookItemList != null) {
            this.addressBookItemList.removeItemListListener(this.gwListDataListener);
            this.addressBookItemList.addItemListListener(this.gwListDataListener);
        }
    }

    protected void update() {
        int n = this.getSelectedRow();
        super.update();
        this.selectNearestRow(n);
    }

    public void setMVCModel(Object object) {
        if (object instanceof ContactsFolder) {
            this.selectedDirectory = null;
            this.selectedDirectory = EngineCommandManager.getContactsFolderAddressBook();
            this.selectedEntries.clear();
            this.removeListeners();
            this.addressBookItemList = ((ContactsFolder)object).getItemList();
            this.model.updateData(this.addressBookItemList);
            this.addListeners();
            this.controller.processCommand(new Command(1160, this));
        }
    }
}

