/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class GWSplash
extends JFrame {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$GWSplash == null ? (class$com$novell$gw$jclient$application$GWSplash = GWSplash.class$("com.novell.gw.jclient.application.GWSplash")) : class$com$novell$gw$jclient$application$GWSplash));
    private static GWSplash instance = null;
    private JLabel imageLabel;
    private JLabel textLabel;
    private Timer pointsTimer;
    private String text;
    private StringBuffer textBuffer = new StringBuffer(100);
    private boolean isLeftToRight = true;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$GWSplash;

    public static GWSplash getInstance() {
        if (instance == null) {
            instance = new GWSplash();
        }
        return instance;
    }

    private GWSplash() {
        super(StringResources.GROUPWISE_CLIENT + " ");
        this.setUndecorated(true);
        this.setIconImage(ImageResources.GW_ICON.getImage());
        ComponentOrientation componentOrientation = UIUtils.getComponentOrientation();
        this.isLeftToRight = componentOrientation.isLeftToRight();
        this.imageLabel = new OrientableLabel(ControlsUtils.getSplashImage());
        this.textLabel = new OrientableLabel();
        this.textLabel.setComponentOrientation(componentOrientation);
        this.textLabel.setPreferredSize(new Dimension(15, PLAFChanger.getFontSize() + 3));
        this.textLabel.setFont(new Font(PLAFChanger.getFontName(), 0, PLAFChanger.getFontSize() - 2));
        this.textLabel.setBackground(Color.WHITE);
        this.textLabel.setForeground(Color.RED);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.add((Component)this.imageLabel, "Center");
        jPanel.add((Component)this.textLabel, "South");
        this.pointsTimer = new Timer(1000, new TimerListener());
    }

    public void startConnecting() {
        if (SwingUtilities.isEventDispatchThread()) {
            new SetTextRunner().run();
        } else {
            try {
                SwingUtilities.invokeAndWait(new SetTextRunner());
            }
            catch (Exception exception) {
                logger.debug((Object)exception, (Throwable)exception);
            }
        }
        this.pointsTimer.start();
    }

    public void stopConnecting() {
        this.pointsTimer.stop();
    }

    private synchronized void initTextLabel() {
        this.textBuffer.delete(0, this.textBuffer.length());
        this.text = StringResources.CONNECTING;
        this.textLabel.setText(this.text);
    }

    private synchronized void addPoint() {
        if (this.isLeftToRight) {
            this.textBuffer.append(' ');
            this.textBuffer.append('.');
            this.textBuffer.append(' ');
        } else {
            this.textBuffer.insert(0, ' ');
            this.textBuffer.insert(0, '.');
            this.textBuffer.insert(0, ' ');
        }
    }

    private synchronized void updateProgressLabel() {
        this.addPoint();
        FontMetrics fontMetrics = this.textLabel.getFontMetrics(this.textLabel.getFont());
        String string = this.textBuffer.toString();
        string = this.text + string;
        if (this.textLabel.getWidth() > fontMetrics.stringWidth(string)) {
            this.textLabel.setText(string);
        } else {
            this.initTextLabel();
        }
    }

    public void dispose() {
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            logger.error((Object)throwable, throwable);
        }
        super.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GWSplash.this.updateProgressLabel();
        }
    }

    private class SetTextRunner
    implements Runnable {
        private SetTextRunner() {
        }

        public void run() {
            GWSplash.this.initTextLabel();
        }
    }
}

