/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.AppActionModel;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.Command;
import com.novell.gw.ab.GroupContact;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.resources.StringResources;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public abstract class AbstractAddressBookAction
extends AppAction {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$actions$AbstractAddressBookAction == null ? (class$com$novell$gw$jclient$application$actions$AbstractAddressBookAction = AbstractAddressBookAction.class$("com.novell.gw.jclient.application.actions.AbstractAddressBookAction")) : class$com$novell$gw$jclient$application$actions$AbstractAddressBookAction));
    protected List allRecipients = new ArrayList();
    protected List validRecipients = new ArrayList();
    protected boolean isSendingFromAddressBook;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$actions$AbstractAddressBookAction;

    public AbstractAddressBookAction(ActionList actionList, AppActionModel appActionModel) {
        super(actionList, appActionModel);
    }

    protected boolean validateRecipients() {
        Object object;
        int n;
        this.validRecipients.clear();
        for (n = 0; n < this.allRecipients.size(); ++n) {
            object = ((Recipient)this.allRecipients.get(n)).getAddressable();
            if (!(object instanceof GroupContact) && object.getEmailAddress().equals("")) continue;
            this.validRecipients.add(this.allRecipients.get(n));
        }
        n = this.allRecipients.size() - this.validRecipients.size();
        if (n > 0) {
            object = StringResources.formatString(StringResources.IN_ATTEMPTING_TO_USE, new String[]{new Integer(n).toString()});
            int n2 = JOptionPane.showConfirmDialog(this.getActionList().getOwnerComponent(), object, StringResources.ADDRESS_BOOK_K_QUESTION, 2);
            return n2 == 0;
        }
        return true;
    }

    public boolean isSendingFromAddressBook() {
        return this.isSendingFromAddressBook;
    }

    public void setSendingFromAddressBook(boolean bl) {
        this.isSendingFromAddressBook = bl;
    }

    void sendRecipients(FrameCompose frameCompose) {
        if (!this.validRecipients.isEmpty()) {
            Command command = new Command(100, new ArrayList(this.validRecipients));
            frameCompose.getController().processCommand(command);
        }
    }

    protected abstract boolean checkAccess();

    protected void registerListeners() {
        Level level = LevelManager.getInstance().getFrameLevel(this.getActionList().getLevel());
        AppEventListener appEventListener = new ABRecipientsSelectedListener();
        AppEventManager.getInstance().addListener(level, 110, appEventListener);
        appEventListener = new ClearListener();
        AppEventManager.getInstance().addListener(level, 360, appEventListener);
        AppEventManager.getInstance().addListener(level, 270, appEventListener);
        appEventListener = new StoreModeChangedListener();
        AppEventManager.getInstance().addListener(level, 800, appEventListener);
        appEventListener = new PROXY_DATA_STORE_INSTALLED_Listener();
        AppEventManager.getInstance().addListener(level, 750, appEventListener);
        appEventListener = new FolderSelectedListener();
        AppEventManager.getInstance().addListener(level, 10, appEventListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FolderSelectedListener
    extends AppEventListener {
        private FolderSelectedListener() {
        }

        public void handle(AppEvent appEvent) {
            AbstractAddressBookAction.this.allRecipients.clear();
            AbstractAddressBookAction.this.validRecipients.clear();
        }
    }

    private class PROXY_DATA_STORE_INSTALLED_Listener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            AbstractAddressBookAction.this.setEnabled(AbstractAddressBookAction.this.checkAccess());
        }
    }

    private class StoreModeChangedListener
    extends AppEventListener {
        private StoreModeChangedListener() {
        }

        public void handle(AppEvent appEvent) {
            StorageMode storageMode = (StorageMode)appEvent.getData();
            AbstractAddressBookAction.this.setEnabled(storageMode.isNormal());
        }
    }

    private class ClearListener
    extends AppEventListener {
        private ClearListener() {
        }

        public void handle(AppEvent appEvent) {
            AbstractAddressBookAction.this.allRecipients.clear();
            AbstractAddressBookAction.this.validRecipients.clear();
        }
    }

    private class ABRecipientsSelectedListener
    extends AppEventListener {
        private ABRecipientsSelectedListener() {
        }

        public void handle(AppEvent appEvent) {
            AbstractAddressBookAction.this.allRecipients = (List)appEvent.getData();
        }
    }
}

