/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.AppActionModel;
import com.appframework.Application;
import com.appframework.ApplicationFrame;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.engine.ItemListListener;
import com.novell.gw.jclient.application.actions.item.ActionOpenItem;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.ItemDescription;

public abstract class AbstractNavigationAction
extends AppAction {
    private NavigationActionItemListener listener = new NavigationActionItemListener();
    private MVCController parentMainFrameController;
    private ItemList list;

    public AbstractNavigationAction(ActionList actionList, AppActionModel appActionModel) {
        super(actionList, appActionModel);
        this.setEnabled(false);
    }

    protected void updateViewFrame(AbstractItem abstractItem, ItemDescription itemDescription) {
        ActionOpenItem actionOpenItem = (ActionOpenItem)this.getActionList().getAction("Open Item");
        actionOpenItem.setOpenCascade(false);
        actionOpenItem.doOpenItem(itemDescription, this.getParentMainFrameController());
        actionOpenItem.setOpenCascade(true);
        Application.disposeFrame(abstractItem);
    }

    protected void updateSelection(AbstractItem abstractItem) {
        if (this.getParentMainFrameController() != null) {
            Command command = new Command(870, abstractItem);
            this.getParentMainFrameController().processCommand(command);
        }
    }

    protected void registerListeners() {
        Level level = LevelManager.getInstance().getFrameLevel(this.getActionList().getLevel());
        AppEventListener appEventListener = new GWITEM_SELECTED_Listener();
        AppEventManager.getInstance().addListener(level, 20, appEventListener);
        appEventListener = new MAINFRAME_CONTROLLER_SELECTED_Listener();
        AppEventManager.getInstance().addListener(level, 1070, appEventListener);
        appEventListener = new WINDOW_CLOSED_Listener();
        AppEventManager.getInstance().addListener(level, 490, appEventListener);
    }

    public abstract void checkEnabled();

    private void setParentMainFrameController(MVCController mVCController) {
        this.parentMainFrameController = mVCController;
        this.checkEnabled();
    }

    protected MVCController getParentMainFrameController() {
        return this.parentMainFrameController;
    }

    private class WINDOW_CLOSED_Listener
    extends AppEventListener {
        private WINDOW_CLOSED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ApplicationFrame applicationFrame = (ApplicationFrame)appEvent.getData();
            if (applicationFrame.getController() == null) {
                return;
            }
            Level level = applicationFrame.getController().getLevel();
            if (AbstractNavigationAction.this.list != null) {
                AbstractNavigationAction.this.list.removeItemListListener((ItemListListener)AbstractNavigationAction.this.listener);
            }
            if (AbstractNavigationAction.this.getParentMainFrameController() != null && AbstractNavigationAction.this.getParentMainFrameController().getLevel().equals(level)) {
                AbstractNavigationAction.this.setParentMainFrameController(null);
            }
        }
    }

    private class NavigationActionItemListener
    implements ItemListListener {
        private NavigationActionItemListener() {
        }

        public void contentsChanged(ItemListEvent itemListEvent) {
            AbstractNavigationAction.this.checkEnabled();
        }

        public void moreResultsAvailable(ItemListEvent itemListEvent) {
            AbstractNavigationAction.this.checkEnabled();
        }

        public void queryResultsDone(ItemListEvent itemListEvent) {
            AbstractNavigationAction.this.checkEnabled();
        }
    }

    private class MAINFRAME_CONTROLLER_SELECTED_Listener
    extends AppEventListener {
        private MAINFRAME_CONTROLLER_SELECTED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            AbstractNavigationAction.this.setParentMainFrameController((MVCController)appEvent.getData());
        }
    }

    private class GWITEM_SELECTED_Listener
    extends AppEventListener {
        private GWITEM_SELECTED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemDescription itemDescription = (ItemDescription)appEvent.getData();
            AbstractNavigationAction.this.list = GWCommandManager.getInstance(AbstractNavigationAction.this.getUserGuid()).getItemListForItem(itemDescription.getItem());
            AbstractNavigationAction.this.list.addItemListListener((ItemListListener)AbstractNavigationAction.this.listener);
            AbstractNavigationAction.this.setMVCModel(itemDescription);
            AbstractNavigationAction.this.checkEnabled();
        }
    }
}

