/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.components.GWTextArea;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.RadioButtonGroup;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class AcceptDeclineOptionPane
extends JComponent {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$actions$AcceptDeclineOptionPane == null ? (class$com$novell$gw$jclient$application$actions$AcceptDeclineOptionPane = AcceptDeclineOptionPane.class$("com.novell.gw.jclient.application.actions.AcceptDeclineOptionPane")) : class$com$novell$gw$jclient$application$actions$AcceptDeclineOptionPane));
    private static final String BUTTON_PRESSED_PROPERTY = "buttonPressed";
    private static final int MODE_ACCEPT = 1;
    private static final int MODE_DECLINE = 2;
    private int mode = 1;
    private AbstractItem item;
    private Options selectedOptions = null;
    private ButtonGroup bgAcceptLevel;
    private JRadioButton rbFree;
    private JRadioButton rbTentative;
    private JRadioButton rbBusy;
    private JRadioButton rbOutOfOffice;
    private JTextArea taComment;
    private JCheckBox cbDeleteItem;
    private JButton btnOK;
    private JButton btnCancel;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$actions$AcceptDeclineOptionPane;

    public static Options showAcceptWithOptionsOptionPane(Component component, AbstractItem abstractItem) {
        AcceptDeclineOptionPane acceptDeclineOptionPane = new AcceptDeclineOptionPane(1, abstractItem);
        JDialog jDialog = acceptDeclineOptionPane.createDialog(component, StringResources.ACCEPT_WITH_OPTIONS);
        jDialog.show();
        jDialog.dispose();
        return acceptDeclineOptionPane.getSelectedOptions();
    }

    public static Options showDeclineWithOptionsOptionPane(Component component, AbstractItem abstractItem) {
        AcceptDeclineOptionPane acceptDeclineOptionPane = new AcceptDeclineOptionPane(2, abstractItem);
        JDialog jDialog = acceptDeclineOptionPane.createDialog(component, StringResources.DECLINE_WITH_OPTIONS);
        jDialog.show();
        jDialog.dispose();
        return acceptDeclineOptionPane.getSelectedOptions();
    }

    private JDialog createDialog(Component component, String string) {
        final JDialog jDialog = component instanceof JFrame ? new JDialog((JFrame)component, string, true) : (component instanceof JDialog ? new JDialog((JDialog)component, string, true) : new JDialog((Frame)null, string, true));
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        this.init(jDialog);
        jDialog.getRootPane().setDefaultButton(this.btnOK);
        jDialog.pack();
        jDialog.setModal(true);
        jDialog.setLocationRelativeTo(component);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jDialog.setVisible(false);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (jDialog.isVisible() && propertyChangeEvent.getSource() == AcceptDeclineOptionPane.this && propertyChangeEvent.getPropertyName().equals(AcceptDeclineOptionPane.BUTTON_PRESSED_PROPERTY) && propertyChangeEvent.getNewValue() != null) {
                    jDialog.setVisible(false);
                }
            }
        });
        this.taComment.requestFocus();
        return jDialog;
    }

    private AcceptDeclineOptionPane(int n, AbstractItem abstractItem) throws HeadlessException {
        this.item = abstractItem;
        this.mode = n;
    }

    private void init(Window window) {
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.buildUI(window);
        this.setMode();
    }

    private void buildUI(Window window) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 7);
        this.add(this.createShowAsPanel(window), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 7, 10, 10);
        this.add(this.createCommentPanel(), gridBagConstraints);
        gridBagConstraints.anchor = 20;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add(this.createButtonsPanel(), gridBagConstraints);
    }

    private Component createButtonsPanel() {
        this.cbDeleteItem = new JMnemonicCheckBox(StringResources.CHECK_BOX_DELETE_ITEM);
        this.cbDeleteItem.addActionListener(new DeleteItemCheckBoxActionListener());
        this.btnOK = new JButton(new OKButtonAction());
        this.btnCancel = new JButton(new CancelButtonAction());
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new GridLayout(0, 2, 7, 0));
        OS.addButtons(orientablePanel, this.btnOK, this.btnCancel);
        OrientablePanel orientablePanel2 = new OrientablePanel();
        orientablePanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        orientablePanel2.add((Component)this.cbDeleteItem, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        orientablePanel2.add((Component)orientablePanel, gridBagConstraints);
        return orientablePanel2;
    }

    private Component createCommentPanel() {
        this.taComment = new GWTextArea();
        JMnemonicLabel jMnemonicLabel = new JMnemonicLabel(StringResources.TEXT_AREA_COMMENT_LABEL, this.taComment);
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new BorderLayout(0, 5));
        orientablePanel.add((Component)jMnemonicLabel, "North");
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.taComment);
        orientablePanel.add((Component)orientableScrollPane, "Center");
        orientableScrollPane.setPreferredSize(new Dimension(200, orientableScrollPane.getPreferredSize().height));
        return orientablePanel;
    }

    private Component createShowAsPanel(Window window) {
        this.rbFree = new JMnemonicRadioButton(StringResources.RADIO_BUTTON_FREE);
        this.rbTentative = new JMnemonicRadioButton(StringResources.RADIO_BUTTON_TENTATIVE);
        this.rbBusy = new JMnemonicRadioButton(StringResources.RADIO_BUTTON_BUSY);
        this.rbOutOfOffice = new JMnemonicRadioButton(StringResources.RADIO_BUTTON_OUT_OF_OFFICE);
        this.bgAcceptLevel = new RadioButtonGroup(window);
        this.bgAcceptLevel.add(this.rbFree);
        this.bgAcceptLevel.add(this.rbTentative);
        this.bgAcceptLevel.add(this.rbBusy);
        this.bgAcceptLevel.add(this.rbOutOfOffice);
        OrientablePanel orientablePanel = new OrientablePanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1));
        titledBorder.setTitle(StringResources.SHOW_AS);
        orientablePanel.setBorder(titledBorder);
        orientablePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        orientablePanel.add((Component)this.rbFree, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        orientablePanel.add((Component)this.rbTentative, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        orientablePanel.add((Component)this.rbBusy, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        orientablePanel.add((Component)this.rbOutOfOffice, gridBagConstraints);
        return orientablePanel;
    }

    private void setMode() {
        if (this.item instanceof AppointmentItem) {
            this.selectAcceptLevelRutton(((AppointmentItem)this.item).getShowAsLevel());
            if (this.mode == 1) {
                this.cbDeleteItem.setEnabled(false);
                if (this.bgAcceptLevel.getSelection() == null) {
                    this.rbBusy.setSelected(true);
                }
            } else if (this.mode == 2) {
                if (this.bgAcceptLevel.getSelection() == null) {
                    this.rbFree.setSelected(true);
                }
                this.cbDeleteItem.setSelected(true);
                this.setEnabledAcceptLevelPanel(false);
            }
        } else {
            this.setEnabledAcceptLevelPanel(false);
            this.cbDeleteItem.setEnabled(false);
        }
    }

    private void selectAcceptLevelRutton(int n) {
        if (n == 210) {
            this.rbBusy.setSelected(true);
        } else if (n == 160) {
            this.rbFree.setSelected(true);
        } else if (n == 251) {
            this.rbOutOfOffice.setSelected(true);
        } else if (n == 190) {
            this.rbTentative.setSelected(true);
        }
    }

    private void setEnabledAcceptLevelPanel(boolean bl) {
        this.rbFree.setEnabled(bl);
        this.rbTentative.setEnabled(bl);
        this.rbBusy.setEnabled(bl);
        this.rbOutOfOffice.setEnabled(bl);
    }

    private Options getSelectedOptions() {
        return this.selectedOptions;
    }

    private void setSelectedOptions(Options options) {
        this.selectedOptions = options;
    }

    private void fireButtonPressed(Object object) {
        this.firePropertyChange(BUTTON_PRESSED_PROPERTY, null, object);
    }

    private int getSelectedAcceptLevel() {
        int n = -1;
        if (this.rbFree.isSelected()) {
            n = 160;
        } else if (this.rbTentative.isSelected()) {
            n = 190;
        } else if (this.rbBusy.isSelected()) {
            n = 210;
        } else if (this.rbOutOfOffice.isSelected()) {
            n = 251;
        }
        return n;
    }

    private Options createSelectedOptins() {
        Options options = new Options();
        options.setAcceptLevel(this.getSelectedAcceptLevel());
        options.setDeleteItem(this.cbDeleteItem.isSelected());
        options.setComment(this.taComment.getText());
        return options;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Options {
        int acceptLevel;
        boolean deleteItem;
        String comment;

        public int getAcceptLevel() {
            return this.acceptLevel;
        }

        public void setAcceptLevel(int n) {
            this.acceptLevel = n;
        }

        public boolean isDeleteItem() {
            return this.deleteItem;
        }

        public void setDeleteItem(boolean bl) {
            this.deleteItem = bl;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String string) {
            this.comment = string;
        }

        public String toString() {
            return "[acceptLevel=" + this.getAcceptLevel() + ", " + "deleteItem=" + this.isDeleteItem() + ", " + "comment=" + this.getComment() + "]";
        }
    }

    private class DeleteItemCheckBoxActionListener
    implements ActionListener {
        private DeleteItemCheckBoxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AcceptDeclineOptionPane acceptDeclineOptionPane = AcceptDeclineOptionPane.this;
            if (acceptDeclineOptionPane.mode == 2) {
                acceptDeclineOptionPane.setEnabledAcceptLevelPanel(!acceptDeclineOptionPane.cbDeleteItem.isSelected());
            }
        }
    }

    private class CancelButtonAction
    extends AbstractAction {
        public CancelButtonAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AcceptDeclineOptionPane.this.fireButtonPressed(actionEvent.getSource());
        }
    }

    private class OKButtonAction
    extends AbstractAction {
        public OKButtonAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AcceptDeclineOptionPane acceptDeclineOptionPane = AcceptDeclineOptionPane.this;
            acceptDeclineOptionPane.setSelectedOptions(acceptDeclineOptionPane.createSelectedOptins());
            AcceptDeclineOptionPane.this.fireButtonPressed(actionEvent.getSource());
        }
    }
}

