/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.AppActionModel;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWSharedFolderNotification;
import com.novell.gw.jclient.bl.om.items.ItemDescription;
import com.novell.gw.jclient.bl.om.items.SharedAddressBookNotificationItem;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ActionOpenEmlItem
extends AppAction {
    Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$actions$ActionOpenEmlItem == null ? (class$com$novell$gw$jclient$application$actions$ActionOpenEmlItem = ActionOpenEmlItem.class$("com.novell.gw.jclient.application.actions.ActionOpenEmlItem")) : class$com$novell$gw$jclient$application$actions$ActionOpenEmlItem));
    static /* synthetic */ Class class$com$novell$gw$jclient$application$actions$ActionOpenEmlItem;

    public ActionOpenEmlItem(ActionList actionList) {
        super(actionList, new AppActionModel("open eml item", "Open eml item"));
    }

    protected void performAction(ActionEvent actionEvent) {
        File file = (File)this.getMVCModel();
        if (file == null) {
            this.logger.warn((Object)"Trying to open invalid file: [null]");
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            MimeMessage mimeMessage = new MimeMessage(null, (InputStream)fileInputStream);
            String[] stringArray = mimeMessage.getHeader("GWItemID");
            if (stringArray == null || stringArray.length < 1) {
                this.showInvalidMessageDialog();
                return;
            }
            String string = stringArray[0];
            if (string == null || string.trim().equals("")) {
                this.showInvalidMessageDialog();
                return;
            }
            AbstractItem abstractItem = GWCommandManager.getInstance(this.getUserGuid()).find(string);
            if (abstractItem != null) {
                if (abstractItem instanceof GWSharedFolderNotification || abstractItem instanceof SharedAddressBookNotificationItem) {
                    this.logger.warn((Object)("Trying to open unsupported message. Message type: [" + abstractItem.getClass() + "]. Skipped."));
                    return;
                }
                AppAction appAction = this.getActionList().getAction("Open Item");
                appAction.setMVCModel(new ItemDescription(abstractItem));
                appAction.setEnabled(true);
                this.getActionList().performAction("Open Item");
            } else {
                this.logger.warn((Object)("Invalid GroupWise item selected. Can't load from storage item with GID: [" + string + "]."));
                this.showInvalidMessageDialog();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.formatString(StringResources.CANT_FIND_FILE, new String[]{file.getAbsolutePath()}), StringResources.GROUPWISE_CLIENT, 0);
        }
        catch (MessagingException messagingException) {
            this.logger.error((Object)messagingException);
            this.logger.debug((Object)messagingException, (Throwable)messagingException);
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.formatString(StringResources.CANT_OPEN_FILE, new String[]{file.getAbsolutePath()}), StringResources.GROUPWISE_CLIENT, 0);
        }
        catch (GWCommandException gWCommandException) {
            this.logger.error((Object)gWCommandException, (Throwable)gWCommandException);
            ErrorDialog.processGWException(gWCommandException, this.getActionList().getOwnerComponent());
        }
    }

    private void showInvalidMessageDialog() {
        JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), "Not GroupWise item selected. Preview function for these items is not ready now.", StringResources.GROUPWISE_CLIENT, 2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

