/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.edit.text;

import com.appframework.ActionList;
import com.appframework.AppActionModel;
import com.appframework.components.htmleditor.GWMozillaBrowserCanvas;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.edit.text.AbstractFindAction;
import com.novell.gw.jclient.application.dialogs.FindTextConditions;
import com.novell.gw.jclient.application.dialogs.FindTextDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class ActionFindText
extends AbstractFindAction {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$actions$edit$text$ActionFindText == null ? (class$com$novell$gw$jclient$application$actions$edit$text$ActionFindText = ActionFindText.class$("com.novell.gw.jclient.application.actions.edit.text.ActionFindText")) : class$com$novell$gw$jclient$application$actions$edit$text$ActionFindText));
    private FindTextConditions conditions = new FindTextConditions();
    private FindTextDialog findTextDialog;
    private String lastSearchText = "";
    private boolean lastSearchSuccsseful = false;
    private boolean blocked = false;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$actions$edit$text$ActionFindText;
    static /* synthetic */ Class class$javax$swing$JScrollPane;

    public ActionFindText(ActionList actionList) {
        super(actionList, new AppActionModel("find text", StringResources.FIND_TEXT_D));
        if (OS.isMacOS()) {
            this.appActionModel.setAccelerator(KeyStroke.getKeyStroke(70, OS.getMetaKey()));
        } else {
            this.appActionModel.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        }
    }

    public void setMVCModel(Object object) {
        super.setMVCModel(object);
        if (object == null) {
            this.lastSearchSuccsseful = false;
            this.lastSearchText = "";
            this.getActionList().getAction("find next").setEnabled(false);
            this.getActionList().getAction("find previous").setEnabled(false);
            this.conditions = new FindTextConditions();
            if (this.findTextDialog != null) {
                this.findTextDialog.dispose();
            }
        }
    }

    private String getTargetText() {
        String string = "";
        try {
            Document document = ((JTextComponent)this.getMVCModel()).getDocument();
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException);
            logger.debug((Object)badLocationException, (Throwable)badLocationException);
        }
        return string;
    }

    public void performFindText() {
        this.getActionList().getAction("find next").setEnabled(true);
        this.getActionList().getAction("find previous").setEnabled(true);
        if (!this.conditions.getSearchText().equals("")) {
            if (this.getMVCModel() instanceof JTextComponent) {
                this.searchInTextPane();
            } else if (this.getMVCModel() instanceof GWMozillaBrowserCanvas) {
                this.searchInExternalBrowser();
            }
        }
    }

    private void searchInExternalBrowser() {
        if (this.blocked) {
            return;
        }
        GWMozillaBrowserCanvas gWMozillaBrowserCanvas = (GWMozillaBrowserCanvas)this.getMVCModel();
        boolean bl = gWMozillaBrowserCanvas.findInPage(this.conditions.getSearchText(), this.conditions.isMatchCase(), this.conditions.isMatchWholeWord(), this.conditions.isUpDirection());
        if (bl) {
            this.lastSearchSuccsseful = true;
            this.lastSearchText = this.conditions.getSearchText();
            if (this.findTextDialog.isVisible()) {
                this.findTextDialog.toFront();
            }
        } else {
            boolean bl2 = this.lastSearchSuccsseful && this.lastSearchText.equals(this.conditions.getSearchText());
            this.blocked = true;
            this.displayWarningMessage(bl2);
            this.blocked = false;
            this.lastSearchSuccsseful = false;
            this.lastSearchText = "";
        }
    }

    private void searchInTextPane() {
        this.conditions.setTextIndex(((JTextComponent)this.getMVCModel()).getCaretPosition());
        int n = this.search();
        if (n != -1) {
            this.selectMatchedText(n);
            this.lastSearchSuccsseful = true;
            this.lastSearchText = this.conditions.getSearchText();
            if (this.findTextDialog.isVisible()) {
                this.findTextDialog.toFront();
            }
        } else {
            if (this.lastSearchSuccsseful && this.lastSearchText.equals(this.conditions.getSearchText())) {
                this.displayWarningMessage(true);
            } else {
                this.displayWarningMessage(false);
            }
            this.lastSearchSuccsseful = false;
            this.lastSearchText = "";
        }
    }

    private void selectMatchedText(int n) {
        JTextComponent jTextComponent = (JTextComponent)this.getMVCModel();
        jTextComponent.requestFocus();
        jTextComponent.select(n, n + this.conditions.getSearchText().length());
    }

    private void displayWarningMessage(boolean bl) {
        Window window = this.findTextDialog != null && this.findTextDialog.isVisible() ? this.findTextDialog : SwingUtilities.getWindowAncestor((Component)this.getMVCModel());
        String string = bl ? StringResources.FINISHED_SEARCHING_DOCUMENT : StringResources.CANNOT_FIND + " \"" + this.conditions.getSearchText() + "\".";
        JOptionPane.showMessageDialog(window, string, StringResources.NOVELL_GROUPWISE, 2);
    }

    private int search() {
        int n;
        String string = this.getTargetText();
        String string2 = this.conditions.getSearchText();
        if (!this.conditions.isMatchCase()) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        do {
            if ((n = this.conditions.isUpDirection() ? this.searchBackward(string, string2) : this.searchForward(string, string2)) == -1) continue;
            this.conditions.setTextIndex(n + string2.length());
        } while (!this.isWholeWord(n, string, string2) && n != -1);
        return n;
    }

    private boolean isWholeWord(int n, String string, String string2) {
        if (n == -1) {
            return false;
        }
        if (!this.conditions.isMatchWholeWord()) {
            return true;
        }
        int n2 = n;
        int n3 = n + string2.length();
        return !(n2 != 0 && Character.isLetterOrDigit(string.toCharArray()[n2 - 1]) || n3 != string.length() && Character.isLetterOrDigit(string.toCharArray()[n3]));
    }

    private int searchForward(String string, String string2) {
        return string.indexOf(string2, this.conditions.getTextIndex());
    }

    private int searchBackward(String string, String string2) {
        int n = this.conditions.getTextIndex();
        if (n == -1) {
            n = string.length();
        }
        String string3 = string.substring(0, n -= string2.length());
        return string3.lastIndexOf(string2, n);
    }

    public void setConditions(FindTextConditions findTextConditions) {
        this.conditions = findTextConditions;
    }

    public void setUpDirection(boolean bl) {
        this.conditions.setUpDirection(bl);
    }

    protected void performAction(ActionEvent actionEvent) {
        if (!this.isValid()) {
            return;
        }
        Component component = (Component)this.getMVCModel();
        if (this.findTextDialog != null && this.findTextDialog.isVisible()) {
            this.findTextDialog.requestFocus();
        } else {
            this.findTextDialog = new FindTextDialog((JFrame)SwingUtilities.getWindowAncestor(component), this.conditions, this);
            this.findTextDialog.pack();
            this.findTextDialog.setLocationRelativeTo(SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = ActionFindText.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, component));
            this.findTextDialog.setVisible(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

