/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.edit.text;

import com.appframework.ActionList;
import com.appframework.AppActionModel;
import com.appframework.components.htmleditor.GWMozillaBrowserCanvas;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.resources.ImageResources;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.edit.text.EditAction;
import com.novell.gw.jclient.application.dialogs.fontchooser.FontChooserDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.apache.log4j.Logger;

public class ActionFont
extends EditAction {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$actions$edit$text$ActionFont == null ? (class$com$novell$gw$jclient$application$actions$edit$text$ActionFont = ActionFont.class$("com.novell.gw.jclient.application.actions.edit.text.ActionFont")) : class$com$novell$gw$jclient$application$actions$edit$text$ActionFont));
    private static final Font DEFAULT_FONT = new Font("Arial", 0, 12);
    private static final String[] HTML_FONT_SIZES = new String[]{"8", "10", "12", "14", "18", "24", "36"};
    private FontChooserDialog fontDialog;
    private boolean inBody;
    private Font lastSelectedFont = null;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$actions$edit$text$ActionFont;
    static /* synthetic */ Class class$javax$swing$JScrollPane;

    public ActionFont(ActionList actionList) {
        super(actionList, new AppActionModel("font", StringResources.FONT_C, ImageResources.ACT_FONT));
        KeyStroke keyStroke = OS.isMacOS() ? KeyStroke.getKeyStroke(120, OS.getMetaKey()) : KeyStroke.getKeyStroke(120, 0);
        this.appActionModel.setAccelerator(keyStroke);
    }

    private void setHTMLTextPaneFont(Font font) {
        HTMLTextPane hTMLTextPane = (HTMLTextPane)this.getMVCModel();
        if (hTMLTextPane.getMode() == 1) {
            HTMLDocument hTMLDocument = (HTMLDocument)hTMLTextPane.getDocument();
            hTMLTextPane.setDocument(new HTMLDocument());
            Element element = hTMLDocument.getDefaultRootElement();
            this.inBody = false;
            this.setElementFont(hTMLDocument, element, font, 0);
            hTMLTextPane.setDocument(hTMLDocument);
        } else if (hTMLTextPane.getMode() == 2 || hTMLTextPane.getMode() == 3) {
            hTMLTextPane.setRTFTextFont(font);
        }
    }

    private void setBrowserFont(Font font) {
        GWMozillaBrowserCanvas gWMozillaBrowserCanvas = (GWMozillaBrowserCanvas)this.getMVCModel();
        gWMozillaBrowserCanvas.setBrowserFont(font);
    }

    private void setElementFont(HTMLDocument hTMLDocument, Element element, Font font, int n) {
        int n2;
        AttributeSet attributeSet = element.getAttributes();
        HTML.Tag tag = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.BODY) {
            this.inBody = !this.inBody;
        } else if (this.inBody && tag == HTML.Tag.P || tag == HTML.Tag.DIV || tag == HTML.Tag.CONTENT || tag == HTML.Tag.IMPLIED) {
            boolean bl;
            n2 = element.getStartOffset();
            int n3 = element.getEndOffset();
            int n4 = n3 - n2;
            boolean bl2 = bl = element.getName().length() == n4;
            if (!bl && n3 > n) {
                n = n3;
                int n5 = n2;
                Element element2 = null;
                SimpleAttributeSet simpleAttributeSet = null;
                while (n5 < n3) {
                    element2 = hTMLDocument.getCharacterElement(n5);
                    int n6 = element2.getStartOffset();
                    n5 = element2.getEndOffset();
                    int n7 = n5 - n6;
                    simpleAttributeSet = new SimpleAttributeSet(element2.getAttributes());
                    simpleAttributeSet.removeAttribute(CSS.Attribute.FONT_SIZE);
                    simpleAttributeSet.removeAttribute(CSS.Attribute.FONT_STYLE);
                    simpleAttributeSet.removeAttribute(CSS.Attribute.FONT_FAMILY);
                    simpleAttributeSet.removeAttribute(CSS.Attribute.FONT_WEIGHT);
                    simpleAttributeSet.removeAttribute(HTML.Tag.FONT);
                    simpleAttributeSet.addAttribute(StyleConstants.FontFamily, font.getFamily());
                    simpleAttributeSet.addAttribute(StyleConstants.FontSize, new Integer(font.getSize()));
                    simpleAttributeSet.addAttribute(StyleConstants.Italic, font.isItalic());
                    simpleAttributeSet.addAttribute(StyleConstants.Bold, font.isBold());
                    hTMLDocument.setCharacterAttributes(n6, n7, simpleAttributeSet, true);
                }
            }
        }
        for (n2 = 0; n2 < element.getElementCount(); ++n2) {
            Element element3 = element.getElement(n2);
            this.setElementFont(hTMLDocument, element3, font, n);
        }
    }

    public void setMVCModel(Object object) {
        super.setMVCModel(object);
        if (this.getMVCModel() instanceof HTMLTextPane || object instanceof GWMozillaBrowserCanvas) {
            this.lastSelectedFont = null;
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private Font getFont() {
        HTMLTextPane hTMLTextPane = (HTMLTextPane)this.getMVCModel();
        this.inBody = false;
        if (hTMLTextPane.getDocument() instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)hTMLTextPane.getDocument();
            Element element = hTMLDocument.getDefaultRootElement();
            return this.getElementFont(hTMLDocument, element, 0);
        }
        StyledDocument styledDocument = hTMLTextPane.getStyledDocument();
        int n = hTMLTextPane.getCaretPosition();
        if (n > 0) {
            Element element = styledDocument.getCharacterElement(n - 1);
            AttributeSet attributeSet = element.getAttributes();
            return styledDocument.getFont(attributeSet);
        }
        return hTMLTextPane.getFont();
    }

    private Font getElementFont(HTMLDocument hTMLDocument, Element element, int n) {
        int n2;
        AttributeSet attributeSet = element.getAttributes();
        HTML.Tag tag = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.BODY) {
            this.inBody = !this.inBody;
        } else if (this.inBody && tag == HTML.Tag.P || tag == HTML.Tag.DIV || tag == HTML.Tag.CONTENT || tag == HTML.Tag.IMPLIED) {
            boolean bl;
            n2 = element.getStartOffset();
            int n3 = element.getEndOffset();
            int n4 = n3 - n2;
            boolean bl2 = bl = element.getName().length() == n4;
            if (!bl && n3 > n) {
                n = n3;
                Element element2 = hTMLDocument.getCharacterElement(n2);
                AttributeSet attributeSet2 = element2.getAttributes();
                return hTMLDocument.getFont(attributeSet2);
            }
        }
        for (n2 = 0; n2 < element.getElementCount(); ++n2) {
            Element element3 = element.getElement(n2);
            Font font = this.getElementFont(hTMLDocument, element3, n);
            if (font == null) continue;
            return font;
        }
        return null;
    }

    protected void performAction(ActionEvent actionEvent) {
        if (!this.isValid()) {
            return;
        }
        Component component = (Component)this.getMVCModel();
        this.fontDialog = new FontChooserDialog((JFrame)SwingUtilities.getWindowAncestor(component));
        this.fontDialog.setModal(true);
        Component component2 = this.getMVCModel() instanceof GWMozillaBrowserCanvas ? component : SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = ActionFont.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, component);
        this.fontDialog.setLocationRelativeTo(component2);
        this.fontDialog.setFont(this.getOldFont(), HTML_FONT_SIZES);
        this.fontDialog.pack();
        this.fontDialog.setVisible(true);
        Font font = this.fontDialog.getChoosenFont();
        if (font == null) {
            return;
        }
        this.lastSelectedFont = font;
        if (this.getMVCModel() instanceof HTMLTextPane) {
            this.setHTMLTextPaneFont(font);
        } else if (this.getMVCModel() instanceof GWMozillaBrowserCanvas) {
            this.setBrowserFont(font);
        }
    }

    private Font getOldFont() {
        Font font = null;
        if (this.lastSelectedFont != null) {
            font = this.lastSelectedFont;
        } else if (this.getMVCModel() instanceof HTMLTextPane) {
            font = this.getFont();
        }
        if (font == null) {
            font = DEFAULT_FONT;
        }
        return font;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

