/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.edit.text;

import azcheck.ui.JSpellDialog;
import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.AppActionModel;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class ActionSpellCheck
extends AppAction {
    private JTextComponent textComponent;

    public ActionSpellCheck(ActionList actionList) {
        super(actionList, new AppActionModel("Spell Checker", StringResources.ACTION_SPELL_CHECKER));
        if (OS.isLinuxOS()) {
            this.appActionModel.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        } else {
            this.appActionModel.setAccelerator(KeyStroke.getKeyStroke(112, OS.getMetaKey()));
        }
        this.setEnabled(false);
    }

    protected void performAction(ActionEvent actionEvent) {
        try {
            JSpellDialog.check((JTextComponent)this.textComponent, (String)OS.getDictLanguage());
        }
        catch (Exception exception) {
            try {
                JSpellDialog.check((JTextComponent)this.textComponent, null);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    protected void registerListeners() {
        Level level = LevelManager.getInstance().getFrameLevel(this.getActionList().getLevel());
        DirtySpellCheckListener dirtySpellCheckListener = new DirtySpellCheckListener();
        AppEventManager.getInstance().addListener(level, 560, dirtySpellCheckListener);
    }

    private class DirtySpellCheckListener
    extends AppEventListener {
        private DirtySpellCheckListener() {
        }

        public void handle(AppEvent appEvent) {
            ActionSpellCheck.this.textComponent = (JTextComponent)appEvent.getData();
            ActionSpellCheck.this.setEnabled(true);
        }
    }
}

