/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.components.AbstractOKAction;
import com.appframework.components.GWTextArea;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class RetractDialog
extends BasicDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$actions$item$RetractDialog == null ? (class$com$novell$gw$jclient$application$actions$item$RetractDialog = RetractDialog.class$("com.novell.gw.jclient.application.actions.item.RetractDialog")) : class$com$novell$gw$jclient$application$actions$item$RetractDialog));
    public static final int MY_MAILBOX = 0;
    public static final int RECIPIENTS_MAILBOX = 1;
    public static final int ALL_MAILBOX = 2;
    public static final int ACTION_CANCELED = 3;
    private JPanel pnlCheckID;
    private JRadioButton rbMyMailBox;
    private JRadioButton rbRecipients;
    private JRadioButton rbAll;
    private JLabel lbRetract;
    private JTextArea taRetractComment;
    private JButton btnOK;
    private JButton btnCancel;
    private ButtonGroup buttonGroup;
    private int result = -1;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$actions$item$RetractDialog;

    private RetractDialog(Dialog dialog) {
        super(dialog);
        this.buildUI();
    }

    private RetractDialog(Frame frame) {
        super(frame);
        this.buildUI();
    }

    private RetractDialog() {
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.DELETE_ITEM);
        this.pnlCheckID = new OrientablePanel();
        this.pnlCheckID.setLayout(new BoxLayout(this.pnlCheckID, 3));
        this.pnlCheckID.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ' ' + StringResources.DELETE_ITEM + ' '));
        CommentsEnabler commentsEnabler = new CommentsEnabler();
        this.rbMyMailBox = new JMnemonicRadioButton(new CommentsDisabler());
        this.rbRecipients = new OrientableRadioButton(commentsEnabler);
        UIUtils.setText(this.rbRecipients, StringResources.RECIPIENTS_MAILBOX);
        this.rbAll = new OrientableRadioButton(commentsEnabler);
        UIUtils.setText(this.rbAll, StringResources.ALL_MAILBOXES);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.rbMyMailBox);
        this.buttonGroup.add(this.rbRecipients);
        this.buttonGroup.add(this.rbAll);
        this.rbMyMailBox.setSelected(true);
        this.lbRetract = new OrientableLabel(StringResources.RETRACT_COMMENT);
        this.taRetractComment = new GWTextArea(5, 20);
        this.setEnabledCommentArea(false);
        this.btnOK = new JButton(new ButtonOKAction());
        this.btnCancel = new JButton(new ButtonCancelAction());
        this.pnlCheckID.add(this.rbMyMailBox);
        this.pnlCheckID.add(this.rbRecipients);
        this.pnlCheckID.add(this.rbAll);
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, -2, 3, -2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        orientablePanel.add((Component)this.pnlCheckID, gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        orientablePanel.add((Component)this.lbRetract, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 6, 0);
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        orientablePanel.add((Component)new OrientableScrollPane(this.taRetractComment), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        orientablePanel.add((Component)this.btnOK, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        orientablePanel.add((Component)this.btnCancel, gridBagConstraints);
        orientablePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(orientablePanel);
        this.setDefaultButton(this.btnOK);
        this.setCancelButton(this.btnCancel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RetractDialog.this.result = 3;
            }
        });
    }

    private int getResultID() {
        if (this.result == -1) {
            this.result = this.rbMyMailBox.isSelected() ? 0 : (this.rbRecipients.isSelected() ? 1 : 2);
        }
        return this.result;
    }

    private String getRetractComment() {
        return this.taRetractComment.getText();
    }

    public static Result showDialog(Component component) {
        Window window = ControlsUtils.getWindowForComponent(component);
        RetractDialog retractDialog = window instanceof Frame ? new RetractDialog((Frame)component) : (window instanceof Dialog ? new RetractDialog((Dialog)component) : new RetractDialog());
        retractDialog.setModal(true);
        UIUtils.centerWindow((Window)retractDialog, component);
        retractDialog.pack();
        retractDialog.setVisible(true);
        return new Result(retractDialog.getResultID(), retractDialog.getRetractComment());
    }

    private void setEnabledCommentArea(boolean bl) {
        this.taRetractComment.setEnabled(bl);
        this.taRetractComment.setBackground(bl ? Color.WHITE : Color.GRAY.brighter());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CommentsDisabler
    extends AbstractAction {
        public CommentsDisabler() {
            super(StringResources.MY_MAILBOX);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RetractDialog.this.setEnabledCommentArea(false);
        }
    }

    private class CommentsEnabler
    extends AbstractAction {
        private CommentsEnabler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RetractDialog.this.setEnabledCommentArea(true);
        }
    }

    private class ButtonCancelAction
    extends AbstractAction {
        public ButtonCancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RetractDialog.this.result = 3;
            RetractDialog.this.setVisible(false);
        }
    }

    private class ButtonOKAction
    extends AbstractOKAction {
        private ButtonOKAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RetractDialog.this.setVisible(false);
        }
    }

    public static class Result {
        private int resultID;
        private String comment = "";

        private Result(int n, String string) {
            if (n < 0 || n > 3) {
                throw new IllegalArgumentException();
            }
            this.resultID = n;
            this.comment = string;
        }

        public String getComment() {
            return this.comment;
        }

        public int getResultID() {
            return this.resultID;
        }
    }
}

