/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.Contact;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorCloseListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.addressbook.SimpleSelectorDialog;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class AddressSelector
extends JComponent {
    protected SearchTextField searchField;
    protected AbstractButton pickerButton;
    private SimpleSelectorDialog dialog;
    private MVCController controller;
    private AddressSelectorCloseListener closeListener;

    public AddressSelector(Contact contact, MVCController mVCController) {
        this.controller = mVCController;
        this.init();
        this.setContact(contact);
    }

    public void setContact(Contact contact) {
        if (contact != null) {
            this.searchField.setTextToParse(contact.getDisplayName());
        }
    }

    public Contact getContact() {
        return this.searchField.getContact();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.searchField = new SearchTextField();
        this.add((Component)this.searchField, "Center");
        this.initPickerButton();
        GWToolBar gWToolBar = new GWToolBar();
        gWToolBar.add(this.pickerButton);
        gWToolBar.setBorder(null);
        this.add((Component)gWToolBar, "After");
    }

    private void initPickerButton() {
        this.pickerButton = UIUtils.createToolButton(new ContactPickerAction());
        this.pickerButton.setIcon(ImageResources.ICON_ACT_VIEW_ADDRESS_SELECTOR);
    }

    private void createDialog() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JFrame) {
            this.dialog = new SimpleSelectorDialog((JFrame)window, this.controller);
        }
        if (window instanceof JDialog) {
            this.dialog = new SimpleSelectorDialog((JDialog)window, this.controller);
        }
    }

    private void showDialog() {
        this.createDialog();
        this.dialog.setSelectedEntry(this.searchField.getContact());
        this.dialog.showMe();
        if (this.dialog.isActionCompleteSuccessfully()) {
            Contact contact = this.dialog.getSelectedEntry();
            this.setContact(contact);
            if (this.closeListener != null && contact != null) {
                this.closeListener.contactSelected(contact);
            }
        }
    }

    public JTextComponent getTextComponent() {
        return this.searchField;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.pickerButton.setIcon(imageIcon);
    }

    public void setText(String string) {
        this.searchField.setText(string);
    }

    public void selectAll() {
        this.searchField.selectAll();
    }

    public String getText() {
        return this.searchField.getText();
    }

    public void setSearchResultListener(SearchResultListener searchResultListener) {
        this.searchField.setListener(searchResultListener);
    }

    public void setAddressSelectorCloseListener(AddressSelectorCloseListener addressSelectorCloseListener) {
        this.closeListener = addressSelectorCloseListener;
    }

    public void updateListener() {
        this.searchField.updateListener();
    }

    public void requestFocus() {
        this.searchField.requestFocus();
    }

    private class ContactPickerAction
    extends AbstractAction {
        private ContactPickerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddressSelector addressSelector = AddressSelector.this;
            if (!addressSelector.searchField.isFocusOwner()) {
                addressSelector.searchField.grabFocus();
            }
            addressSelector.showDialog();
        }
    }
}

