/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.novell.gw.ab.Address;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.popedit.DisambiguationDialog;
import com.novell.gw.jclient.application.controls.popedit.StringParser;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class SearchTextField
extends OrientableTextField {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$SearchTextField == null ? (class$com$novell$gw$jclient$application$controls$addressbook$SearchTextField = SearchTextField.class$("com.novell.gw.jclient.application.controls.addressbook.SearchTextField")) : class$com$novell$gw$jclient$application$controls$addressbook$SearchTextField));
    public static final char[] DELIMETERS = new char[]{';', ','};
    private static final String[] STR_DELIMETERS;
    private TimerAction timerAction = new TimerAction();
    private Timer timer = new Timer(400, this.timerAction);
    protected List foundContacts;
    private int contactIndex;
    protected Contact foundContact;
    private SearchResultListener listener;
    private DisambiguationDialog dialog;
    protected boolean processFocusEvents = true;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$SearchTextField;

    public SearchTextField() {
        this.setDocument(new SearchDocument());
        this.addKeyListener(new PEKeyListener());
        this.timer.setRepeats(false);
    }

    public void setListener(SearchResultListener searchResultListener) {
        this.listener = searchResultListener;
    }

    public boolean addToRecipiensList() {
        String string = this.getText();
        if (!string.trim().equals("")) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                this.timerAction.actionPerformed(null);
            }
            Object object = this.foundContacts == null ? new Address(string, string) : (Contact)this.foundContacts.get(this.contactIndex);
            boolean bl = this.addToList((Addressable)object);
            this.clearSearchResult();
            this.timerAction.searchText = "";
            this.setText("");
            return bl;
        }
        return false;
    }

    private void removeSameContacts(Contact contact) {
        if (this.foundContacts != null && this.foundContacts.size() > 1) {
            for (int i = 0; i < this.foundContacts.size(); ++i) {
                Contact contact2 = (Contact)this.foundContacts.get(i);
                if (!contact2.getDisplayName().equalsIgnoreCase(contact.getDisplayName()) || contact2.equals((Object)contact)) continue;
                this.foundContacts.remove(contact2);
            }
        }
    }

    private boolean addToList(Addressable addressable) {
        boolean bl = false;
        if (addressable instanceof Contact) {
            List list = this.getSameContacts((Contact)addressable);
            if (!(list.size() <= 1 || this.dialog != null && this.dialog.isShowing())) {
                Window window = ControlsUtils.getWindowForComponent(this);
                this.dialog = window instanceof Frame ? new DisambiguationDialog((JFrame)window, list) : new DisambiguationDialog((JDialog)window, list);
                this.processFocusEvents = false;
                this.dialog.showMe();
                this.processFocusEvents = true;
                if (this.dialog.isActionCompleteSuccessfully()) {
                    addressable = this.dialog.getSelectedContact();
                    this.removeSameContacts((Contact)addressable);
                    if (this.listener != null) {
                        this.listener.searchFinished(new SearchEvent(addressable));
                    }
                    bl = true;
                }
            } else {
                if (this.listener != null) {
                    this.listener.searchFinished(new SearchEvent(addressable));
                }
                bl = true;
            }
        } else {
            if (this.listener != null) {
                this.listener.searchFinished(new SearchEvent(addressable));
            }
            bl = true;
        }
        return bl;
    }

    public void setText(String string) {
        SearchDocument searchDocument = (SearchDocument)this.getDocument();
        searchDocument.setParseString(false);
        super.setText(string);
        searchDocument.setParseString(true);
    }

    public void clearAndSetText(String string) {
        this.foundContact = null;
        this.setText(string);
    }

    private boolean isLastContactBeginWith(String string) {
        return this.foundContacts != null && ((Contact)this.foundContacts.get(this.contactIndex)).getDisplayName().toLowerCase().startsWith(string.toLowerCase());
    }

    public Contact getFoundContact() {
        return this.foundContact;
    }

    public void updateListener() {
        this.addToRecipiensList();
    }

    private List getSameContacts(Contact contact) {
        ArrayList<Contact> arrayList = new ArrayList<Contact>();
        if (this.foundContacts != null && this.foundContacts.size() > 1) {
            int n;
            for (n = 0; n < this.foundContacts.size(); ++n) {
                Contact contact2 = (Contact)this.foundContacts.get(n);
                if (!contact2.getDisplayName().equalsIgnoreCase(contact.getDisplayName())) continue;
                arrayList.add(contact2);
            }
            n = arrayList.size();
            if (n > 1) {
                boolean bl = true;
                Contact contact3 = (Contact)arrayList.get(0);
                for (int i = 1; i < n; ++i) {
                    Contact contact4 = (Contact)arrayList.get(i);
                    if (contact3.getEmailAddress().equalsIgnoreCase(contact4.getEmailAddress())) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    arrayList.clear();
                    arrayList.add(contact3);
                }
            }
        }
        return arrayList;
    }

    private Contact getPrevContact() {
        this.contactIndex = this.contactIndex == 0 ? this.foundContacts.size() - 1 : --this.contactIndex;
        return (Contact)this.foundContacts.get(this.contactIndex);
    }

    private Contact getNextContact() {
        this.contactIndex = this.contactIndex == this.foundContacts.size() - 1 ? 0 : ++this.contactIndex;
        return (Contact)this.foundContacts.get(this.contactIndex);
    }

    protected Addressable search(String string) {
        Address address = null;
        this.clearSearchResult();
        try {
            if (string.trim().equals("*")) {
                address = new Address("*", "*");
            } else {
                logger.debug((Object)("inside search. findContactsByName performed theSearchText ==" + string + "the end"));
                this.foundContacts = ControlsUtils.itemListToList(EngineCommandManager.getAddressBookManager().findContactsByName(string));
                address = (Contact)this.foundContacts.get(0);
            }
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException);
        }
        if (address == null) {
            try {
                logger.debug((Object)("inside search. findContactByEmail performed theSearchText == " + string + "the end"));
                address = EngineCommandManager.getAddressBookManager().findContactByEmail(string);
            }
            catch (EngineException engineException) {
                logger.error((Object)engineException);
            }
        }
        if (address == null) {
            address = new Address(string, string);
        }
        return address;
    }

    private boolean isContactLastName(String string) {
        if (this.foundContacts == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.foundContacts.size(); ++i) {
            if (!(this.foundContacts.get(i) instanceof Contact)) continue;
            Contact contact = (Contact)this.foundContacts.get(i);
            boolean bl2 = bl = contact.getDisplayName().indexOf(44) != -1 && contact.getLastName().toLowerCase().equals(string.toLowerCase());
            if (!bl) continue;
            this.contactIndex = i;
            break;
        }
        return bl;
    }

    protected String parseString(String string) {
        List list = StringParser.getAllTokens(string, DELIMETERS);
        String string2 = string;
        for (int i = 0; i < list.size(); ++i) {
            String string3 = list.get(i).toString().trim();
            if (this.listener != null && i > 0) {
                if (this.foundContacts != null && this.foundContacts.size() > 0) {
                    this.addToList((Addressable)this.foundContacts.get(this.contactIndex));
                } else {
                    string2 = string2.trim();
                    this.addToList((Addressable)new Address(string2, string2));
                }
            }
            this.clearSearchResult();
            string2 = list.get(i).toString();
            if (string3.equals("")) continue;
            this.search(string3);
            if (i >= list.size() - 1 || !this.isContactLastName(string3)) continue;
            String string4 = list.get(i + 1).toString();
            ++i;
            string2 = string3 + ',' + string4;
            if (this.isContact(string2)) continue;
            this.clearSearchResult();
        }
        return string2;
    }

    private boolean isContact(String string) {
        if (this.foundContacts != null) {
            for (int i = 0; i < this.foundContacts.size(); ++i) {
                Contact contact = (Contact)this.foundContacts.get(i);
                if (!contact.getDisplayName().toLowerCase().startsWith(string.toLowerCase())) continue;
                this.foundContact = contact;
                this.contactIndex = i;
                return true;
            }
        }
        return false;
    }

    protected void clearSearchResult() {
        this.foundContacts = null;
        this.contactIndex = 0;
    }

    public void setTextToParse(String string) {
        super.setText(string);
    }

    public Contact getContact() {
        if (this.foundContacts != null) {
            return (Contact)this.foundContacts.get(0);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Arrays.sort(DELIMETERS);
        STR_DELIMETERS = new String[]{";", ",", System.getProperty("line.separator")};
    }

    private class TimerAction
    implements ActionListener {
        private String searchText = "";

        private TimerAction() {
        }

        public void setSearchText(String string) {
            this.searchText = string;
            if (this.searchText.length() == 0) {
                SearchTextField.this.clearSearchResult();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.searchText.length() > 0 && SearchTextField.this.isEditable()) {
                String string = SearchTextField.this.parseString(this.searchText);
                if (!string.equals(this.searchText)) {
                    SearchTextField.this.setText(string);
                }
                if (SearchTextField.this.foundContacts != null) {
                    String string2 = string;
                    Contact contact = (Contact)SearchTextField.this.foundContacts.get(SearchTextField.this.contactIndex);
                    String string3 = contact.getDisplayName();
                    if (string3.toLowerCase().startsWith(string.toLowerCase())) {
                        string2 = string3;
                    }
                    SearchTextField.this.setText(string2);
                    SearchTextField.this.setCaretPosition(string.length());
                    SearchTextField.this.select(string.length(), string3.length());
                }
            }
        }
    }

    private class PEKeyListener
    extends KeyAdapter {
        private PEKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n;
            int n2 = keyEvent.getKeyCode();
            if (n2 == 38 && SearchTextField.this.foundContacts != null) {
                SearchTextField.this.foundContact = SearchTextField.this.getPrevContact();
                n = SearchTextField.this.getSelectionStart();
                SearchTextField.this.setText(SearchTextField.this.foundContact.getDisplayName());
                SearchTextField.this.select(n, SearchTextField.this.foundContact.getDisplayName().length());
            }
            if (n2 == 40 && SearchTextField.this.foundContacts != null) {
                SearchTextField.this.foundContact = SearchTextField.this.getNextContact();
                n = SearchTextField.this.getSelectionStart();
                SearchTextField.this.setText(SearchTextField.this.foundContact.getDisplayName());
                SearchTextField.this.select(n, SearchTextField.this.foundContact.getDisplayName().length());
            }
        }
    }

    class SearchDocument
    extends PlainDocument {
        private boolean parseString = true;

        SearchDocument() {
        }

        public void remove(int n, int n2) throws BadLocationException {
            int n3 = SearchTextField.this.getSelectionStart();
            int n4 = SearchTextField.this.getSelectionEnd() - n3;
            super.remove(n, n2);
            if (this.parseString && (n3 != n || n4 != n2 || n2 <= 0)) {
                SearchTextField.this.timer.restart();
                SearchTextField.this.timerAction.setSearchText(SearchTextField.this.getText());
            }
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            SearchTextField searchTextField = SearchTextField.this;
            String string2 = searchTextField.getText().substring(0, n);
            String string3 = string2 + string;
            boolean bl = n >= searchTextField.getText().length();
            super.insertString(n, string, attributeSet);
            SearchTextField.this.timerAction.setSearchText(searchTextField.getText());
            if (!bl) {
                SearchTextField.this.clearSearchResult();
            }
            if (this.parseString && bl) {
                if (SearchTextField.this.isLastContactBeginWith(SearchTextField.this.getText())) {
                    SearchTextField.this.timer.stop();
                    super.remove(n, string.length());
                    Contact contact = (Contact)SearchTextField.this.foundContacts.get(SearchTextField.this.contactIndex);
                    String string4 = contact.getDisplayName().substring(string3.length() - 1);
                    super.insertString(n, string4, attributeSet);
                    SearchTextField.this.select(n + string.length(), contact.getDisplayName().length());
                } else if (Arrays.asList(STR_DELIMETERS).contains(string)) {
                    SearchTextField.this.timer.restart();
                    SearchTextField.this.timerAction.setSearchText(searchTextField.getText());
                    super.remove(n, 1);
                    SearchTextField.this.timer.stop();
                    if (SearchTextField.this.foundContacts == null) {
                        SearchTextField.this.timerAction.actionPerformed(null);
                    } else {
                        SearchTextField.this.addToRecipiensList();
                    }
                } else {
                    SearchTextField.this.timer.restart();
                    SearchTextField.this.timerAction.setSearchText(SearchTextField.this.getText());
                }
            }
            if (n == 0 && string.equals("")) {
                SearchTextField.this.foundContacts = null;
                SearchTextField.this.timer.stop();
            }
        }

        public void setParseString(boolean bl) {
            this.parseString = bl;
        }
    }
}

