/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.components.AbstractOKAction;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.Address;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.GroupContact;
import com.novell.gw.ab.OrganizationContact;
import com.novell.gw.ab.ResourceContact;
import com.novell.gw.ab.UserContact;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GroupContactDetailsDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.OrganizationContactDetailsDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ResourceContactDetailsDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.UserContactDetailsDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.dialogs.SaveableDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.FrequentContactsAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class ContactDetailsDialog
extends SaveableDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$dialogs$UserContactDetailsDialog == null ? (class$com$novell$gw$jclient$application$controls$addressbook$dialogs$UserContactDetailsDialog = ContactDetailsDialog.class$("com.novell.gw.jclient.application.controls.addressbook.dialogs.UserContactDetailsDialog")) : class$com$novell$gw$jclient$application$controls$addressbook$dialogs$UserContactDetailsDialog));
    private JTabbedPane tabContent = new OrientableTabbedPane();
    protected Contact contact;
    protected boolean readOnly;
    private ContactDetailsPane[] panes;
    protected AbstractAddressBook addressBook;
    protected String optionDialogName;
    protected int defaultWidth;
    protected int defaultHeight;
    private boolean centered;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$dialogs$UserContactDetailsDialog;

    protected ContactDetailsDialog(JFrame jFrame, Contact contact) {
        super(jFrame, true);
        this.init(contact);
    }

    protected ContactDetailsDialog(JDialog jDialog, Contact contact) {
        super(jDialog, true);
        this.init(contact);
    }

    protected ContactDetailsDialog(JFrame jFrame, AbstractAddressBook abstractAddressBook, int n) {
        super(jFrame, true);
        this.init(abstractAddressBook, n);
    }

    protected ContactDetailsDialog(JDialog jDialog, AbstractAddressBook abstractAddressBook, int n) {
        super(jDialog, true);
        this.init(abstractAddressBook, n);
    }

    private void init(AbstractAddressBook abstractAddressBook, int n) {
        this.contact = GWEngineUtils.createContact((PersonalAddressBook)abstractAddressBook, n);
        this.addressBook = abstractAddressBook;
    }

    private void init(Contact contact) {
        this.setTitle(contact.getDisplayName() + " (" + contact.getBookName() + ')');
        this.addressBook = EngineCommandManager.getContactAddressBook(contact);
        this.contact = contact;
    }

    public void show() {
        if (this.centered) {
            UIUtils.centerWindow((Window)this, (Window)this.getParent());
        }
        super.show();
    }

    void init(ContactDetailsPane[] contactDetailsPaneArray) {
        this.setDefaultCloseOperation(2);
        this.panes = contactDetailsPaneArray;
        this.readOnly = this.addressBook.isReadOnly();
        this.buildUI();
        this.readContactProperties();
        if (this.readOnly) {
            ContactDetailsPane.disableAllComponents(this.tabContent);
        }
        if (this.optionDialogName == null) {
            throw new NullPointerException();
        }
    }

    protected void readContactProperties() {
        for (int i = 0; i < this.panes.length; ++i) {
            this.panes[i].readContactProperties();
        }
    }

    protected void writeContactProperties() {
        for (int i = 0; i < this.panes.length; ++i) {
            this.panes[i].writeContactProperties();
        }
    }

    void buildUI() {
        OrientablePanel orientablePanel;
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        for (int i = 0; i < this.panes.length; ++i) {
            orientablePanel = this.panes[i];
            this.tabContent.addTab(orientablePanel.getName(), null, orientablePanel);
        }
        jPanel.add((Component)this.tabContent, "Center");
        FlowLayout flowLayout = new FlowLayout(4);
        orientablePanel = new OrientablePanel(flowLayout);
        if (OS.isMacOS()) {
            EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 16);
            orientablePanel.setBorder(emptyBorder);
        }
        this.btnOK = new JButton(new OkAction());
        this.setDefaultButton(this.btnOK);
        this.setCancelButton(this.btnCancel);
        if (this.readOnly) {
            this.btnCancel.setText(StringResources.CLOSE);
            orientablePanel.add(this.btnCancel);
        } else {
            OS.addButtons(orientablePanel, this.btnOK, this.btnCancel);
        }
        jPanel.add((Component)orientablePanel, "South");
    }

    protected boolean save() {
        boolean bl;
        block8: {
            Contact contact = this.contact;
            bl = false;
            this.writeContactProperties();
            String string = contact.getDisplayName();
            if (string != null && string.length() > 0) {
                try {
                    this.contact.save(0);
                    bl = true;
                }
                catch (EngineException engineException) {
                    if (engineException.getErrorCode() == 59142) {
                        String string2;
                        String string3 = string2 = contact instanceof GroupContact ? StringResources.A_GROUP_WITH_THE_SAME_NAME : StringResources.AN_ENTRY_WITH_THE_SAME_NAME;
                        if (0 == JOptionPane.showConfirmDialog(this, string2, StringResources.ADDRESS_BOOK_K_QUESTION, 0)) {
                            try {
                                int n = contact instanceof GroupContact ? 2 : 1;
                                this.contact.save(n);
                                bl = true;
                            }
                            catch (EngineException engineException2) {
                                logger.error((Object)engineException);
                                logger.debug((Object)engineException, (Throwable)engineException);
                            }
                        }
                        break block8;
                    }
                    logger.error((Object)engineException);
                    logger.debug((Object)engineException, (Throwable)engineException);
                }
            } else {
                JOptionPane.showMessageDialog(this, StringResources.YOU_MUST_ENTER_A_DISPLAY_NAME, StringResources.ERROR, 1);
            }
        }
        return bl;
    }

    public Contact getContact() {
        return this.contact;
    }

    public static ContactDetailsDialog createContactDetailsDialog(Window window, Addressable addressable) {
        ContactDetailsDialog contactDetailsDialog;
        if (addressable instanceof UserContact) {
            contactDetailsDialog = window instanceof JDialog ? new UserContactDetailsDialog((JDialog)window, (UserContact)addressable) : new UserContactDetailsDialog((JFrame)window, (UserContact)addressable);
        } else if (addressable instanceof ResourceContact) {
            contactDetailsDialog = window instanceof JDialog ? new ResourceContactDetailsDialog((JDialog)window, (ResourceContact)addressable) : new ResourceContactDetailsDialog((JFrame)window, (ResourceContact)addressable);
        } else if (addressable instanceof OrganizationContact) {
            contactDetailsDialog = window instanceof JDialog ? new OrganizationContactDetailsDialog((JDialog)window, (OrganizationContact)addressable) : new OrganizationContactDetailsDialog((JFrame)window, (OrganizationContact)addressable);
        } else if (addressable instanceof GroupContact) {
            contactDetailsDialog = window instanceof JDialog ? new GroupContactDetailsDialog((JDialog)window, (GroupContact)addressable) : new GroupContactDetailsDialog((JFrame)window, (GroupContact)addressable);
        } else if (addressable instanceof Address) {
            FrequentContactsAddressBook frequentContactsAddressBook = EngineCommandManager.getFrequentContactsAddressBook();
            contactDetailsDialog = window instanceof JDialog ? new UserContactDetailsDialog((JDialog)window, (AbstractAddressBook)frequentContactsAddressBook, (Address)addressable) : new UserContactDetailsDialog((JFrame)window, (AbstractAddressBook)frequentContactsAddressBook, (Address)addressable);
        } else {
            throw new IllegalArgumentException("Unknown Contact type");
        }
        return contactDetailsDialog;
    }

    public static ContactDetailsDialog createContactDetailsDialog(Window window, AbstractAddressBook abstractAddressBook, int n) {
        ContactDetailsDialog contactDetailsDialog;
        switch (n) {
            case 0: {
                if (window instanceof JDialog) {
                    contactDetailsDialog = new UserContactDetailsDialog((JDialog)window, abstractAddressBook);
                    break;
                }
                contactDetailsDialog = new UserContactDetailsDialog((JFrame)window, abstractAddressBook);
                break;
            }
            case 2: {
                if (window instanceof JDialog) {
                    contactDetailsDialog = new ResourceContactDetailsDialog((JDialog)window, abstractAddressBook);
                    break;
                }
                contactDetailsDialog = new ResourceContactDetailsDialog((JFrame)window, abstractAddressBook);
                break;
            }
            case 3: {
                if (window instanceof JDialog) {
                    contactDetailsDialog = new OrganizationContactDetailsDialog((JDialog)window, abstractAddressBook);
                    break;
                }
                contactDetailsDialog = new OrganizationContactDetailsDialog((JFrame)window, abstractAddressBook);
                break;
            }
            case 1: {
                if (window instanceof JDialog) {
                    contactDetailsDialog = new GroupContactDetailsDialog((JDialog)window, abstractAddressBook);
                    break;
                }
                contactDetailsDialog = new GroupContactDetailsDialog((JFrame)window, abstractAddressBook);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Contact type");
            }
        }
        return contactDetailsDialog;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class OkAction
    extends AbstractOKAction {
        private OkAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ContactDetailsDialog.this.save()) {
                ContactDetailsDialog.this.setActionCompleteSuccessfully(true);
                ContactDetailsDialog.this.dispose();
            }
        }
    }
}

