/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.components.ComponentBorder;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.UserContact;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.UserContactDetailsPane;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

class ContactPane
extends UserContactDetailsPane {
    public static final String ENTER_NAME = "<<" + StringResources.ENTER_NAME + ">>";
    private static final int FIRST_LAST = 0;
    private static final int LAST_FIRST = 1;
    private static final int CUSTOM_NAME = 2;
    private JPanel pnlEmail = new OrientablePanel(new GridBagLayout());
    private JPanel pnlInstMessanger = new OrientablePanel(new GridBagLayout());
    private JPanel pnlPhone = new OrientablePanel(new BorderLayout());
    private AbstractButton rbOfficePhone = new JMnemonicRadioButton(StringResources.OFFICE);
    private AbstractButton rbHomePhone = new JMnemonicRadioButton(StringResources.HOME);
    private AbstractButton rbMobilPhone = new JMnemonicRadioButton(StringResources.MOBILE);
    private AbstractButton rbFax = new JMnemonicRadioButton(StringResources.FAX);
    private AbstractButton rbPager = new JMnemonicRadioButton(StringResources.PAGER);
    private JTextField tfFirstName = new OrientableTextField();
    private JTextField tfMidleName = new OrientableTextField();
    private JTextField tfLastName = new OrientableTextField();
    private DefaultComboBoxModel displayNameModel = new CPModel();
    JTextField tfIMAdress = new OrientableTextField();
    JTextField tfEmail = new OrientableTextField();
    JComboBox cmbDIsplayName = new OrientableComboBox();
    private JTextField tfOfficePhone = new OrientableTextField();
    private JTextField tfHomePhone = new OrientableTextField();
    private JTextField tfMobilPhone = new OrientableTextField();
    private JTextField tfPager = new OrientableTextField();
    private JTextField tfFax = new OrientableTextField();
    private JComboBox cmbNamePrefix = new OrientableComboBox(new String[]{StringResources.PREFIX_DR, StringResources.PREFIX_MISS, StringResources.PREFIX_MR, StringResources.PREFIX_MRS, StringResources.PREFIX_MS, StringResources.PREFIX_PROF});
    private JComboBox cmbNameSufix = new OrientableComboBox(new String[]{StringResources.SUFFIX_I, StringResources.SUFFIX_II, StringResources.SUFFIX_III, StringResources.SUFFIX_JUNIOR, StringResources.SUFFIX_SENIOR});
    private EmailsTableModel emailsTableModel = new EmailsTableModel();
    private JTable tableEmails = new ExtendedGWTable(this.emailsTableModel);
    private ImAddressesModel imAddressesModel = new ImAddressesModel();
    private JTable tableIMAddresses = new ExtendedGWTable(this.imAddressesModel);
    private AbstractButton btnRemoveEmail;
    private AbstractButton btnRemoveIMAddress;
    private AbstractButton btnEditEmail;
    private AbstractButton btnEditIMAddress;
    private AbstractAction actionAddEmail;
    private AbstractAction actionAddIM;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ContactPane(UserContact userContact) {
        super(userContact);
        this.setName(StringResources.CONTACT);
        this.buildContactTab();
        this.displayNameModel.addElement(ENTER_NAME);
        this.cmbDIsplayName.setModel(this.displayNameModel);
        if (PLAFChanger.isMetalLAF()) {
            JTextComponent jTextComponent = (JTextComponent)this.cmbDIsplayName.getEditor().getEditorComponent();
            jTextComponent.setBorder(new CPBorder(jTextComponent.getBorder()));
            if ("steel".equals(System.getProperty("swing.metalTheme"))) {
                Dimension dimension = this.cmbDIsplayName.getPreferredSize();
                jTextComponent.setBorder(this.tfFirstName.getBorder());
            }
        }
        this.tfFirstName.getDocument().addDocumentListener(new DNDocumentListener());
        this.tfLastName.getDocument().addDocumentListener(new DNDocumentListener());
    }

    private int getNameFormat() {
        int n = this.displayNameModel.getSize();
        int n2 = this.cmbDIsplayName.getSelectedIndex();
        if (n == 1) {
            return 0;
        }
        if (n2 == -1 || n2 == 0) {
            return 0;
        }
        if (n2 == 1) {
            return 1;
        }
        return 2;
    }

    private void updateDisplayName() {
        int n = this.getNameFormat();
        String string = this.getDisplayName(n);
        if (!string.equals("") && this.displayNameModel.getSize() == 1) {
            this.displayNameModel.insertElementAt("", 0);
            this.displayNameModel.insertElementAt("", 1);
            this.cmbDIsplayName.setSelectedIndex(0);
        }
        if (n != 2) {
            this.cmbDIsplayName.setSelectedItem(string);
        }
    }

    private String getDisplayName(int n) {
        String string = "";
        String string2 = this.tfFirstName.getText();
        String string3 = this.tfLastName.getText();
        if (n == 0) {
            string = string2;
            if (!string3.equals("") && !string2.equals("")) {
                string = string + ' ';
            }
            string = string + string3;
        } else if (n == 1) {
            string = string3;
            if (!string3.equals("") && !string2.equals("")) {
                string = string + ", ";
            }
            string = string + string2;
        }
        return string;
    }

    private void buildContactTab() {
        this.setLayout(new BorderLayout());
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        TitleValueContainer titleValueContainer = new TitleValueContainer(orientablePanel);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.FIRST_C, this.tfFirstName), this.tfFirstName, new JMnemonicLabel(StringResources.PREFIX_C, this.cmbNamePrefix), this.cmbNamePrefix, 0);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.MIDDLE_C, this.tfMidleName), this.tfMidleName, new JMnemonicLabel(StringResources.SUFFIX_C, this.cmbNameSufix), this.cmbNameSufix, 1);
        this.cmbNamePrefix.setSelectedItem(null);
        this.cmbNameSufix.setSelectedItem(null);
        this.cmbDIsplayName.setEditable(true);
        this.cmbDIsplayName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
                jTextField.selectAll();
            }
        });
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.LAST_C, this.tfLastName), this.tfLastName, new JMnemonicLabel(StringResources.DISPLAY_C, this.cmbDIsplayName), this.cmbDIsplayName, 2);
        orientablePanel.setBorder(BorderFactory.createTitledBorder(StringResources.NAME));
        this.add((Component)orientablePanel, "North");
        ComponentOrientation componentOrientation = UIUtils.getComponentOrientation();
        this.tableIMAddresses.setComponentOrientation(componentOrientation);
        this.tableIMAddresses.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ContactPane.class$("java.lang.Object")) : class$java$lang$Object, new OrientableTableCellRenderer());
        this.tableEmails.setComponentOrientation(componentOrientation);
        this.setComponentOrientation(componentOrientation);
        this.buildEmailPanel();
        this.buildPhonePanel();
        this.buildInstMessangerPanel();
        OrientablePanel orientablePanel2 = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.weightx = 50.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        orientablePanel2.add((Component)this.pnlEmail, gridBagConstraints);
        gridBagConstraints.weightx = 50.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        orientablePanel2.add((Component)this.pnlPhone, gridBagConstraints);
        gridBagConstraints.weightx = 60.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        orientablePanel2.add((Component)this.pnlInstMessanger, gridBagConstraints);
        this.add((Component)orientablePanel2, "Center");
    }

    private void buildEmailPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 5, 5);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlEmail.add((Component)this.tfEmail, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.actionAddEmail = new AddElementToTableAction(this.tfEmail, this.emailsTableModel, this.tableEmails, StringResources.ADD);
        gridBagConstraints.anchor = 22;
        this.pnlEmail.add((Component)new JMnemonicButton(this.actionAddEmail), gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.tableEmails.setTableHeader(null);
        TableColumn tableColumn = this.tableEmails.getColumnModel().getColumn(0);
        tableColumn.setResizable(false);
        tableColumn.setMaxWidth(16);
        tableColumn.setMinWidth(16);
        this.tableEmails.setShowGrid(false);
        this.tableEmails.getSelectionModel().setSelectionMode(0);
        this.tableEmails.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (ContactPane.this.tableEmails.getRowCount() > 0) {
                    boolean bl = defaultListSelectionModel.isSelectionEmpty();
                    ContactPane.this.btnEditEmail.setEnabled(!bl);
                    ContactPane.this.btnRemoveEmail.setEnabled(!bl);
                }
            }
        });
        this.tableEmails.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor(new OrientableTextField()));
        ColoredScrollPane coloredScrollPane = new ColoredScrollPane(this.tableEmails);
        coloredScrollPane.setPreferredSize(new Dimension(280, 100));
        this.pnlEmail.add((Component)coloredScrollPane, gridBagConstraints);
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(0, 1, 0, 5));
        this.btnRemoveEmail = new JMnemonicButton(new RemoveElementFromTableAction(this.tableEmails, this.emailsTableModel));
        this.btnEditEmail = new JButton(new EditTableElementAction(this.tableEmails));
        orientablePanel.add(this.btnRemoveEmail);
        orientablePanel.add(this.btnEditEmail);
        gridBagConstraints.anchor = 24;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.pnlEmail.add((Component)orientablePanel, gridBagConstraints);
        JMnemonicLabel jMnemonicLabel = new JMnemonicLabel(StringResources.EMAIL_ADDRESS_C, this.tfEmail);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.pnlEmail.add((Component)jMnemonicLabel, gridBagConstraints);
        ComponentBorder componentBorder = new ComponentBorder(jMnemonicLabel);
        this.pnlEmail.setBorder(BorderFactory.createCompoundBorder(componentBorder, BorderFactory.createEmptyBorder(10, 0, 0, 0)));
        this.tableEmails.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OS.isDoubleClick(mouseEvent)) {
                    ContactPane.this.btnEditEmail.getAction().actionPerformed(null);
                }
            }
        });
    }

    private void buildInstMessangerPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 5, 5);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        OrientableComboBox orientableComboBox = new OrientableComboBox();
        this.pnlInstMessanger.add((Component)orientableComboBox, gridBagConstraints);
        this.pnlInstMessanger.add((Component)this.tfIMAdress, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        this.actionAddIM = new AddElementToTableAction(this.tfIMAdress, this.imAddressesModel, this.tableIMAddresses, StringResources.ADD);
        OrientableButton orientableButton = new OrientableButton(this.actionAddIM);
        UIUtils.setMnemonic(orientableButton, 1);
        this.pnlInstMessanger.add((Component)orientableButton, gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.tableIMAddresses.setTableHeader(null);
        this.tableIMAddresses.setShowGrid(false);
        this.tableIMAddresses.getSelectionModel().setSelectionMode(0);
        ColoredScrollPane coloredScrollPane = new ColoredScrollPane(this.tableIMAddresses);
        coloredScrollPane.setPreferredSize(new Dimension(280, 100));
        this.pnlInstMessanger.add((Component)coloredScrollPane, gridBagConstraints);
        this.tableIMAddresses.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (ContactPane.this.tableIMAddresses.getRowCount() > 0) {
                    boolean bl = defaultListSelectionModel.isSelectionEmpty();
                    ContactPane.this.btnEditIMAddress.setEnabled(!bl);
                    ContactPane.this.btnRemoveIMAddress.setEnabled(!bl);
                } else {
                    ContactPane.this.btnEditIMAddress.setEnabled(false);
                    ContactPane.this.btnRemoveIMAddress.setEnabled(false);
                }
            }
        });
        this.tableIMAddresses.getColumnModel().getColumn(0).setCellEditor(new MyTableCellEditor(new OrientableTextField()));
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(0, 1, 0, 5));
        this.btnRemoveIMAddress = new JMnemonicButton(new RemoveElementFromTableAction(this.tableIMAddresses, this.imAddressesModel));
        this.btnEditIMAddress = new JButton(new EditTableElementAction(this.tableIMAddresses));
        orientablePanel.add(this.btnRemoveIMAddress);
        orientablePanel.add(this.btnEditIMAddress);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        this.pnlInstMessanger.add((Component)orientablePanel, gridBagConstraints);
        JMnemonicLabel jMnemonicLabel = new JMnemonicLabel(StringResources.INSTANT_MESSAGING, orientableComboBox);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.pnlInstMessanger.add((Component)jMnemonicLabel, gridBagConstraints);
        ComponentBorder componentBorder = new ComponentBorder(jMnemonicLabel);
        this.pnlInstMessanger.setBorder(BorderFactory.createCompoundBorder(componentBorder, BorderFactory.createEmptyBorder(10, 0, 0, 0)));
        this.tableIMAddresses.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OS.isDoubleClick(mouseEvent)) {
                    ContactPane.this.btnEditIMAddress.getAction().actionPerformed(null);
                }
            }
        });
    }

    private void buildPhonePanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbFax);
        buttonGroup.add(this.rbHomePhone);
        buttonGroup.add(this.rbMobilPhone);
        buttonGroup.add(this.rbOfficePhone);
        buttonGroup.add(this.rbPager);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        TitleValueContainer titleValueContainer = new TitleValueContainer(orientablePanel);
        titleValueContainer.buildRow(this.rbOfficePhone, this.tfOfficePhone, 0);
        this.tfOfficePhone.setColumns(6);
        titleValueContainer.buildRow(this.rbHomePhone, this.tfHomePhone, 1);
        titleValueContainer.buildRow(this.rbMobilPhone, this.tfMobilPhone, 2);
        titleValueContainer.buildRow(this.rbFax, this.tfFax, 3);
        titleValueContainer.buildRow(this.rbPager, this.tfPager, 4);
        this.pnlPhone.add((Component)orientablePanel, "North");
        this.pnlPhone.setBorder(BorderFactory.createTitledBorder(StringResources.PHONE));
    }

    public void readContactProperties() {
        this.tfFirstName.setText(this.contact.getFirstName());
        this.tfLastName.setText(this.contact.getLastName());
        this.tfMidleName.setText(this.contact.getMiddleName());
        this.cmbDIsplayName.setSelectedItem(this.contact.getDisplayName());
        this.cmbNamePrefix.setSelectedItem(this.contact.getNamePrefix());
        this.cmbNameSufix.setSelectedItem(this.contact.getNameSuffix());
        this.tfOfficePhone.setText(this.contact.getOfficePhone());
        this.tfHomePhone.setText(this.contact.getHomePhone());
        this.tfMobilPhone.setText(this.contact.getMobilePhone());
        this.tfPager.setText(this.contact.getPager());
        this.tfFax.setText(this.contact.getFax());
        this.emailsTableModel.setEmails(this.contact.getEmailAddresses());
        this.emailsTableModel.setDefaultEmail(this.contact.getEmailAddress());
        this.imAddressesModel.setIMAddresses(this.contact.getImAddresses());
        this.selectDefaultPhone();
    }

    private void selectDefaultPhone() {
        String string = this.contact.getDefaultPhone();
        if (string.equals(this.contact.getOfficePhone())) {
            this.rbOfficePhone.setSelected(true);
        } else if (string.equals(this.contact.getHomePhone())) {
            this.rbHomePhone.setSelected(true);
        } else if (string.equals(this.contact.getMobilePhone())) {
            this.rbMobilPhone.setSelected(true);
        } else if (string.equals(this.contact.getPager())) {
            this.rbPager.setSelected(true);
        } else if (string.equals(this.contact.getFax())) {
            this.rbFax.setSelected(true);
        }
    }

    private String getDefaultPhone() {
        if (this.rbOfficePhone.isSelected()) {
            return this.tfOfficePhone.getText();
        }
        if (this.rbHomePhone.isSelected()) {
            return this.tfHomePhone.getText();
        }
        if (this.rbMobilPhone.isSelected()) {
            return this.tfMobilPhone.getText();
        }
        if (this.rbPager.isSelected()) {
            return this.tfPager.getText();
        }
        return this.tfFax.getText();
    }

    public void writeContactProperties() {
        String string;
        this.actionAddEmail.actionPerformed(null);
        this.actionAddIM.actionPerformed(null);
        this.contact.setFirstName(this.tfFirstName.getText());
        this.contact.setMiddleName(this.tfMidleName.getText());
        this.contact.setLastName(this.tfLastName.getText());
        Object object = this.cmbNamePrefix.getSelectedItem();
        if (object != null) {
            string = object.toString();
            this.contact.setNamePrefix(string);
        }
        if ((object = this.cmbNameSufix.getSelectedItem()) != null) {
            string = object.toString();
            this.contact.setNameSuffix(string);
        }
        if ((string = this.cmbDIsplayName.getSelectedItem().toString()).equals(ENTER_NAME) || string.trim().equals("")) {
            string = this.displayNameModel.getSize() > 1 ? this.displayNameModel.getElementAt(0).toString() : "";
        }
        this.contact.setDisplayName(string);
        this.contact.setOfficePhone(this.tfOfficePhone.getText());
        this.contact.setHomePhone(this.tfHomePhone.getText());
        this.contact.setMobilePhone(this.tfMobilPhone.getText());
        this.contact.setPager(this.tfPager.getText());
        this.contact.setFax(this.tfFax.getText());
        this.contact.setDefaultPhone(this.getDefaultPhone());
        this.contact.setEmailAddresses(this.emailsTableModel.getValues());
        this.contact.setEmailAddress(this.emailsTableModel.getDefaultEmail());
        this.contact.setImAddresses(this.imAddressesModel.getValues());
        this.imAddressesModel.setIMAddresses(this.contact.getImAddresses());
        this.selectDefaultPhone();
    }

    public JComponent getDefaultComponent() {
        return this.tfFirstName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CPBorder
    implements Border {
        private Border border;
        private Insets insets = new Insets(0, 0, 0, 0);

        public CPBorder(Border border) {
            this.border = border;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.border.paintBorder(component, graphics, n, n2, n3, n4);
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = this.border.getBorderInsets(component);
            this.insets.top = insets.top;
            this.insets.left = insets.left;
            this.insets.bottom = insets.bottom;
            this.insets.right = insets.right + 1;
            return this.insets;
        }

        public boolean isBorderOpaque() {
            return this.border.isBorderOpaque();
        }
    }

    private class CPModel
    extends DefaultComboBoxModel {
        private CPModel() {
        }

        public Object getElementAt(int n) {
            if (this.getSize() == 1) {
                return super.getElementAt(n);
            }
            switch (n) {
                case 0: {
                    return ContactPane.this.getDisplayName(0);
                }
                case 1: {
                    return ContactPane.this.getDisplayName(1);
                }
            }
            return super.getElementAt(n);
        }
    }

    private static class RemoveElementFromTableAction
    extends AbstractAction {
        private JTable table;
        private MutableTableModel tableModel;

        public RemoveElementFromTableAction(JTable jTable, MutableTableModel mutableTableModel) {
            super(StringResources.REMOVE);
            this.table = jTable;
            this.tableModel = mutableTableModel;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.tableModel.removeElementAt(this.table.getSelectedRow());
            this.table.clearSelection();
        }
    }

    private class MyTableCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        JTextField tf;
        private boolean isCellEditable;

        public boolean isCellEditable(EventObject eventObject) {
            return this.isCellEditable;
        }

        public void setCellEditable(boolean bl) {
            this.isCellEditable = bl;
        }

        public MyTableCellEditor(JTextField jTextField) {
            super(jTextField);
            this.tf = jTextField;
            this.tf.setComponentOrientation(UIUtils.getComponentOrientation());
            jTextField.addFocusListener(this);
            this.addCellEditorListener(new CellEditorListener(this){
                private final /* synthetic */ MyTableCellEditor this$1;
                {
                    this.this$1 = myTableCellEditor;
                }

                public void editingStopped(ChangeEvent changeEvent) {
                    MyTableCellEditor.access$902(this.this$1, false);
                }

                public void editingCanceled(ChangeEvent changeEvent) {
                    MyTableCellEditor.access$902(this.this$1, false);
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.tf.setText(object.toString());
            this.tf.setCaretPosition(0);
            this.tf.selectAll();
            return this.tf;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.tf.selectAll();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.stopCellEditing();
        }

        static /* synthetic */ boolean access$902(MyTableCellEditor myTableCellEditor, boolean bl) {
            myTableCellEditor.isCellEditable = bl;
            return myTableCellEditor.isCellEditable;
        }
    }

    private static class EditTableElementAction
    extends AbstractAction {
        private JTable table;

        public EditTableElementAction(JTable jTable) {
            super(StringResources.EDIT);
            this.table = jTable;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyTableCellEditor myTableCellEditor = (MyTableCellEditor)this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1).getCellEditor();
            myTableCellEditor.setCellEditable(true);
            this.table.editCellAt(this.table.getSelectedRow(), this.table.getColumnCount() - 1);
            this.table.repaint();
            myTableCellEditor.tf.requestFocus();
        }
    }

    private static class AddElementToTableAction
    extends AbstractAction {
        private JTextField tfElement;
        private MutableTableModel tableModel;
        private JTable table;

        public AddElementToTableAction(JTextField jTextField, MutableTableModel mutableTableModel, JTable jTable, String string) {
            super(string);
            this.tfElement = jTextField;
            this.tableModel = mutableTableModel;
            this.table = jTable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.tfElement.getText().trim();
            if (!string.equals("")) {
                this.tableModel.addElement(string);
                this.tfElement.setText("");
                int n = this.table.getRowCount() - 1;
                this.table.scrollRectToVisible(new Rectangle(0, this.table.getRowHeight() * n, 1, this.table.getRowHeight()));
            }
        }
    }

    private static interface MutableTableModel {
        public void addElement(String var1);

        public void removeElementAt(int var1);

        public String[] getValues();
    }

    private static class ImAddressesModel
    extends AbstractTableModel
    implements MutableTableModel {
        private List imAddresses = new ArrayList();

        public ImAddressesModel() {
        }

        public ImAddressesModel(String[] stringArray) {
            this.imAddresses.addAll(Arrays.asList(stringArray));
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public int getRowCount() {
            return this.imAddresses.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            this.imAddresses.set(n, object);
        }

        public Object getValueAt(int n, int n2) {
            return this.imAddresses.get(n);
        }

        public void addElement(String string) {
            this.imAddresses.add(string);
            this.fireTableDataChanged();
        }

        public void removeElementAt(int n) {
            this.imAddresses.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public String[] getValues() {
            String[] stringArray = new String[this.imAddresses.size()];
            for (int i = 0; i < this.imAddresses.size(); ++i) {
                stringArray[i] = (String)this.imAddresses.get(i);
            }
            return stringArray;
        }

        public void setIMAddresses(String[] stringArray) {
            this.imAddresses.addAll(Arrays.asList(stringArray));
            this.fireTableDataChanged();
        }
    }

    private class EmailsTableModel
    extends AbstractTableModel
    implements MutableTableModel {
        private List emails = new ArrayList();
        private String defaultEmail;

        public EmailsTableModel() {
        }

        public EmailsTableModel(String[] stringArray, String string) {
            this.emails.addAll(Arrays.asList(stringArray));
            this.defaultEmail = string;
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public int getRowCount() {
            return this.emails.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                String string = (String)this.emails.get(n);
                if (!string.equals(this.defaultEmail)) {
                    this.defaultEmail = string;
                    this.fireTableDataChanged();
                }
            } else {
                if (this.getValueAt(n, 0).equals(Boolean.TRUE)) {
                    this.defaultEmail = (String)object;
                }
                this.emails.set(n, object);
            }
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ContactPane.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return super.getColumnClass(n);
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                if (this.emails.get(n).equals(this.defaultEmail)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return this.emails.get(n);
        }

        public void setEmails(String[] stringArray) {
            this.emails.addAll(Arrays.asList(stringArray));
            this.fireTableDataChanged();
        }

        public String getItemAt(int n) {
            return (String)this.emails.get(n);
        }

        public String[] getValues() {
            String[] stringArray = new String[this.emails.size()];
            for (int i = 0; i < this.emails.size(); ++i) {
                stringArray[i] = (String)this.emails.get(i);
            }
            return stringArray;
        }

        public String getDefaultEmail() {
            return this.defaultEmail;
        }

        public void setDefaultEmail(String string) {
            this.defaultEmail = string;
            this.fireTableDataChanged();
        }

        public void addElement(String string) {
            this.emails.add(string);
            int n = this.emails.size();
            if (n == 1) {
                this.defaultEmail = string;
            }
            this.fireTableRowsInserted(n - 1, n - 1);
        }

        public void removeElementAt(int n) {
            String string = (String)this.emails.get(n);
            this.emails.remove(n);
            if (this.defaultEmail.equals(string)) {
                this.defaultEmail = this.emails.size() > 0 ? (String)this.emails.get(0) : "";
            }
            this.fireTableRowsDeleted(n, n);
        }
    }

    private class DNDocumentListener
    implements DocumentListener {
        private DNDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ContactPane.this.updateDisplayName();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ContactPane.this.updateDisplayName();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

