/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.utils.UIUtils;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.GroupContact;
import com.novell.gw.ab.OrganizationContact;
import com.novell.gw.ab.Recipient;
import com.novell.gw.ab.ResourceContact;
import com.novell.gw.ab.UserContact;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class MembersListRenderer
implements ListCellRenderer {
    private JLabel lbTo = new JLabel(StringResources.TO_C);
    private JLabel lbCc = new JLabel(StringResources.CC_C);
    private JLabel lbBc = new JLabel(StringResources.BC_C);
    private int titleWidth;
    private JLabel lbLeft;
    private JPanel pnlItem;
    private JLabel lbRight;

    public MembersListRenderer() {
        this.titleWidth = Math.max(Math.max(this.lbTo.getPreferredSize().width, this.lbCc.getPreferredSize().width), this.lbBc.getPreferredSize().width) + 5;
        this.lbLeft = new OrientableLabel();
        this.pnlItem = new JPanel(new GridBagLayout());
        this.lbRight = new OrientableLabel();
        this.pnlItem.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        ComponentOrientation componentOrientation = UIUtils.getComponentOrientation();
        this.pnlItem.setComponentOrientation(componentOrientation);
        this.lbLeft.setComponentOrientation(componentOrientation);
        this.lbRight.setComponentOrientation(componentOrientation);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Recipient recipient = (Recipient)object;
        this.setTitle(recipient);
        this.lbLeft.setPreferredSize(new Dimension(this.titleWidth, this.lbLeft.getPreferredSize().height));
        this.setText(object);
        this.setIcon(object);
        this.pnlItem.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        this.pnlItem.add((Component)this.lbLeft, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlItem.add((Component)this.lbRight, gridBagConstraints);
        if (bl) {
            this.pnlItem.setBackground(jList.getSelectionBackground());
            this.pnlItem.setForeground(jList.getSelectionForeground());
        } else {
            this.pnlItem.setBackground(jList.getBackground());
            this.pnlItem.setForeground(jList.getForeground());
        }
        return this.pnlItem;
    }

    private void setTitle(Recipient recipient) {
        if ((recipient.getCopyType() & 1) == 1) {
            this.lbLeft.setText(StringResources.TO_C);
        } else if ((recipient.getCopyType() & 2) == 2) {
            this.lbLeft.setText(StringResources.CC_C);
        } else if ((recipient.getCopyType() & 4) == 4) {
            this.lbLeft.setText(StringResources.BC_C);
        }
    }

    private void setText(Object object) {
        Addressable addressable = ((Recipient)object).getAddressable();
        this.lbRight.setText(addressable.getDisplayName());
    }

    private void setIcon(Object object) {
        Addressable addressable = ((Recipient)object).getAddressable();
        if (addressable instanceof GroupContact) {
            this.lbRight.setIcon(ImageResources.ICON_ADDRESS_BOOK_GROUP);
        } else if (addressable instanceof OrganizationContact) {
            this.lbRight.setIcon(ImageResources.ICON_ADDRESS_BOOK_ORGANIZATION);
        } else if (addressable instanceof ResourceContact) {
            this.lbRight.setIcon(ImageResources.ICON_ADDRESS_BOOK_RESOURSE);
        } else if (addressable instanceof UserContact) {
            this.lbRight.setIcon(ImageResources.ICON_ADDRESS_BOOK_USER);
        } else {
            this.lbRight.setIcon(ImageResources.ICON_ADDRESS_BOOK_USER);
        }
    }
}

