/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.components.GWTextArea;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.OrganizationContact;
import com.novell.gw.ab.UserContact;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.SearchContactTextField;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.UserContactDetailsPane;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

class OfficePane
extends UserContactDetailsPane {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$dialogs$OfficePane == null ? (class$com$novell$gw$jclient$application$controls$addressbook$dialogs$OfficePane = OfficePane.class$("com.novell.gw.jclient.application.controls.addressbook.dialogs.OfficePane")) : class$com$novell$gw$jclient$application$controls$addressbook$dialogs$OfficePane));
    private OrganizationContact organization;
    private String organizationName = "";
    private JTextField tfState = new OrientableTextField();
    private JTextField tfCountry = new OrientableTextField();
    private JTextField tfTitle = new OrientableTextField();
    private JTextField tfDepartment = new OrientableTextField();
    private SearchContactTextField tfOrganization;
    private JTextField tfMailStop = new OrientableTextField();
    private JTextField tfCity = new OrientableTextField();
    private JTextField tfZip = new OrientableTextField();
    private JTextField tfWebSite = new OrientableTextField("http://");
    private JTextArea taAddress = new GWTextArea(4, 1);
    private JButton btnWebSite = new JButton(new ContactDetailsPane.LaunchWebSiteAction(this.tfWebSite, this));
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$dialogs$OfficePane;

    public OfficePane(UserContact userContact, AbstractAddressBook abstractAddressBook) {
        super(userContact);
        this.tfOrganization = new SearchContactTextField(abstractAddressBook, 8);
        this.setName(StringResources.OFFICE);
        this.setLayout(new GridBagLayout());
        this.buildUI();
        this.setBorder(BorderFactory.createTitledBorder(StringResources.OFFICE));
        ComponentOrientation componentOrientation = UIUtils.getComponentOrientation();
        this.setComponentOrientation(componentOrientation);
        this.taAddress.setComponentOrientation(componentOrientation);
    }

    private void buildUI() {
        int n = this.btnWebSite.getIcon().getIconWidth() + 8;
        this.btnWebSite.setPreferredSize(new Dimension(n, this.tfCountry.getPreferredSize().height));
        TitleValueContainer titleValueContainer = new TitleValueContainer(this);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.TITLE_C, this.tfTitle), this.tfTitle, 0);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.DEPARTMENT_C, this.tfDepartment), this.tfDepartment, 1);
        titleValueContainer.buildRow(new OrientableLabel(StringResources.ORGANIZATION_C), this.tfOrganization, 2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 3, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)new JMnemonicLabel(StringResources.ADDRESS_C, this.taAddress), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)new OrientableScrollPane(this.taAddress), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.MAIL_STOP_C, this.tfMailStop), this.tfMailStop, 4);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.CITY_C, this.tfCity), this.tfCity, 5);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.STATE_PROVINCE_C, this.tfState), this.tfState, new JMnemonicLabel(StringResources.ZIP_POSTAL_CODE_C, this.tfZip), this.tfZip, 6);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.COUNTRY_C, this.tfCountry), this.tfCountry, new OrientableLabel(), new OrientableLabel(), 7);
        titleValueContainer.buildRow((JComponent)new JMnemonicLabel(StringResources.WEB_SITE_C, this.tfWebSite), (JComponent)this.tfWebSite, this.btnWebSite, 8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridx = 1;
        this.add((Component)new OrientableLabel(), gridBagConstraints);
        this.tfCountry.setSize(this.tfState.getSize());
    }

    public void readContactProperties() {
        this.tfState.setText(this.contact.getOfficeState());
        this.tfCountry.setText(this.contact.getOfficeCountry());
        this.tfTitle.setText(this.contact.getTitle());
        this.tfDepartment.setText(this.contact.getDepartment());
        this.organization = this.contact.getOrganization();
        this.organizationName = this.contact.getCompany();
        this.tfOrganization.setTextToParse(this.organizationName);
        this.tfMailStop.setText(this.contact.getOfficeLocation());
        this.tfCity.setText(this.contact.getOfficeCity());
        this.tfZip.setText(this.contact.getOfficePostalCode());
        this.tfWebSite.setText(this.contact.getOfficeWebsite());
        this.taAddress.setText(this.contact.getOfficeStreetAddress());
    }

    public void writeContactProperties() {
        this.contact.setOfficeState(this.tfState.getText());
        this.contact.setOfficeCountry(this.tfCountry.getText());
        this.contact.setTitle(this.tfTitle.getText());
        this.contact.setDepartment(this.tfDepartment.getText());
        Contact contact = this.tfOrganization.getFoundContact();
        if (contact instanceof OrganizationContact) {
            this.organization = (OrganizationContact)contact;
            try {
                this.organization.save(0);
            }
            catch (EngineException engineException) {
                logger.error((Object)engineException, (Throwable)engineException);
            }
        } else {
            this.organization = null;
        }
        this.contact.setOrganization(this.organization);
        this.contact.setOfficeLocation(this.tfMailStop.getText());
        this.contact.setOfficeCity(this.tfCity.getText());
        this.contact.setOfficePostalCode(this.tfZip.getText());
        this.contact.setOfficeWebsite(this.tfWebSite.getText());
        this.contact.setOfficeStreetAddress(this.taAddress.getText());
    }

    public JComponent getDefaultComponent() {
        return this.tfTitle;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

