/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.components.GWTextArea;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.OrganizationContact;
import com.novell.gw.ab.UserContact;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.SearchContactTextField;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

class OrganizationDetailsPane
extends ContactDetailsPane {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$dialogs$OrganizationDetailsPane == null ? (class$com$novell$gw$jclient$application$controls$addressbook$dialogs$OrganizationDetailsPane = OrganizationDetailsPane.class$("com.novell.gw.jclient.application.controls.addressbook.dialogs.OrganizationDetailsPane")) : class$com$novell$gw$jclient$application$controls$addressbook$dialogs$OrganizationDetailsPane));
    private OrganizationContact contact;
    private UserContact primaryContact;
    private JTextField tfOrganization = new OrientableTextField();
    private JTextField tfPhone = new OrientableTextField();
    private SearchContactTextField tfPrimaryContact;
    private JTextField tfFax = new OrientableTextField();
    private JTextField tfCity = new OrientableTextField();
    private JTextField tfState = new OrientableTextField();
    private JTextField tfZip = new OrientableTextField();
    private JTextField tfCountry = new OrientableTextField();
    private JTextField tfWebSite = new OrientableTextField();
    private JTextArea taAddress = new GWTextArea(3, 1);
    private JTextArea taComments = new GWTextArea(4, 1);
    private JButton btnWebSite = new JButton(new ContactDetailsPane.LaunchWebSiteAction(this.tfWebSite, this));
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$dialogs$OrganizationDetailsPane;

    public OrganizationDetailsPane(OrganizationContact organizationContact, AbstractAddressBook abstractAddressBook) {
        this.tfPrimaryContact = new SearchContactTextField(abstractAddressBook);
        this.contact = organizationContact;
        this.setName(StringResources.DETAILS);
        this.setLayout(new GridBagLayout());
        this.buildUI();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void buildUI() {
        int n = this.btnWebSite.getIcon().getIconWidth() + 8;
        this.btnWebSite.setPreferredSize(new Dimension(n, this.tfWebSite.getPreferredSize().height));
        TitleValueContainer titleValueContainer = new TitleValueContainer(this);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.ORGANIZATION_C, this.tfOrganization), this.tfOrganization, new JMnemonicLabel(StringResources.PHONE_C, this.tfPhone), this.tfPhone, 0);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.PRIMARY_CONTACT_C, this.tfPrimaryContact), this.tfPrimaryContact, new JMnemonicLabel(StringResources.FAX_C, this.tfFax), this.tfFax, 1);
        titleValueContainer.buildRow((JComponent)new JMnemonicLabel(StringResources.ADDRESS_C, this.taAddress), (JComponent)new OrientableScrollPane(this.taAddress), 2, true);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.CITY_C, this.tfCity), this.tfCity, 3);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.STATE_PROVINCE_C, this.tfState), this.tfState, new JMnemonicLabel(StringResources.ZIP_POSTAL_CODE_C, this.tfZip), this.tfZip, 4);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.COUNTRY_C, this.tfCountry), this.tfCountry, new OrientableLabel(), new OrientableLabel(), 5);
        titleValueContainer.buildRow((JComponent)new JMnemonicLabel(StringResources.WEB_SITE_C, this.tfWebSite), (JComponent)this.tfWebSite, this.btnWebSite, 6);
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.taComments);
        titleValueContainer.buildRow((JComponent)new JMnemonicLabel(StringResources.COMMENTS_C, this.taComments), (JComponent)orientableScrollPane, 7, true);
        orientableScrollPane.setPreferredSize(new Dimension(200, 110));
        this.tfFax.setColumns(6);
        this.tfCity.setColumns(6);
        this.tfState.setColumns(6);
        this.tfZip.setColumns(6);
        this.tfCountry.setColumns(6);
        this.tfWebSite.setColumns(6);
    }

    public void readContactProperties() {
        this.primaryContact = this.contact.getPrimaryContact();
        this.tfOrganization.setText(this.contact.getDisplayName());
        this.tfPhone.setText(this.contact.getPhone());
        this.tfPrimaryContact.setText(this.primaryContact != null ? this.primaryContact.getDisplayName() : "");
        this.tfFax.setText(this.contact.getFax());
        this.tfCity.setText(this.contact.getCity());
        this.tfState.setText(this.contact.getState());
        this.tfZip.setText(this.contact.getPostalCode());
        this.tfCountry.setText(this.contact.getCountry());
        this.tfWebSite.setText(this.contact.getWebsite());
        this.taAddress.setText(this.contact.getStreetAddress());
        this.taComments.setText(this.contact.getComments());
    }

    public void writeContactProperties() {
        Contact contact = this.tfPrimaryContact.getFoundContact();
        if (contact instanceof UserContact) {
            this.primaryContact = (UserContact)contact;
            try {
                this.primaryContact.save(0);
            }
            catch (EngineException engineException) {
                logger.error((Object)engineException, (Throwable)engineException);
            }
        } else {
            this.primaryContact = null;
        }
        this.contact.setDisplayName(this.tfOrganization.getText());
        this.contact.setPhone(this.tfPhone.getText());
        this.contact.setPrimaryContact(this.primaryContact);
        this.contact.setFax(this.tfFax.getText());
        this.contact.setCity(this.tfCity.getText());
        this.contact.setState(this.tfState.getText());
        this.contact.setPostalCode(this.tfZip.getText());
        this.contact.setCountry(this.tfCountry.getText());
        this.contact.setWebsite(this.tfWebSite.getText());
        this.contact.setStreetAddress(this.taAddress.getText());
        this.contact.setComments(this.taComments.getText());
    }

    private void findPrimaryContact() {
    }

    public JComponent getDefaultComponent() {
        return this.tfOrganization;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

