/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.components.GWTextArea;
import com.novell.gw.ab.UserContact;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.UserContactDetailsPane;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class PersonalPane
extends UserContactDetailsPane {
    private JTextField tfState = new OrientableTextField();
    private JTextField tfZip = new OrientableTextField();
    private JTextField tfCountry = new OrientableTextField();
    private JTextField tfCity = new OrientableTextField();
    private JTextArea taAddress = new GWTextArea(4, 1);
    private JTextField tfWebSite = new OrientableTextField("http://");
    private JButton btnWebSite = new JButton(new ContactDetailsPane.LaunchWebSiteAction(this.tfWebSite, this));

    public PersonalPane(UserContact userContact) {
        super(userContact);
        this.setName(StringResources.PERSONAL);
        this.setLayout(new GridBagLayout());
        this.buildUI();
        this.setBorder(BorderFactory.createTitledBorder(StringResources.PERSONAL));
    }

    private void buildUI() {
        int n = this.btnWebSite.getIcon().getIconWidth() + 8;
        this.btnWebSite.setPreferredSize(new Dimension(n, this.tfWebSite.getPreferredSize().height));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 3, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridy = 0;
        this.add((Component)new JMnemonicLabel(StringResources.ADDRESS_C, this.taAddress), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)new OrientableScrollPane(this.taAddress), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        TitleValueContainer titleValueContainer = new TitleValueContainer(this);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.CITY_C, this.tfCity), this.tfCity, 5);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.STATE_PROVINCE_C, this.tfState), this.tfState, new JMnemonicLabel(StringResources.ZIP_POSTAL_CODE_C, this.tfZip), this.tfZip, 6);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.COUNTRY_C, this.tfCountry), this.tfCountry, new JLabel(), new JLabel(), 7);
        titleValueContainer.buildRow((JComponent)new JMnemonicLabel(StringResources.WEB_SITE_C, this.tfWebSite), (JComponent)this.tfWebSite, this.btnWebSite, 8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridx = 1;
        this.add((Component)new JLabel(), gridBagConstraints);
    }

    public void readContactProperties() {
        this.tfCity.setText(this.contact.getHomeCity());
        this.tfCountry.setText(this.contact.getHomeCountry());
        this.tfState.setText(this.contact.getHomeState());
        this.tfWebSite.setText(this.contact.getHomeWebsite());
        this.tfZip.setText(this.contact.getHomePostalCode());
        this.taAddress.setText(this.contact.getHomeStreetAddress());
    }

    public void writeContactProperties() {
        this.contact.setHomeCity(this.tfCity.getText());
        this.contact.setHomeCountry(this.tfCountry.getText());
        this.contact.setHomeState(this.tfState.getText());
        this.contact.setHomeWebsite(this.tfWebSite.getText());
        this.contact.setHomePostalCode(this.tfZip.getText());
        this.contact.setHomeStreetAddress(this.taAddress.getText());
    }

    public JComponent getDefaultComponent() {
        return this.taAddress;
    }
}

