/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.list;

import com.appframework.ActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.controls.addressbook.list.RLPopupMenu;
import com.novell.gw.jclient.application.controls.addressbook.list.RecipientsListController;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class RecipientsList
extends OrientableList
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$list$RecipientsList == null ? (class$com$novell$gw$jclient$application$controls$addressbook$list$RecipientsList = RecipientsList.class$("com.novell.gw.jclient.application.controls.addressbook.list.RecipientsList")) : class$com$novell$gw$jclient$application$controls$addressbook$list$RecipientsList));
    private RecipientsListController controller;
    protected DefaultListModel model;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$list$RecipientsList;

    public RecipientsList(MVCController mVCController) {
        this.controller = new RecipientsListController(this, mVCController);
        this.model = new DefaultListModel();
        this.setModel(this.model);
        this.addMouseListener(new MouseListener());
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RecipientsList.this.updateActionsModel();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (keyEvent.getKeyCode() == n) {
                    RecipientsList.this.getController().getActionList().performAction("Remove from Recipients List");
                }
                super.keyPressed(keyEvent);
            }
        });
        this.setDropTarget(new DropTarget(this, 3, new RLDTListener()));
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, new DGListener());
    }

    private void updateActionsModel() {
        Object[] objectArray = this.getSelectedValues();
        ActionList actionList = this.getController().getActionList();
        if (objectArray.length > 0) {
            actionList.getAction("Remove from Recipients List").setEnabled(true);
            actionList.getAction("Remove from Recipients List").setMVCModel(Arrays.asList(objectArray));
            ArrayList<Addressable> arrayList = new ArrayList<Addressable>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(((Recipient)objectArray[i]).getAddressable());
            }
            Command command = new Command(240, arrayList);
            this.getController().processCommand(command);
        } else {
            actionList.getAction("Remove from Recipients List").setEnabled(false);
        }
    }

    public List getRecipientList() {
        return Arrays.asList(this.model.toArray());
    }

    public void removeRecipients(List list) {
        int n = this.getMaxSelectionIndex();
        for (int i = 0; i < list.size(); ++i) {
            this.model.removeElement(list.get(i));
        }
        if (this.getModel().getSize() == 0) {
            this.getController().processCommand(new Command(250, null));
        } else if (n != -1) {
            this.selectNearestIndex(n);
        }
    }

    public void setController(MVCController mVCController) {
        if (!(mVCController instanceof RecipientsListController)) {
            throw new IllegalArgumentException();
        }
        this.controller = (RecipientsListController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    private int getRecipientsCountByCopyType(int n) {
        int n2 = 0;
        int n3 = this.model.size();
        for (int i = 0; i < n3; ++i) {
            Recipient recipient = (Recipient)this.model.get(i);
            if ((recipient.getCopyType() & n) != n) continue;
            ++n2;
        }
        return n2;
    }

    private void addRecipient(Recipient recipient) {
        int n = this.getRecipientsCountByCopyType(1);
        int n2 = recipient.getCopyType();
        if ((n2 & 2) == 2) {
            n += this.getRecipientsCountByCopyType(2);
        } else if ((n2 & 4) == 4) {
            n = this.model.getSize();
        }
        this.model.add(n, recipient);
        this.clearSelection();
    }

    private void removeRecipient(Recipient recipient) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            Recipient recipient2 = (Recipient)this.model.getElementAt(i);
            if (recipient.getAddressable() instanceof Contact) {
                if (!recipient.getAddressable().equals(recipient2.getAddressable())) continue;
                this.model.removeElement(recipient2);
                break;
            }
            if (!recipient.isSameAddress(recipient2.getAddressable())) continue;
            this.model.removeElement(recipient2);
            break;
        }
    }

    private void selectNearestIndex(int n) {
        int n2 = this.getModel().getSize();
        if (n2 == 0) {
            return;
        }
        int n3 = n >= n2 ? n2 - 1 : n;
        this.setSelectedIndex(n3);
    }

    public void setMVCModel(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                Recipient recipient = (Recipient)list.get(i);
                this.removeRecipient(recipient);
                this.addRecipient(recipient);
            }
            if (this.model.getSize() > 0) {
                this.getController().processCommand(new Command(260, new ArrayList<Object>(Arrays.asList(this.model.toArray()))));
            }
        }
    }

    public Object getMVCModel() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TransferableData
    implements Transferable {
        private DataFlavor[] dataFlavors = new DataFlavor[]{GWFlavors.contactsFlavor, GWFlavors.rlFlavor};

        private TransferableData() {
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.dataFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return Arrays.asList(this.dataFlavors).contains(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return RecipientsList.this.getSelectedValue();
        }
    }

    private class DSListener
    extends DragSourceAdapter {
        private DSListener() {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    private class DGListener
    implements DragGestureListener {
        private DGListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (dragGestureEvent.getTriggerEvent() instanceof MouseEvent && ((MouseEvent)dragGestureEvent.getTriggerEvent()).getButton() == 2) {
                return;
            }
            dragGestureEvent.startDrag(DragSource.DefaultMoveNoDrop, ImageResources.ICON_ADDRESS_BOOK_USER.getImage(), new Point(0, 0), new TransferableData(), new DSListener());
        }
    }

    private class RLDTListener
    extends DropTargetAdapter {
        private RLDTListener() {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                if (dropTargetDropEvent.getTransferable().getTransferData(GWFlavors.contactsFlavor) instanceof Contact) {
                    RecipientsList.this.controller.getActionList().performAction("Move To Recipients List");
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                logger.error((Object)unsupportedFlavorException);
                logger.debug((Object)unsupportedFlavorException, (Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                logger.error((Object)iOException);
                logger.debug((Object)iOException, (Throwable)iOException);
            }
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private RLPopupMenu popupMenu;

        private MouseListener() {
            this.popupMenu = new RLPopupMenu(RecipientsList.this.getController().getActionList());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (OS.isDoubleClick(mouseEvent) && (n = RecipientsList.this.locationToIndex(mouseEvent.getPoint())) != -1 && RecipientsList.this.getCellBounds(n, n).contains(mouseEvent.getPoint())) {
                RecipientsList.this.getController().getActionList().performAction("Remove from Recipients List");
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.isPopupTrigger() && (n = RecipientsList.this.locationToIndex(mouseEvent.getPoint())) != -1) {
                if (RecipientsList.this.getSelectedIndices().length <= 1) {
                    RecipientsList.this.setSelectedIndex(n);
                }
                this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

