/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.table;

import com.appframework.ActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.controls.addressbook.table.AbstractAddressBookTable;
import com.novell.gw.jclient.application.controls.menus.AddressSelectorEntryPopupMenu;
import com.novell.gw.jclient.application.options.OptionManager;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class AddressSelectorEntriesTable
extends AbstractAddressBookTable {
    private static Set movedEntries = new HashSet();
    private Rendererr rendererr = new Rendererr();

    public AddressSelectorEntriesTable(MVCController mVCController, JTextField jTextField) {
        super(mVCController, jTextField);
        movedEntries.clear();
        this.init();
    }

    void init() {
        this.addMouseListener(new ASMouseListener());
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (keyEvent.getKeyCode() == n) {
                    AddressSelectorEntriesTable.this.controller.getActionList().performAction("Remove Directory Entry");
                }
            }
        });
        this.tfSearch.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38) {
                    AddressSelectorEntriesTable.this.requestFocus();
                }
            }
        });
    }

    public void setMVCModel(Object object) {
        super.setMVCModel(object);
        if (object instanceof Recipient) {
            this.clearSelection();
            Command command = new Command(270);
            this.getController().processCommand(command);
            movedEntries.add(String.valueOf(((Contact)object).getId()));
        } else if (object instanceof List) {
            this.clearSelection();
            Command command = new Command(270);
            this.getController().processCommand(command);
            List list = (List)object;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Addressable addressable;
                if (!(list.get(i) instanceof Recipient) || !((addressable = ((Recipient)list.get(i)).getAddressable()) instanceof Contact)) continue;
                String string = String.valueOf(((Contact)addressable).getId());
                movedEntries.add(string);
            }
        }
    }

    protected void performDefaultAction() {
        this.getController().getActionList().performAction("Move To Recipients List");
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.rendererr;
    }

    public static Set getMovedEntries() {
        return movedEntries;
    }

    private class Rendererr
    extends AbstractAddressBookTable.EntriesTableRendererr {
        private Rendererr() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Contact contact = (Contact)AddressSelectorEntriesTable.this.model.getItemList().getItemAt(n);
            Rendererr rendererr = this;
            if (movedEntries.contains(String.valueOf(contact.getId())) && !(object instanceof ImageIcon)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class ASMouseListener
    extends MouseAdapter {
        ASMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.isPopupTrigger() && (n = AddressSelectorEntriesTable.this.rowAtPoint(mouseEvent.getPoint())) != -1) {
                if (AddressSelectorEntriesTable.this.getSelectedRowCount() <= 1) {
                    AddressSelectorEntriesTable.this.setRowSelectionInterval(n, n);
                }
                ActionList actionList = AddressSelectorEntriesTable.this.getController().getActionList();
                Contact contact = (Contact)AddressSelectorEntriesTable.this.model.getItemList().getItemAt(n);
                AddressSelectorEntryPopupMenu addressSelectorEntryPopupMenu = new AddressSelectorEntryPopupMenu(actionList, contact);
                ((JPopupMenu)addressSelectorEntryPopupMenu).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

