/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.AppActionModel;
import com.appframework.cache.IdentifiedObject;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.Borders;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.attachmentlist.AttachmentQuickViewController;
import com.novell.gw.jclient.application.controls.attachmentlist.AttachmentsDragGestureListener;
import com.novell.gw.jclient.application.controls.attachmentlist.ListView;
import com.novell.gw.jclient.application.controls.attachmentlist.TableView;
import com.novell.gw.jclient.application.controls.attachmentlist.ViewContent;
import com.novell.gw.jclient.application.controls.menus.AttachmentPopupMenu;
import com.novell.gw.jclient.application.controls.menus.AttachmentsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.ItemDescription;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public abstract class AttachmentView
extends JPanel
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$attachmentlist$AttachmentView == null ? (class$com$novell$gw$jclient$application$controls$attachmentlist$AttachmentView = AttachmentView.class$("com.novell.gw.jclient.application.controls.attachmentlist.AttachmentView")) : class$com$novell$gw$jclient$application$controls$attachmentlist$AttachmentView));
    public static final String ACTION_OPEN_ATTACHMENT_GWITEM = "open gwitem attachment";
    public static final String ACTION_OPEN_ATTACHMENT_FILE = "open attachment file";
    public static final String ACTION_PRINT_ATTACHMENT_GWITEM = "print gwitem attachment";
    public static final int SMALL_ICONS_VIEW = 0;
    public static final int LARGE_ICONS_VIEW = 1;
    public static final int LIST_VIEW = 2;
    public static final int DETAILS_VIEW = 3;
    private int viewMode = 1;
    private ButtonGroup iconsSizeButtonGroup;
    protected AttachmentQuickViewController controller;
    protected ViewContent listContent;
    protected boolean viewMessage;
    protected Boolean hideSystemAttachments;
    protected AbstractItem item;
    private AVListSelectionListener listSelectionListener;
    private AVMouseListener listMouseListener;
    protected AppAction actionPrintMessage;
    private DragGestureListener dragGestureListener = new AttachmentsDragGestureListener(this);
    protected JScrollPane sp;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$attachmentlist$AttachmentView;

    protected AttachmentView(boolean bl, MVCController mVCController) {
        this.viewMessage = bl;
        this.controller = new AttachmentQuickViewController(this, mVCController);
        this.buildUI();
    }

    private void buildUI() {
        this.actionPrintMessage = new ActionProcessGWItemAttachment(this.controller.getActionList(), StringResources.PRINT_D, "Print");
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.iconsSizeButtonGroup = new ButtonGroup();
        this.listSelectionListener = new AVListSelectionListener();
        this.listMouseListener = new AVMouseListener();
        this.createContent(new ListView(this.viewMessage, new Object[0]));
        this.setViewMode(OptionManager.getInstance().getEnvironmentOptions().getAttachmentIconSizeID());
    }

    protected JPopupMenu getMultipleObjectsPopupMenu(Object[] objectArray) {
        return new AttachmentsPopupMenu(this.controller.getActionList(), objectArray.length > 1);
    }

    private JPopupMenu getSingleObjectPopupMenu(Object object) {
        if (object instanceof GWAttachment) {
            Command command = new Command(30, object);
            this.controller.processCommand(command);
            return this.getAttachmentPopupMenu();
        }
        if (object instanceof AbstractItem) {
            return this.getItemPopupMenu((AbstractItem)object);
        }
        return null;
    }

    protected JPopupMenu getItemPopupMenu(AbstractItem abstractItem) {
        SensitivePopupMenu sensitivePopupMenu = new SensitivePopupMenu();
        this.actionPrintMessage.setMVCModel(abstractItem);
        sensitivePopupMenu.add(new OpenGWItemAction(abstractItem));
        sensitivePopupMenu.add(this.actionPrintMessage.getMenuItem());
        return sensitivePopupMenu;
    }

    protected JPopupMenu getAttachmentPopupMenu() {
        return new AttachmentPopupMenu(this.controller.getActionList(), this.listContent);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = null;
        Object[] objectArray = this.getSelectedObjects();
        if (objectArray.length > 1) {
            jPopupMenu = this.getMultipleObjectsPopupMenu(objectArray);
        } else if (objectArray.length == 1) {
            jPopupMenu = this.getSingleObjectPopupMenu(objectArray[0]);
        }
        jPopupMenu = this.appendDefaultActions(jPopupMenu);
        return jPopupMenu;
    }

    protected Object[] getSelectedObjects() {
        return this.listContent.getSelectedValues();
    }

    protected JPopupMenu appendDefaultActions(JPopupMenu jPopupMenu) {
        if (jPopupMenu != null) {
            jPopupMenu.addSeparator();
        } else {
            jPopupMenu = new JPopupMenu();
        }
        GWMenu gWMenu = new GWMenu(StringResources.VIEW);
        gWMenu.add(this.getMenuItem(1, StringResources.LARGE_ICONS));
        gWMenu.add(this.getMenuItem(0, StringResources.SMALL_ICONS));
        gWMenu.add(this.getMenuItem(2, StringResources.LIST));
        gWMenu.add(this.getMenuItem(3, StringResources.DETAILS));
        jPopupMenu.add(gWMenu);
        return jPopupMenu;
    }

    private JMenuItem getMenuItem(int n, String string) {
        OrientableRadioButtonMenuItem orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(new ActionChangeItemIconSize(n, string));
        this.iconsSizeButtonGroup.add(orientableRadioButtonMenuItem);
        if (this.viewMode == n) {
            orientableRadioButtonMenuItem.setSelected(true);
        }
        return orientableRadioButtonMenuItem;
    }

    private void processItemSelection(Object[] objectArray) {
        if (objectArray.length > 1) {
            this.controller.processCommand(new Command(880, this.getSelectedIndices()));
        } else if (objectArray.length == 1) {
            this.controller.processCommand(new Command(50, objectArray[0]));
        }
    }

    public int[] getSelectedIndices() {
        return this.listContent.getSelectedIndices();
    }

    public void setViewMode(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Unsuported view mode");
        }
        EnvironmentOptions environmentOptions = OptionManager.getInstance().getEnvironmentOptions();
        environmentOptions.setAttachmentIconSizeID(n);
        OptionManager.getInstance().setEnvironmentOptions(environmentOptions);
        this.viewMode = n;
        boolean bl = this.listContent.isFocused();
        switch (this.viewMode) {
            case 0: 
            case 1: 
            case 2: {
                if (this.listContent instanceof TableView) {
                    Object[] objectArray = this.listContent.getElements();
                    Object[] objectArray2 = this.getSelectedObjects();
                    this.createContent(new ListView(this.viewMessage, objectArray));
                    this.listContent.selectItems(objectArray2);
                }
                this.listContent.setViewMode(n);
                break;
            }
            case 3: {
                if (!(this.listContent instanceof ListView)) break;
                Object[] objectArray = this.listContent.getElements();
                Object[] objectArray3 = this.getSelectedObjects();
                this.createContent(new TableView(this.viewMessage, objectArray));
                this.listContent.selectItems(objectArray3);
            }
        }
        this.listContent.setFocused(bl);
    }

    protected void createContent(ViewContent viewContent) {
        if (this.listContent != null) {
            this.unRegisterListeners();
        }
        this.listContent = viewContent;
        this.registerListeners();
        if (this.sp != null) {
            this.sp.removeMouseListener(this.listMouseListener);
            this.remove(this.sp);
        }
        this.sp = new ColoredScrollPane((JComponent)((Object)this.listContent));
        this.sp.setBorder(Borders.getEmptyTextComponentBorder(false));
        this.sp.addMouseListener(this.listMouseListener);
        this.add((Component)this.sp, "Center");
        this.listContent.updateScrollPane();
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((JComponent)((Object)this.listContent), 3, this.dragGestureListener);
        this.revalidate();
        this.repaint();
    }

    protected void registerListeners() {
        this.listContent.addMouseListener(this.listMouseListener);
        this.listContent.addListSelectionListener(this.listSelectionListener);
    }

    protected void unRegisterListeners() {
        this.listContent.removeMouseListener(this.listMouseListener);
        this.listContent.removeListSelectionListener(this.listSelectionListener);
    }

    public void setController(MVCController mVCController) {
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        this.listContent.removeAllElements();
        if (object instanceof ItemDescription) {
            this.item = ((ItemDescription)object).getItem();
            this.parseGWItem();
        } else if (object instanceof AbstractItem) {
            this.item = (AbstractItem)object;
            this.parseGWItem();
        } else if (object == null) {
            this.item = null;
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected abstract void parseGWItem();

    public AbstractItem getItem() {
        return this.item;
    }

    public Object getMVCModel() {
        return null;
    }

    public void selectAttachment(IdentifiedObject identifiedObject) {
        this.listContent.selectItems(new Object[]{identifiedObject});
    }

    private void processDClick(Point point) {
        Object object = this.listContent.getItemAtPoint(point);
        if (object instanceof GWAttachment) {
            this.controller.getActionList().performAction("Open Attachment");
        } else if (object instanceof AbstractItem) {
            this.processGWItemDClick((AbstractItem)object);
        }
    }

    protected void processGWItemDClick(AbstractItem abstractItem) {
        if (abstractItem == this.item) {
            MessageUtils.openItem(abstractItem, new ItemDescription(abstractItem), this.controller);
        } else {
            this.openEmbeddedItem(abstractItem);
        }
    }

    void openEmbeddedItem(AbstractItem abstractItem) {
        this.getController().processCommand(new Command(920, abstractItem));
        this.setMVCModel(abstractItem);
    }

    public void setHideSystemAttachments(Boolean bl) {
        this.hideSystemAttachments = bl;
        this.listContent.removeAllElements();
        this.parseGWItem();
    }

    public Component getListContent() {
        return (Component)((Object)this.listContent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class OpenGWItemAction
    extends AbstractAction {
        private AbstractItem gwItem;

        public OpenGWItemAction(AbstractItem abstractItem) {
            super(StringResources.OPEN);
            this.gwItem = abstractItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MessageUtils.openItem(this.gwItem, new ItemDescription(this.gwItem), AttachmentView.this.controller);
        }
    }

    protected class SensitivePopupMenu
    extends JPopupMenu {
        protected SensitivePopupMenu() {
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (bl) {
                AttachmentView.this.listContent.setSelectionEnabled(false);
            } else {
                AttachmentView.this.listContent.setPopupItem(null);
                AttachmentView.this.listContent.setSelectionEnabled(true);
                AttachmentView.this.repaint();
            }
        }
    }

    private class ActionProcessGWItemAttachment
    extends AppAction {
        private String actionID;

        public ActionProcessGWItemAttachment(ActionList actionList, String string, String string2) {
            super(actionList, new AppActionModel("", string));
            this.putValue("SmallIcon", null);
            this.actionID = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AppAction appAction;
            if (this.getMVCModel() != null && (appAction = this.getActionList().getAction(this.actionID)) != null) {
                appAction.setMVCModel(new ItemDescription((AbstractItem)this.getMVCModel()));
                this.getActionList().performAction(this.actionID);
            }
        }
    }

    class AVListSelectionListener
    implements ListSelectionListener {
        private boolean enabled = true;

        AVListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.enabled && !listSelectionEvent.getValueIsAdjusting()) {
                AttachmentView.this.processItemSelection(AttachmentView.this.getSelectedObjects());
            }
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }

    private class AVMouseListener
    extends MouseAdapter {
        private AVMouseListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.clearPopupSelection();
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                AttachmentView attachmentView = AttachmentView.this;
                Object[] objectArray = attachmentView.getSelectedObjects();
                Point point = mouseEvent.getPoint();
                Object object = attachmentView.listContent.getItemAtPoint(point);
                AttachmentView.this.listContent.setPopupItem(object, true);
                if (!this.isPointSelected(objectArray, object)) {
                    JPopupMenu jPopupMenu = attachmentView.getSingleObjectPopupMenu(object);
                    jPopupMenu = attachmentView.appendDefaultActions(jPopupMenu);
                    jPopupMenu.show((JComponent)((Object)attachmentView.listContent), point.x + 10, point.y + 10);
                } else {
                    JPopupMenu jPopupMenu = attachmentView.createPopupMenu();
                    jPopupMenu.show((JComponent)((Object)attachmentView.listContent), point.x + 10, point.y + 10);
                }
                attachmentView.listContent.setPopupItem(object, false);
                attachmentView.repaint();
            }
        }

        private boolean isPointSelected(Object[] objectArray, Object object) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (object2 != object) continue;
                return true;
            }
            return false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (OS.isDoubleClick(mouseEvent)) {
                AttachmentView.this.processDClick(mouseEvent.getPoint());
            }
        }

        private void clearPopupSelection() {
            AttachmentView attachmentView = AttachmentView.this;
            if (attachmentView.listContent.getPopupItem() != null) {
                attachmentView.listContent.setPopupItem(null, false);
                ((JComponent)((Object)attachmentView.listContent)).repaint();
            }
        }
    }

    private class ActionChangeItemIconSize
    extends AbstractAction {
        private int viewMode;

        public ActionChangeItemIconSize(int n, String string) {
            super(string);
            this.viewMode = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AttachmentView.this.setViewMode(this.viewMode);
        }
    }
}

