/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.novell.gw.engine.TransferAttachments;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.DnDUtils;
import com.novell.gw.jclient.application.controls.attachmentlist.AttachmentView;
import com.novell.gw.jclient.application.controls.attachmentlist.OpenAttachmentView;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class AttachmentsDragGestureListener
implements DragGestureListener {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$attachmentlist$AttachmentsDragGestureListener == null ? (class$com$novell$gw$jclient$application$controls$attachmentlist$AttachmentsDragGestureListener = AttachmentsDragGestureListener.class$("com.novell.gw.jclient.application.controls.attachmentlist.AttachmentsDragGestureListener")) : class$com$novell$gw$jclient$application$controls$attachmentlist$AttachmentsDragGestureListener));
    private AttachmentView attachmentView;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$attachmentlist$AttachmentsDragGestureListener;

    public AttachmentsDragGestureListener(AttachmentView attachmentView) {
        this.attachmentView = attachmentView;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (dragGestureEvent.getTriggerEvent() instanceof MouseEvent && ((MouseEvent)dragGestureEvent.getTriggerEvent()).getButton() == 2) {
            return;
        }
        if ((dragGestureEvent.getDragAction() & 3) > 0) {
            dragGestureEvent.getSourceAsDragGestureRecognizer().setSourceActions(1);
            BufferedImage bufferedImage = new BufferedImage(100, 100, 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
            JLabel jLabel = new JLabel(ImageResources.ICON_MESSAGE);
            jLabel.paint(graphics2D);
            if (this.attachmentView.getSelectedIndices().length > 0) {
                dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, bufferedImage, new Point(0, 0), new AttachmentsWrapper(), new AttachmentsDragSourceListener());
            }
        }
    }

    private List getFileList() {
        Object[] objectArray = this.attachmentView.getSelectedObjects();
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Serializable serializable;
            String string = "";
            if (objectArray[i] instanceof GWAttachment) {
                serializable = (GWAttachment)objectArray[i];
                if (!((GWAttachment)serializable).isLocalFile()) {
                    String string2 = ControlsUtils.getAttachmentFilePath((GWAttachment)serializable).getAbsolutePath();
                    MessageUtils.saveAttachment((GWAttachment)serializable, string2);
                }
                string = ((GWAttachment)serializable).getLocalFilePath();
            } else if (objectArray[i] instanceof AbstractItem) {
                serializable = (AbstractItem)objectArray[i];
                string = DnDUtils.saveItem((AbstractItem)serializable);
            }
            if ("".equals(string) || !((File)(serializable = new File(string))).isFile()) continue;
            arrayList.add(serializable);
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AttachmentsDragSourceListener
    extends DragSourceAdapter {
        private int userAction;

        private AttachmentsDragSourceListener() {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (dragSourceDropEvent.getDropSuccess()) {
                // empty if block
            }
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            this.userAction = dragSourceDragEvent.getUserAction();
            if ((this.userAction | 3) > 0) {
                dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
            }
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            this.userAction = dragSourceDragEvent.getUserAction();
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            if ((this.userAction | 3) > 0) {
                dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
            }
        }
    }

    private class AttachmentsWrapper
    implements Transferable {
        private DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, GWFlavors.attachmentsFlavor, GWFlavors.uriListFlavor, DataFlavor.stringFlavor};

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return Arrays.asList(this.flavors).contains(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                return AttachmentsDragGestureListener.this.getFileList();
            }
            if (dataFlavor.equals(GWFlavors.uriListFlavor)) {
                return DnDUtils.getUrlFromFileList(AttachmentsDragGestureListener.this.getFileList());
            }
            if (dataFlavor.equals(GWFlavors.attachmentsFlavor)) {
                AttachmentView attachmentView = AttachmentsDragGestureListener.this.attachmentView;
                int[] nArray = attachmentView.getSelectedIndices();
                if (attachmentView instanceof OpenAttachmentView) {
                    int n = 0;
                    while (n < nArray.length) {
                        int n2 = n++;
                        nArray[n2] = nArray[n2] - 1;
                    }
                }
                TransferAttachments transferAttachments = attachmentView.getItem().getNativeItem().getTransferAttachments(nArray);
                return transferAttachments;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

