/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.engine.TransferAttachments;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.attachmentlist.ComposeAttachmentView;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

class AttachmentsDropTargetListener
extends DropTargetAdapter {
    private static final Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$attachmentlist$ComposeAttachmentView == null ? (class$com$novell$gw$jclient$application$controls$attachmentlist$ComposeAttachmentView = AttachmentsDropTargetListener.class$("com.novell.gw.jclient.application.controls.attachmentlist.ComposeAttachmentView")) : class$com$novell$gw$jclient$application$controls$attachmentlist$ComposeAttachmentView));
    private ComposeAttachmentView attachmentView;
    private MVCController controller;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$attachmentlist$ComposeAttachmentView;

    public AttachmentsDropTargetListener(ComposeAttachmentView composeAttachmentView, MVCController mVCController) {
        this.attachmentView = composeAttachmentView;
        this.controller = mVCController;
    }

    private boolean attachItems(Transferable transferable) throws UnsupportedFlavorException, IOException {
        TransferItems transferItems = (TransferItems)transferable.getTransferData(GWFlavors.itemsFlavor);
        return (this.attachmentView.getItem().getTransferOptions(transferItems) & 4) > 0 && this.attachmentView.item.getNativeItem().transfer(transferItems, 4);
    }

    private boolean attachFiles(Transferable transferable) throws UnsupportedFlavorException, IOException {
        List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        this.controller.processCommand(new Command(760, list));
        return true;
    }

    private boolean attachAttachments(Transferable transferable) throws UnsupportedFlavorException, IOException {
        TransferAttachments transferAttachments = (TransferAttachments)transferable.getTransferData(GWFlavors.attachmentsFlavor);
        return (this.attachmentView.getItem().getNativeItem().getTransferOptions(transferAttachments) & 4) > 0 && this.attachmentView.item.transfer(transferAttachments, 4);
    }

    void dropComplete(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.dropComplete(true);
        this.attachmentView.reloadAttachments();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDataFlavorSupported(dropTargetDragEvent.getCurrentDataFlavorsAsList())) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private boolean isDataFlavorSupported(List list) {
        String string = ControlsUtils.getUserGuid(this.controller);
        return list.contains(GWFlavors.itemsFlavor) && string.equals(GWFlavors.itemsFlavor.getUserGuid()) || list.contains(DataFlavor.javaFileListFlavor) || list.contains(GWFlavors.attachmentsFlavor) || OS.isLinuxOS() && (list.contains(GWFlavors.uriListFlavor) || list.contains(DataFlavor.stringFlavor));
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (dropTargetDropEvent.getCurrentDataFlavorsAsList().contains(GWFlavors.itemsFlavor)) {
                this.attachItems(transferable);
            } else if (dropTargetDropEvent.getCurrentDataFlavorsAsList().contains(GWFlavors.attachmentsFlavor)) {
                this.attachAttachments(transferable);
            } else if (dropTargetDropEvent.getCurrentDataFlavorsAsList().contains(DataFlavor.javaFileListFlavor)) {
                this.attachFiles(transferable);
            } else if (dropTargetDropEvent.getCurrentDataFlavorsAsList().contains(GWFlavors.uriListFlavor)) {
                String string = (String)transferable.getTransferData(GWFlavors.uriListFlavor);
                this.attachFiles(string);
            } else if (dropTargetDropEvent.getCurrentDataFlavorsAsList().contains(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.attachFiles(string);
            }
            this.dropComplete(dropTargetDropEvent);
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
    }

    private void attachFiles(String string) {
        List list = Utils.getFileList(string);
        if (list.size() > 0) {
            this.controller.processCommand(new Command(760, list));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

