/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.attachmentlist.BorderLabel;
import com.novell.gw.jclient.application.controls.attachmentlist.ViewContent;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

class LargeIconsListRenderer
implements ListCellRenderer {
    private static final Color LIGHT_SELECTION_COLOR = Color.LIGHT_GRAY;
    private BorderLabel lbIcon = new BorderLabel();
    private JPanel pnlContent;
    private boolean viewMessage;
    private ViewContent viewContent;

    public LargeIconsListRenderer(boolean bl, ViewContent viewContent) {
        this.lbIcon.setHorizontalTextPosition(0);
        this.lbIcon.setVerticalTextPosition(3);
        this.lbIcon.setOpaque(true);
        this.lbIcon.setHorizontalAlignment(0);
        this.lbIcon.setPreferredSize(new Dimension(100, 55));
        this.pnlContent = new OrientablePanel(new BorderLayout(0, 5));
        this.pnlContent.add((Component)this.lbIcon, "Center");
        this.pnlContent.setOpaque(false);
        this.pnlContent.setBorder(BorderFactory.createEmptyBorder(0, 10, 25, 10));
        this.viewMessage = bl;
        this.viewContent = viewContent;
    }

    private Icon getIconForAttachment(Object object) {
        if (object instanceof GWAttachment) {
            GWAttachment gWAttachment = (GWAttachment)object;
            return ControlsUtils.getBigIconForAttachment(gWAttachment.getFileName(), gWAttachment.getDownloadState());
        }
        if (object instanceof AbstractItem) {
            return ControlsUtils.getAttachmentIconForGWItem((AbstractItem)object, true);
        }
        throw new IllegalArgumentException("Unsupported attachment type [" + object.getClass().getName() + "]");
    }

    public boolean isMessage(Object object) {
        return object instanceof AbstractItem;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (n == 0 && this.isMessage(object) && this.viewMessage) {
            this.lbIcon.setText(StringResources.MESSAGE);
            this.lbIcon.setIcon(ImageResources.ICON_MESSAGE);
        } else {
            this.lbIcon.setIcon(this.getIconForAttachment(object));
            this.lbIcon.setText(object.toString());
        }
        if (bl) {
            if (this.viewContent.isSelectionEnabled()) {
                this.lbIcon.setBackground(jList.getSelectionBackground());
            } else if (this.viewContent.getPopupItem() == object) {
                this.lbIcon.setBackground(jList.getSelectionBackground());
            } else {
                this.lbIcon.setBackground(LIGHT_SELECTION_COLOR);
            }
            this.lbIcon.setForeground(jList.getSelectionForeground());
        } else {
            this.lbIcon.setBackground(jList.getBackground());
            this.lbIcon.setForeground(jList.getForeground());
        }
        this.lbIcon.setPaintBorder(object == this.viewContent.getPopupItem());
        return this.pnlContent;
    }
}

