/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.autodate;

import com.novell.gw.jclient.application.controls.autodate.AutoDateCalendar;
import com.novell.gw.jclient.application.controls.autodate.AutoDateChangeEvent;
import com.novell.gw.jclient.application.controls.autodate.AutoDateChangeListener;
import com.novell.gw.jclient.application.controls.autodate.SpinYearButtons;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class SetDateCalendarPanel
extends JComponent
implements AutoDateChangeListener {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$autodate$SetDateCalendarPanel == null ? (class$com$novell$gw$jclient$application$controls$autodate$SetDateCalendarPanel = SetDateCalendarPanel.class$("com.novell.gw.jclient.application.controls.autodate.SetDateCalendarPanel")) : class$com$novell$gw$jclient$application$controls$autodate$SetDateCalendarPanel));
    private static final int CALENDARS_COUNT = 12;
    private HashMap selected = new HashMap();
    private AutoDateCalendar[] calendars = new AutoDateCalendar[12];
    private GregorianCalendar startDate = GWCalendarUtils.getToday();
    private SpinYearButtons spinButtons;
    private boolean isYearAdjusting;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$autodate$SetDateCalendarPanel;

    public SetDateCalendarPanel() {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.buildUI();
    }

    private void buildUI() {
        int n = 10;
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(3, 4, n, n));
        for (int i = 0; i < this.calendars.length; ++i) {
            this.calendars[i] = new AutoDateCalendar();
            this.calendars[i].addAutoDateChangeListener(this);
            orientablePanel.add(this.calendars[i]);
        }
        JPanel jPanel = new JPanel();
        jPanel.add(orientablePanel);
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        this.spinButtons = new SpinYearButtons();
        this.spinButtons.addPropertyChangeListener("Date_changed", new DateChangeListener());
        jPanel2.add(this.spinButtons);
        this.add((Component)jPanel2, "North");
    }

    public void selectionChanged(AutoDateChangeEvent autoDateChangeEvent) {
        GregorianCalendar gregorianCalendar = autoDateChangeEvent.getDate();
        String string = GWCalendarUtils.calendarToString(gregorianCalendar);
        if (autoDateChangeEvent.wasAdded()) {
            this.selected.put(string, gregorianCalendar);
        } else {
            this.selected.remove(string);
        }
    }

    private void validateCalendars() {
        this.startDate.set(2, 0);
        GregorianCalendar[] gregorianCalendarArray = this.getSelectedDates();
        for (int i = 0; i < this.calendars.length; ++i) {
            this.calendars[i].setCurrDay(this.startDate);
            this.calendars[i].clearMultiselectDates();
            this.calendars[i].addMultiselectDates(gregorianCalendarArray);
            this.calendars[i].refreshView();
            this.startDate.add(2, 1);
        }
    }

    public void setSelectedDates(GregorianCalendar[] gregorianCalendarArray) {
        this.selected.clear();
        for (int i = 0; i < gregorianCalendarArray.length; ++i) {
            GregorianCalendar gregorianCalendar = gregorianCalendarArray[i];
            this.startDate.setTime(gregorianCalendar.getTime());
            String string = GWCalendarUtils.calendarToString(gregorianCalendar);
            this.selected.put(string, gregorianCalendar);
        }
        if (gregorianCalendarArray.length == 0) {
            this.startDate.setTime(GWCalendarUtils.getToday().getTime());
        }
        this.isYearAdjusting = true;
        this.goToYear(this.startDate.get(1));
        this.isYearAdjusting = false;
        this.validateCalendars();
    }

    public GregorianCalendar[] getSelectedDates() {
        GregorianCalendar[] gregorianCalendarArray = new GregorianCalendar[this.selected.size()];
        return this.selected.values().toArray(gregorianCalendarArray);
    }

    public void reset() {
        this.selected.clear();
        this.goToYear(GWCalendarUtils.getToday().get(1));
    }

    private void goToYear(int n) {
        this.spinButtons.setYear(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DateChangeListener
    implements PropertyChangeListener {
        private DateChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!SetDateCalendarPanel.this.isYearAdjusting) {
                SetDateCalendarPanel.this.startDate.setTime(((GregorianCalendar)propertyChangeEvent.getNewValue()).getTime());
                SetDateCalendarPanel.this.validateCalendars();
            }
        }
    }
}

