/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.autodate;

import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.MonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class SetDateDialog
extends BasicDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$autodate$SetDateDialog == null ? (class$com$novell$gw$jclient$application$controls$autodate$SetDateDialog = SetDateDialog.class$("com.novell.gw.jclient.application.controls.autodate.SetDateDialog")) : class$com$novell$gw$jclient$application$controls$autodate$SetDateDialog));
    private MonthlyCalendar dayCalendar;
    private JTextField tfDate;
    private JButton btnOK;
    private JButton btnCancel;
    private JButton btnToday;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$autodate$SetDateDialog;

    public SetDateDialog(Dialog dialog) throws HeadlessException {
        super(dialog, true);
        this.buildUI();
    }

    public SetDateDialog(Frame frame) throws HeadlessException {
        super(frame, true);
        this.buildUI();
    }

    public SetDateDialog() throws HeadlessException {
        this.buildUI();
        this.setModal(true);
    }

    private void buildUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 23;
        jPanel.add((Component)this.buildCalendarPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 24;
        jPanel.add((Component)this.buildButtonsPanel(), gridBagConstraints);
        this.refreshUI();
        this.pack();
        this.setDefaultButton(this.btnOK);
        this.setCancelButton(this.btnCancel);
        this.addWindowListener(new ActionCloseWindow());
        this.setLocationRelativeTo(this.getOwner());
    }

    private void refreshUI() {
        this.tfDate.setText(GWCalendarUtils.getDateFormat().format(this.dayCalendar.getDate().getTime()));
    }

    private JComponent buildButtonsPanel() {
        this.btnOK = new JButton(new ActionOK());
        this.btnCancel = new JButton(new ActionCancel());
        this.btnToday = new JButton(new ActionToday());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.btnOK, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 23;
        jPanel.add((Component)this.btnToday, gridBagConstraints);
        return jPanel;
    }

    private JPanel buildCalendarPanel() {
        this.dayCalendar = new MonthlyCalendar(GWCalendarUtils.getToday(), true, false);
        this.dayCalendar.addValueChangeListener(new CalendarDateChangeListener());
        this.tfDate = new OrientableTextField();
        this.tfDate.setEditable(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder(0);
        Border border2 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        jPanel.setBorder(BorderFactory.createCompoundBorder(border, border2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.dayCalendar, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.tfDate, gridBagConstraints);
        return jPanel;
    }

    public GregorianCalendar getSelectedDate() {
        return this.dayCalendar.getDate();
    }

    public void setSelectedDate(GregorianCalendar gregorianCalendar) {
        this.dayCalendar.setDate(gregorianCalendar);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CalendarDateChangeListener
    implements DateValueChangeListener {
        private CalendarDateChangeListener() {
        }

        public void valueChanged(DateChangeEvent dateChangeEvent) {
            SetDateDialog.this.refreshUI();
        }
    }

    private class ActionCloseWindow
    extends WindowAdapter {
        private ActionCloseWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            SetDateDialog.this.setActionCompleteSuccessfully(false);
            SetDateDialog.this.setVisible(false);
        }
    }

    private class ActionOK
    extends AbstractAction {
        public ActionOK() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SetDateDialog.this.setActionCompleteSuccessfully(true);
            SetDateDialog.this.setVisible(false);
        }
    }

    private class ActionCancel
    extends AbstractAction {
        public ActionCancel() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SetDateDialog.this.setActionCompleteSuccessfully(false);
            SetDateDialog.this.setVisible(false);
        }
    }

    private class ActionToday
    extends AbstractAction {
        public ActionToday() {
            super(StringResources.TODAY);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SetDateDialog.this.dayCalendar.gotoToday();
            SetDateDialog.this.refreshUI();
        }
    }
}

