/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.busysearch.AvailableTimeGrid;
import com.novell.gw.jclient.application.controls.busysearch.BSScrollPane;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.InfoPanel;
import com.novell.gw.jclient.application.controls.busysearch.RecipientTree;
import com.novell.gw.jclient.application.controls.gwcalendar.AbstractCalendarView;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;

public class AvailableWithTreePanel
extends AbstractCalendarView
implements MVCView {
    private AvailableTimeGrid.DayLabels busyDayLabels;
    private AvailableTimeGrid.HourLabels busyHourLabels;
    private int daysCount = 7;
    private InfoPanel infoAvailablePanel;
    private GWBusySearch busySearch;
    private RecipientTree recipientsTree;
    private AvailableTimeGrid availableTime;
    private JButton inviteButton = new OrientableButton();
    private MVCController controller;

    public AvailableWithTreePanel(GWBusySearch gWBusySearch, JButton jButton, MVCController mVCController) {
        this.busySearch = gWBusySearch;
        this.inviteButton = jButton;
        this.controller = mVCController;
        this.buildUI();
    }

    protected void refreshView() {
        if (!this.isShowing()) {
            this.wasViewRefreshed = true;
            return;
        }
        this.availableTime.setMVCModel(this.busySearch);
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.availableTime = new AvailableTimeGrid(this.busySearch, this.getController());
        this.busyHourLabels = new AvailableTimeGrid.HourLabels();
        this.busyDayLabels = new AvailableTimeGrid.DayLabels(this.daysCount);
        this.busyDayLabels.setMinimumCellWidth(26);
        this.availableTime.setPreferredSize(new Dimension(Short.MAX_VALUE, this.availableTime.getPreferredSize().height));
        BSScrollPane bSScrollPane = new BSScrollPane(this.availableTime);
        bSScrollPane.setPreferredSize(new Dimension(550, this.availableTime.getPreferredSize().height));
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BusySearchFrame.sideBorder, BusySearchFrame.lineBorder);
        bSScrollPane.setBorder(BusySearchFrame.sideBorder);
        bSScrollPane.setHorizontalScrollBarPolicy(32);
        bSScrollPane.setRowHeaderView(this.busyHourLabels);
        bSScrollPane.setColumnHeaderView(this.busyDayLabels);
        this.add((Component)bSScrollPane, "Center");
        this.add((Component)this.buildRecipientTreePanel(), "After");
        this.infoAvailablePanel = new InfoPanel(this.getController());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.infoAvailablePanel, "South");
        jPanel.setBorder(compoundBorder);
        this.add((Component)jPanel, "South");
    }

    public void selectDefaultComponent() {
        this.availableTime.requestFocusInWindow();
    }

    public JComponent getDefaultComponent() {
        return this.availableTime;
    }

    private JComponent buildRecipientTreePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.recipientsTree = new RecipientTree(this.getController());
        this.recipientsTree.setBorder(BusySearchFrame.lineBorder);
        jPanel.add((Component)new OrientableScrollPane(this.recipientsTree), "Center");
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 10, 0, this.inviteButton.getBackground()), this.inviteButton.getBorder());
        this.inviteButton.setBorder(compoundBorder);
        jPanel.add((Component)this.inviteButton, "North");
        jPanel.setBorder(BusySearchFrame.sideBorder);
        return jPanel;
    }

    public void setController(MVCController mVCController) {
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        if (object instanceof GWBusySearch) {
            this.busySearch = (GWBusySearch)object;
            this.busyDayLabels.setDaysCount(this.busySearch.getDaysCount());
            this.busyDayLabels.setTitles(this.busySearch.getStartDate(), null);
            this.refreshView();
        } else if (object instanceof TimeInterval) {
            this.busySearch.setAppointmentTime((TimeInterval)object);
            this.refreshView();
        }
    }

    public Object getMVCModel() {
        return null;
    }
}

