/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.components.AbstractCancelAction;
import com.appframework.components.AbstractOKAction;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.actions.ActionNewAppointment;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.busysearch.AvailableWithTreePanel;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrameController;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.InviteToMeetingDialog;
import com.novell.gw.jclient.application.controls.busysearch.ShedulesWithListPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.AbstractCalendarView;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import com.novell.gw.message.BusySearchEvent;
import com.novell.gw.message.BusySearchListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class BusySearchFrame
extends JFrame
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$busysearch$BusySearchFrame == null ? (class$com$novell$gw$jclient$application$controls$busysearch$BusySearchFrame = BusySearchFrame.class$("com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame")) : class$com$novell$gw$jclient$application$controls$busysearch$BusySearchFrame));
    public static final Color COLOR_OUT_OF_OFFICE = new Color(128, 128, 128);
    public static final Color COLOR_BUSY = new Color(192, 192, 192);
    public static final Color COLOR_TENTATIVE = new Color(230, 230, 230);
    public static final Color COLOR_AVAILABLE = Color.white;
    private GWBusySearch busySearch = null;
    private AvailableWithTreePanel availableWithTree;
    static Border sideBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    static Border lineBorder = BorderFactory.createLineBorder(Color.darkGray, 1);
    private JButton btnOK;
    private JButton btnRequest;
    private ActionNewAppointment actionNewAppointment;
    public static final int CELL_WIDTH = 26;
    private ShedulesWithListPanel shedulesWithListPanel;
    private BtnInviteToMeetingAction inviteToMeetingAction = new BtnInviteToMeetingAction();
    private JLabel searchingIndicator;
    private MVCController controller;
    private JLabel lblOneOfAll;
    private int recipientCount = 0;
    private int recipientCompleted = 0;
    private JPanel searchingIndicatorPanel;
    private JTabbedPane tpCalendarView = new OrientableTabbedPane();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$busysearch$BusySearchFrame;

    public BusySearchFrame(GWBusySearch gWBusySearch, MVCController mVCController) {
        this.controller = new BusySearchFrameController(mVCController.getLevel());
        this.controller.setMVCView(this);
        this.setDefaultCloseOperation(2);
        this.buildUI();
        this.setMVCModel(gWBusySearch);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            public Component getComponentAfter(Container container, Component component) {
                Component component2 = super.getComponentAfter(container, component);
                if (component instanceof ShedulesWithListPanel) {
                    return ((AbstractCalendarView)component).getDefaultComponent();
                }
                return component2;
            }
        });
    }

    public void setController(MVCController mVCController) {
        this.controller = mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    private void buildUI() {
        this.setTitle(StringResources.CHOOSE_APPOINTMENT_TIME);
        this.setIconImage(ImageResources.ACT_BUSYSEARCH.getImage());
        Container container = this.getContentPane();
        container.setComponentOrientation(UIUtils.getComponentOrientation());
        container.setLayout(new BorderLayout());
        container.add((Component)this.buildCentralPanel(), "Center");
        container.add((Component)this.buildButtonsPanel(), "South");
    }

    private JPanel buildCentralPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        this.buildAvailableTimesPanel();
        this.tpCalendarView.add(StringResources.AVAILABLE_TIMES, this.availableWithTree);
        this.buildIndividualShedulePanel();
        this.tpCalendarView.add(StringResources.INDIVIDUAL_SCHEDULES, this.shedulesWithListPanel);
        this.tpCalendarView.setSelectedIndex(1);
        orientablePanel.add((Component)this.tpCalendarView, "Center");
        orientablePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return orientablePanel;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.shedulesWithListPanel.selectDefaultComponent();
        }
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        OrientablePanel orientablePanel2 = new OrientablePanel();
        this.btnOK = new JButton(new OKAction());
        this.btnRequest = new JButton(new RequestAction());
        this.btnRequest.setVisible(false);
        CancelAction cancelAction = new CancelAction();
        JButton jButton = new JButton(cancelAction);
        jButton.registerKeyboardAction(cancelAction, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().setDefaultButton(this.btnOK);
        OS.addButtons(orientablePanel2, this.btnOK, jButton, this.btnRequest);
        this.buildSearchingIndicatorPanel();
        orientablePanel.add((Component)orientablePanel2, "After");
        orientablePanel.add((Component)this.createLegendPanel(), "Before");
        orientablePanel.add((Component)this.searchingIndicatorPanel, "South");
        return orientablePanel;
    }

    private JPanel createLegendPanel() {
        OrientablePanel orientablePanel = new OrientablePanel();
        EmptyBorder emptyBorder = orientablePanel.getComponentOrientation().isLeftToRight() ? new EmptyBorder(0, 0, 0, 15) : new EmptyBorder(0, 15, 0, 0);
        orientablePanel.add(this.buildLegendLabel(COLOR_OUT_OF_OFFICE));
        OrientableLabel orientableLabel = new OrientableLabel(StringResources.OUT_OF_OFFICE);
        orientableLabel.setBorder(emptyBorder);
        orientablePanel.add(orientableLabel);
        orientablePanel.add(this.buildLegendLabel(COLOR_BUSY));
        orientableLabel = new OrientableLabel(StringResources.BUSY);
        orientableLabel.setBorder(emptyBorder);
        orientablePanel.add(orientableLabel);
        orientablePanel.add(this.buildLegendLabel(COLOR_TENTATIVE));
        orientableLabel = new OrientableLabel(StringResources.TENTATIVE);
        orientableLabel.setBorder(emptyBorder);
        orientablePanel.add(orientableLabel);
        return orientablePanel;
    }

    private void buildSearchingIndicatorPanel() {
        this.searchingIndicatorPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.searchingIndicator = new OrientableLabel(StringResources.PERFORMING_BUSY_SEARCH + " ");
        this.searchingIndicator.setBorder(BorderFactory.createLoweredBevelBorder());
        this.searchingIndicator.setIcon(ImageResources.ICON_BUSY_SEARCH_SEARCHING);
        gridBagConstraints.ipadx = 10;
        this.searchingIndicatorPanel.add((Component)this.searchingIndicator, gridBagConstraints);
        this.lblOneOfAll = new OrientableLabel(" ");
        this.lblOneOfAll.setBorder(BorderFactory.createLoweredBevelBorder());
        this.lblOneOfAll.setHorizontalAlignment(0);
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        this.searchingIndicatorPanel.add((Component)this.lblOneOfAll, gridBagConstraints);
        OrientableLabel orientableLabel = new OrientableLabel(" ");
        orientableLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        this.searchingIndicatorPanel.add((Component)orientableLabel, gridBagConstraints);
        this.searchingIndicatorPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    private JLabel buildLegendLabel(Color color) {
        Dimension dimension = new Dimension(14, 13);
        OrientableLabel orientableLabel = new OrientableLabel();
        orientableLabel.setPreferredSize(dimension);
        orientableLabel.setMinimumSize(dimension);
        orientableLabel.setOpaque(true);
        orientableLabel.setBackground(color);
        orientableLabel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        return orientableLabel;
    }

    private void buildAvailableTimesPanel() {
        this.availableWithTree = new AvailableWithTreePanel(this.busySearch, new JButton(this.inviteToMeetingAction), this.getController());
        this.availableWithTree.setBorder(sideBorder);
    }

    private void buildIndividualShedulePanel() {
        this.shedulesWithListPanel = new ShedulesWithListPanel(this.busySearch, new JButton(this.inviteToMeetingAction), this.getController());
        this.shedulesWithListPanel.setBorder(sideBorder);
    }

    private void refreshView() {
        boolean bl = this.busySearch.isStillWorking();
        logger.debug((Object)("search completed - " + !bl));
        this.busySearch.init();
        this.inviteToMeetingAction.setEnabled(!bl);
        this.refreshSearchingIndicator(bl);
        this.availableWithTree.setMVCModel(this.busySearch);
        this.shedulesWithListPanel.setMVCModel(this.busySearch);
    }

    private void refreshSearchingIndicator(boolean bl) {
        int n = this.busySearch.getRecipientsList().getFailedSize();
        if (n == 0) {
            this.searchingIndicator.setText(StringResources.PERFORMING_BUSY_SEARCH + " ");
            this.searchingIndicator.setIcon(ImageResources.ICON_BUSY_SEARCH_SEARCHING);
            this.searchingIndicatorPanel.setVisible(bl);
            this.lblOneOfAll.setVisible(bl);
            this.lblOneOfAll.setText(this.recipientCompleted + " of " + this.recipientCount);
        } else {
            this.searchingIndicator.setIcon(null);
            this.searchingIndicator.setText(StringResources.formatString(StringResources.UNDELIVERABLE_ON_C, new String[]{new Integer(n).toString(), new Integer(this.recipientCount).toString()}));
            this.lblOneOfAll.setText(" ");
        }
    }

    public void setNewAppointmentAction(ActionNewAppointment actionNewAppointment) {
        this.actionNewAppointment = actionNewAppointment;
        this.btnOK.setVisible(false);
        this.btnRequest.setVisible(true);
    }

    public void setMVCModel(Object object) {
        logger.debug((Object)"setMVCModel entered");
        if (object instanceof GWBusySearch) {
            this.busySearch = (GWBusySearch)object;
            this.busySearch.setBusySearchListener(new BusySearchStateListener());
            this.recipientCount = this.busySearch.getRecipientsList().getResolvedList().size();
            this.recipientCompleted = 0;
            this.refreshView();
        }
        logger.debug((Object)"setMVCModel exited");
    }

    public Object getMVCModel() {
        return null;
    }

    public static String getRecipientID(Recipient recipient) {
        String string = recipient.getAddressable().getGuid();
        if (string == null || string.equals("")) {
            string = recipient.getAddressable().getEmailAddress();
        }
        return string;
    }

    public void dispose() {
        this.busySearch.cancel();
        super.dispose();
    }

    public void setDateAndInterval(Date date, TimeInterval timeInterval) {
        this.busySearch.setStartDate(date);
        this.busySearch.setAppointmentTime(timeInterval);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BusySearchStateListener
    implements BusySearchListener {
        private BusySearchStateListener() {
        }

        public void moreBusySearchResultsAvailable(BusySearchEvent busySearchEvent) {
            this.stateChanged(busySearchEvent);
        }

        public void busySearchResultsComplete(BusySearchEvent busySearchEvent) {
            this.stateChanged(busySearchEvent);
        }

        private void stateChanged(BusySearchEvent busySearchEvent) {
            BusySearchFrame.this.busySearch.setStillWorking(busySearchEvent.getStatus() == 0);
            logger.debug((Object)("still working - " + busySearchEvent.getStillWorking()));
            logger.debug((Object)("completed - " + busySearchEvent.getCompleted()));
            logger.debug((Object)("failed - " + busySearchEvent.getFailed()));
            BusySearchFrame.this.recipientCompleted = busySearchEvent.getCompleted();
            if (SwingUtilities.isEventDispatchThread()) {
                BusySearchFrame.this.refreshView();
            } else {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ BusySearchStateListener this$1;
                    {
                        this.this$1 = busySearchStateListener;
                    }

                    public void run() {
                        BusySearchFrame.access$1000(BusySearchStateListener.access$1100(this.this$1));
                    }
                });
            }
        }

        static /* synthetic */ BusySearchFrame access$1100(BusySearchStateListener busySearchStateListener) {
            return busySearchStateListener.BusySearchFrame.this;
        }
    }

    class BtnInviteToMeetingAction
    extends AbstractAction {
        public BtnInviteToMeetingAction() {
            super(StringResources.INVITE_TO_MEETING);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            InviteToMeetingDialog inviteToMeetingDialog = new InviteToMeetingDialog(BusySearchFrame.this);
            inviteToMeetingDialog.setMVCModel(BusySearchFrame.this.busySearch);
            inviteToMeetingDialog.showMe();
            if (!inviteToMeetingDialog.isActionCompleteSuccessfully()) {
                BusySearchFrame.this.btnOK.setEnabled(true);
                this.setEnabled(true);
            } else {
                BusySearchFrame.this.searchingIndicator.setVisible(true);
                try {
                    String string = ControlsUtils.getUserGuid(BusySearchFrame.this.controller);
                    GWBusySearch gWBusySearch = GWCommandManager.getInstance(string).composeBusySearch(inviteToMeetingDialog.getRecepientDescriptinsList(), inviteToMeetingDialog.getStartDate(), inviteToMeetingDialog.getDaysCount(), BusySearchFrame.this.busySearch.getAppointmentTime());
                    if (gWBusySearch == null) {
                        JOptionPane.showMessageDialog(null, StringResources.BYSY_SEARCH_NO_VALID_USERS);
                        return;
                    }
                    BusySearchFrame.this.setMVCModel(gWBusySearch);
                }
                catch (GWCommandException gWCommandException) {
                    logger.error((Object)gWCommandException, (Throwable)gWCommandException);
                }
            }
        }
    }

    class RequestAction
    extends AbstractAction {
        public RequestAction() {
            super(StringResources.REQUEST_MEETING_D);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BusySearchFrame.this.busySearch.isStillWorking()) {
                BusySearchFrame.this.busySearch.cancel();
            }
            BusySearchFrame.this.actionNewAppointment.setMVCModel(BusySearchFrame.this.busySearch);
            BusySearchFrame.this.actionNewAppointment.actionPerformed(null);
            BusySearchFrame.this.dispose();
        }
    }

    private class OKAction
    extends AbstractOKAction {
        private OKAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Command command = new Command(770, BusySearchFrame.this.busySearch);
            BusySearchFrame.this.getController().processCommand(command);
            BusySearchFrame.this.dispose();
        }
    }

    private class CancelAction
    extends AbstractCancelAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BusySearchFrame.this.dispose();
        }
    }
}

