/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

class DragRectanglePanel
extends OrientablePanel
implements MouseListener,
MouseMotionListener,
ComponentListener {
    protected static final int DRAGGING_NO = 0;
    protected static final int DRAGGING_RECTANGLE = 1;
    protected static final int DRAGGING_UPPER_SIDE = 2;
    protected static final int DRAGGING_LOWER_SIDE = 3;
    protected static final int DRAGGING_LEFT_SIDE = 4;
    protected static final int DRAGGING_RIGHT_SIDE = 5;
    protected int draggingMode = 0;
    private Rectangle recSelectedTime;
    protected Rectangle recDragged;
    private Color colorSelectedRectangle = Color.BLACK;
    protected int columnCount = 7;
    protected int rowCount = 24;
    protected float columnWidth = 30.0f;
    protected float rowHeight = 30.0f;
    private Dimension minimumCellSize = new Dimension(30, 30);
    protected ArrayList rowY = new ArrayList(this.rowCount);
    protected ArrayList colX = new ArrayList(this.columnCount);
    protected int selectedColumn = 0;
    protected int selectedRow = 0;
    protected int selectedWidth = 1;
    protected int selectedHeight = 1;
    private Dimension panelDimension;
    private boolean isHorizontallyResizible = true;
    private boolean isVerticallyResizible = true;
    private boolean isGridDrawing = false;
    private BasicStroke rectStroke = new BasicStroke(2.0f);
    protected int dx;
    protected int dy;
    private Rectangle recDragging = new Rectangle();
    private Rectangle recUpperSide = new Rectangle();
    private Rectangle recLowerSide = new Rectangle();
    private Rectangle recLeftSide = new Rectangle();
    private Rectangle recRightSide = new Rectangle();
    protected static final int RESIZE_HEIGHT = 3;

    public DragRectanglePanel(int n, int n2) {
        this.columnCount = n;
        this.rowCount = n2;
        this.updatePhysicalCoordinates();
        this.buildUI();
        Rectangle rectangle = new Rectangle(0, this.recSelectedTime.y - (int)this.rowHeight * 4, 1, this.recSelectedTime.height);
        this.scrollRectToVisible(rectangle);
        this.addComponentListener(this);
    }

    public DragRectanglePanel() {
        this(20, 10);
    }

    private void buildUI() {
        this.updateSize();
        this.setOpaque(false);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.calculateGrid();
    }

    protected void calculateGrid() {
        int n;
        this.colX.clear();
        for (n = 0; n < this.columnCount; ++n) {
            this.colX.add(new Integer(Math.round(this.columnWidth * (float)n)));
        }
        this.rowY.clear();
        for (n = 0; n < this.rowCount; ++n) {
            this.rowY.add(new Integer(Math.round(this.rowHeight * (float)n)));
        }
    }

    protected void updatePhysicalCoordinates() {
        if (this.selectedHeight <= 0) {
            this.selectedHeight = 1;
        }
        if (this.selectedWidth <= 0) {
            this.selectedWidth = 1;
        }
        int n = Math.round(this.columnWidth * (float)this.selectedColumn) + 1;
        int n2 = Math.round(this.rowHeight * (float)this.selectedRow) + 1;
        int n3 = Math.round(this.columnWidth * (float)this.selectedWidth) - 1;
        int n4 = Math.round(this.rowHeight * (float)this.selectedHeight) - 1;
        this.recSelectedTime = new Rectangle(n, n2, n3, n4);
        this.recDragged = new Rectangle(this.recSelectedTime);
    }

    public float fromLogicalXToPthysical(int n) {
        return this.columnWidth * (float)n;
    }

    public int fromPhysicalXToLogical(int n) {
        return (int)((float)n / this.columnWidth);
    }

    public float fromLogicalYToPthysical(int n) {
        return this.rowHeight * (float)n;
    }

    public void setLogicalPosition(int n, int n2) {
        this.selectedRow = n2 > this.rowCount - 1 ? this.rowCount - 1 : (n2 < 0 ? 0 : n2);
        this.selectedColumn = n > this.columnCount - 1 ? this.columnCount - 1 : (n < 0 ? 0 : n);
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    public void setLogicalHeight(int n) {
        this.selectedHeight = n > this.rowCount ? this.rowCount : (n < 0 ? 1 : n);
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    public void setLogicalWidth(int n) {
        this.selectedWidth = n > this.columnCount ? this.columnCount : (n < 0 ? 0 : n);
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    protected void convertPhysicalXYToLogical(Rectangle rectangle) {
        this.selectedColumn = (int)((float)(rectangle.x + 1) / this.columnWidth);
        this.selectedRow = (int)((float)(rectangle.y + 1) / this.rowHeight);
        this.selectedWidth = Math.round((float)(rectangle.width + 1) / this.columnWidth);
        this.selectedHeight = Math.round((float)(rectangle.height + 1) / this.rowHeight);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isGridDrawing) {
            this.drawGridLines(graphics);
        }
        this.paintSelectedTime(graphics2D);
    }

    private void drawGridLines(Graphics graphics) {
        int n;
        graphics.setColor(ColorConstants.HEADER_BORDER_COLOR);
        int n2 = this.getHeight() / this.rowCount;
        for (n = 0; n < this.rowCount; ++n) {
            graphics.drawLine(0, n * n2, this.getWidth(), n * n2);
        }
        n2 = this.getWidth() / this.columnCount;
        for (n = 0; n < this.columnCount; ++n) {
            graphics.drawLine(n * n2, 0, n * n2, this.getHeight());
        }
    }

    private void paintSelectedTime(Graphics2D graphics2D) {
        graphics2D.setStroke(this.rectStroke);
        graphics2D.setColor(this.colorSelectedRectangle);
        Rectangle rectangle = this.draggingMode != 0 ? new Rectangle(this.recDragged) : new Rectangle(this.recSelectedTime);
        if (!this.getComponentOrientation().isLeftToRight()) {
            rectangle.x = this.getWidth() - rectangle.x - rectangle.width + 1;
        }
        graphics2D.draw(rectangle);
    }

    public void setHorizontallyResizible(boolean bl) {
        this.isHorizontallyResizible = bl;
    }

    public void setVerticallyResizible(boolean bl) {
        this.isVerticallyResizible = bl;
    }

    public void setMinimumCellSize(int n, int n2) {
        this.minimumCellSize.width = n;
        this.minimumCellSize.height = n2;
        this.updateSize();
        this.doComponentResized();
    }

    private void updateSize() {
        this.panelDimension = new Dimension(this.minimumCellSize.width * this.columnCount, this.minimumCellSize.height * this.rowCount);
        this.setPreferredSize(this.panelDimension);
        this.setMinimumSize(this.panelDimension);
    }

    public void setGridDrawing(boolean bl) {
        this.isGridDrawing = bl;
    }

    public void setRowCount(int n) {
        this.rowCount = n;
        this.updateSize();
        this.doComponentResized();
        this.updateUI();
    }

    public void setColumnCount(int n) {
        this.columnCount = n;
        this.updateSize();
        this.doComponentResized();
        this.updateUI();
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int n) {
        this.selectedRow = n;
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    public int getSelectedWidth() {
        return this.selectedWidth;
    }

    public int getSelectedHeight() {
        return this.selectedHeight;
    }

    protected void refreshRects() {
        this.recDragging.x = this.recSelectedTime.x + 3;
        this.recDragging.width = this.recSelectedTime.width - 6;
        this.recDragging.y = this.recSelectedTime.y + 3;
        this.recDragging.height = this.recSelectedTime.height - 6;
        this.recUpperSide.x = this.recSelectedTime.x + 3;
        this.recUpperSide.width = this.recSelectedTime.width - 6;
        this.recUpperSide.y = this.recSelectedTime.y;
        this.recUpperSide.height = 3;
        this.recLowerSide.x = this.recSelectedTime.x + 3;
        this.recLowerSide.width = this.recSelectedTime.width - 6;
        this.recLowerSide.y = this.recSelectedTime.y + this.recSelectedTime.height - 3;
        this.recLowerSide.height = 3;
        this.recLeftSide.x = this.recSelectedTime.x;
        this.recLeftSide.width = 3;
        this.recLeftSide.y = this.recSelectedTime.y;
        this.recLeftSide.height = this.recSelectedTime.height;
        this.recRightSide.x = this.recSelectedTime.x + this.recSelectedTime.width - 3;
        this.recRightSide.width = 3;
        this.recRightSide.y = this.recSelectedTime.y;
        this.recRightSide.height = this.recSelectedTime.height;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.recDragging.contains(mouseEvent.getPoint())) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else if (this.recUpperSide.contains(mouseEvent.getPoint()) && this.isVerticallyResizible) {
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.recLowerSide.contains(mouseEvent.getPoint()) && this.isVerticallyResizible) {
            this.setCursor(Cursor.getPredefinedCursor(9));
        } else if (this.recLeftSide.contains(mouseEvent.getPoint()) && this.isHorizontallyResizible) {
            this.setCursor(Cursor.getPredefinedCursor(10));
        } else if (this.recRightSide.contains(mouseEvent.getPoint()) && this.isHorizontallyResizible) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.recDragging.contains(mouseEvent.getPoint())) {
            this.dx = mouseEvent.getX() - this.recSelectedTime.x;
            this.dy = mouseEvent.getY() - this.recSelectedTime.y;
            this.draggingMode = 1;
        } else if (this.recLowerSide.contains(mouseEvent.getPoint()) && this.isVerticallyResizible) {
            this.dy = this.recSelectedTime.y + this.recSelectedTime.height - mouseEvent.getY();
            this.draggingMode = 3;
        } else if (this.recUpperSide.contains(mouseEvent.getPoint()) && this.isVerticallyResizible) {
            this.dy = mouseEvent.getY() - this.recSelectedTime.y;
            this.draggingMode = 2;
        } else if (this.recRightSide.contains(mouseEvent.getPoint()) && this.isHorizontallyResizible) {
            this.dx = this.recSelectedTime.x + this.recSelectedTime.width - mouseEvent.getX();
            this.draggingMode = 5;
        } else if (this.recLeftSide.contains(mouseEvent.getPoint()) && this.isHorizontallyResizible) {
            this.dx = mouseEvent.getX() - this.recSelectedTime.x;
            this.draggingMode = 4;
        } else {
            this.selectedColumn = (int)((float)mouseEvent.getX() / this.columnWidth);
            this.selectedRow = (int)((float)mouseEvent.getY() / this.rowHeight);
            this.updatePhysicalCoordinates();
            this.refreshRects();
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.draggingMode != 0) {
            this.draggingMode = 0;
            this.recSelectedTime = (Rectangle)this.recDragged.clone();
            this.refreshRects();
            this.convertPhysicalXYToLogical(this.recSelectedTime);
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        switch (this.draggingMode) {
            case 1: {
                this.doRectangleDragging(mouseEvent);
                break;
            }
            case 2: {
                this.doUpperSideDragging(mouseEvent);
                break;
            }
            case 3: {
                this.doLowerSideDragging(mouseEvent);
                break;
            }
            case 5: {
                this.doRightSideDragging(mouseEvent);
                break;
            }
            case 4: {
                this.doLeftSideDragging(mouseEvent);
            }
        }
        if (this.draggingMode != 0) {
            this.convertPhysicalXYToLogical(this.recDragged);
            this.repaint();
            this.scrollRectToVisible(new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1));
        }
    }

    protected void doRectangleDragging(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(12));
        int n = this.getSnappedRectanglePosition(mouseEvent.getX() - this.dx, this.colX);
        if (n < 0) {
            return;
        }
        if (n + this.recDragged.width > this.getWidth()) {
            return;
        }
        this.recDragged.x = n;
        int n2 = this.getSnappedRectanglePosition(mouseEvent.getY() - this.dy, this.rowY);
        if (n2 < 0) {
            return;
        }
        if (n2 + this.recDragged.height > this.getHeight()) {
            return;
        }
        this.recDragged.y = n2;
    }

    protected void doLowerSideDragging(MouseEvent mouseEvent) {
        int n = this.getSnappedRectanglePosition(mouseEvent.getY() - this.dy, this.rowY);
        this.recDragged.height = n - this.recDragged.y - 1;
        if (this.recDragged.height < 3) {
            this.recDragged.height = (int)this.rowHeight - 1;
        }
    }

    protected void doRightSideDragging(MouseEvent mouseEvent) {
        int n = this.getSnappedRectanglePosition(mouseEvent.getX() - this.dx, this.colX);
        this.recDragged.width = n - this.recDragged.x - 1;
        if (this.recDragged.width < 3) {
            this.recDragged.width = (int)this.columnWidth - 1;
        }
    }

    protected void doUpperSideDragging(MouseEvent mouseEvent) {
        int n = this.recDragged.y + this.recDragged.height;
        int n2 = this.getSnappedRectanglePosition(mouseEvent.getY() - this.dy, this.rowY);
        if ((float)(n - n2) > this.rowHeight - 1.0f) {
            this.recDragged.y = n2;
            this.recDragged.height = n - n2;
        }
    }

    protected void doLeftSideDragging(MouseEvent mouseEvent) {
        int n = this.recDragged.x + this.recDragged.width;
        int n2 = this.getSnappedRectanglePosition(mouseEvent.getX() - this.dx, this.colX);
        if ((float)(n - n2) >= this.columnWidth) {
            this.recDragged.x = n2;
            this.recDragged.width = n - n2;
        }
    }

    protected int getSnappedRectanglePosition(int n, ArrayList arrayList) {
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            n4 = Math.abs(n - (Integer)arrayList.get(i));
            if (n3 <= n4) continue;
            n3 = n4;
            n2 = (Integer)arrayList.get(i);
            this.selectedRow = i;
        }
        return n2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void doComponentResized() {
        float f = this.getWidth();
        this.columnWidth = f / (float)this.columnCount;
        float f2 = this.getHeight();
        this.rowHeight = f2 / (float)this.rowCount;
        this.calculateGrid();
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.doComponentResized();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }
}

