/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.busysearch.InfoPanelController;
import com.novell.gw.jclient.application.controls.busysearch.TimeBlockInfo;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class InfoPanel
extends OrientablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$busysearch$InfoPanel == null ? (class$com$novell$gw$jclient$application$controls$busysearch$InfoPanel = InfoPanel.class$("com.novell.gw.jclient.application.controls.busysearch.InfoPanel")) : class$com$novell$gw$jclient$application$controls$busysearch$InfoPanel));
    private InfoPanelController infoPanelController;
    private GregorianCalendar gcStartDate = GWCalendarUtils.getToday();
    private JLabel lbStartDate;
    private JLabel lbStartTime;
    private JLabel lbDuration;
    private JLabel lbAvailable;
    private StringBuffer durationText = new StringBuffer();
    private boolean isAvailable = true;
    private boolean isBusyShowing = false;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$busysearch$InfoPanel;

    public InfoPanel(MVCController mVCController) {
        super(new GridBagLayout());
        this.infoPanelController = new InfoPanelController(this, mVCController);
        this.buildUI();
        this.refreshView();
    }

    private void buildUI() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.lbStartDate = new OrientableLabel();
        this.lbStartTime = new OrientableLabel();
        this.lbDuration = new OrientableLabel();
        this.lbAvailable = new OrientableLabel(StringResources.AVAILABLE);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.add((Component)new OrientableLabel(StringResources.START_DATE_C), gridBagConstraints);
        this.add((Component)this.lbStartDate, gridBagConstraints);
        this.add((Component)new OrientableLabel(StringResources.START_TIME_C), gridBagConstraints);
        this.add((Component)this.lbStartTime, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)new OrientableLabel(StringResources.DURATION_C), gridBagConstraints);
        this.add((Component)this.lbDuration, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.lbAvailable, gridBagConstraints);
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StringResources.DESIRED_TIME);
        this.setBorder(BorderFactory.createCompoundBorder(border, titledBorder));
    }

    private void refreshView() {
        this.lbStartDate.setText(GWCalendarUtils.getDateFormat().format(this.gcStartDate.getTime()));
        this.lbStartTime.setText(GWCalendarUtils.getTimeFormat().format(this.gcStartDate.getTime()));
        this.lbDuration.setText(this.durationText.toString());
        if (this.isAvailable) {
            this.lbAvailable.setText(StringResources.AVAILABLE);
        } else if (this.isBusyShowing) {
            this.lbAvailable.setText(StringResources.BUSY);
        } else {
            this.lbAvailable.setText("");
        }
    }

    public void setBusyShowing(boolean bl) {
        this.isBusyShowing = bl;
    }

    public void setAvailableTimeInterval(TimeBlockInfo timeBlockInfo) {
        this.gcStartDate.setTime(timeBlockInfo.getTimeInterval().getStartDateAsDate());
        long l = (timeBlockInfo.getTimeInterval().getEndDate() - timeBlockInfo.getTimeInterval().getStartDate()) / 60000L;
        this.durationText.delete(0, this.durationText.length());
        if (l >= 60L && l < 120L) {
            this.durationText.append("1 " + StringResources.HOUR);
        } else if (l >= 120L) {
            this.durationText.append("" + l / 60L + " " + StringResources.HOURS);
        }
        if (l % 60L != 0L) {
            this.durationText.append(" " + l % 60L + " " + StringResources.MINUTES);
        }
        this.isAvailable = timeBlockInfo.getReason().equals("");
        this.refreshView();
    }

    public void setController(MVCController mVCController) {
        this.infoPanelController = (InfoPanelController)mVCController;
    }

    public MVCController getController() {
        return this.infoPanelController;
    }

    public void setMVCModel(Object object) {
        if (object instanceof TimeBlockInfo) {
            this.setAvailableTimeInterval((TimeBlockInfo)object);
        }
    }

    public Object getMVCModel() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

