/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.components.IntegerSpinner;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.DLSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.InviteToMeetingDialogController;
import com.novell.gw.jclient.application.controls.busysearch.RecipientActionsPopup;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateSelector;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class InviteToMeetingDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$busysearch$InviteToMeetingDialog == null ? (class$com$novell$gw$jclient$application$controls$busysearch$InviteToMeetingDialog = InviteToMeetingDialog.class$("com.novell.gw.jclient.application.controls.busysearch.InviteToMeetingDialog")) : class$com$novell$gw$jclient$application$controls$busysearch$InviteToMeetingDialog));
    private Dimension dialogSize = new Dimension(460, 325);
    private Border sideBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private SearchTextField tfTo = new SearchTextField();
    private SearchTextField tfCc = new SearchTextField();
    private SearchTextField tfBc = new SearchTextField();
    private DefaultListModel modelTo = new DefaultListModel();
    private DefaultListModel modelCc = new DefaultListModel();
    private DefaultListModel modelBc = new DefaultListModel();
    private DateSelector dsDate;
    private JSpinner spinnerDaysCount;
    private RecipientActionsPopup recipientActionsPopup;
    private boolean disableDefaultAction = false;
    private static final int DEFAULT_CHARACTERS_COUNT = 10;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$busysearch$InviteToMeetingDialog;

    public InviteToMeetingDialog(MVCView mVCView) {
        super((JFrame)((Object)mVCView), true);
        this.setController(new InviteToMeetingDialogController(this, mVCView.getController()));
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.BUSY_SEARCH);
        this.setModal(true);
        this.tfTo.addKeyListener(new RecipientInputKeyAdapter());
        this.tfCc.addKeyListener(new RecipientInputKeyAdapter());
        this.tfBc.addKeyListener(new RecipientInputKeyAdapter());
        this.tfTo.setListener(new SearchListener(this.modelTo));
        this.tfCc.setListener(new SearchListener(this.modelCc));
        this.tfBc.setListener(new SearchListener(this.modelBc));
        this.tfTo.addFocusListener(new RecipientsFocusListener());
        this.tfCc.addFocusListener(new RecipientsFocusListener());
        this.tfBc.addFocusListener(new RecipientsFocusListener());
        this.tfTo.setColumns(10);
        this.tfCc.setColumns(10);
        this.tfBc.setColumns(10);
        this.modelTo.addListDataListener(new RecipientListChangeAdapter());
        this.modelCc.addListDataListener(new RecipientListChangeAdapter());
        this.modelBc.addListDataListener(new RecipientListChangeAdapter());
        this.recipientActionsPopup = new RecipientActionsPopup();
        this.recipientActionsPopup.addPropertyChangeListener("action", new PopupPropertyChanged());
        this.buildCentralPanel();
        this.btnOK = new JButton(new BtnOkAction());
        this.setDefaultButton(this.btnOK);
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setBorder(this.sideBorder);
        JButton jButton = new JButton(StringResources.ADDRESS_BOOK_D);
        jButton.addActionListener(new BtnAddressBookAction());
        OS.addButtons(orientablePanel, this.btnOK, this.btnCancel, jButton);
        this.panBottomPanel.setLayout(new BorderLayout());
        this.panBottomPanel.add((Component)orientablePanel, "After");
        this.getContentPane().add((Component)this.panBottomPanel, "South");
    }

    private void buildCentralPanel() {
        this.panCenterPanel.add((Component)this.buildInvitePanel(), "Center");
        this.panCenterPanel.add((Component)this.buildSelectionPanel(), "South");
    }

    private JPanel buildInvitePanel() {
        int n;
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        orientablePanel.setBorder(BorderFactory.createTitledBorder(StringResources.INVITE_TO_MEETING));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 15;
        Insets insets = new Insets(0, n2, 0, 0);
        Insets insets2 = new Insets(0, n2, 0, n2);
        Insets insets3 = new Insets(0, 0, 0, n2);
        OrientableLabel orientableLabel = new OrientableLabel(StringResources.TO_C);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        orientablePanel.add((Component)orientableLabel, gridBagConstraints);
        orientableLabel = new OrientableLabel(StringResources.CARBON_COPY_C);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = insets2;
        orientablePanel.add((Component)orientableLabel, gridBagConstraints);
        orientableLabel = new OrientableLabel(StringResources.BLIND_COPY_C);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = insets3;
        orientablePanel.add((Component)orientableLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        insets.bottom = n = 10;
        insets2.bottom = n;
        insets3.bottom = n;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.tfTo, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = insets2;
        orientablePanel.add((Component)this.tfCc, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = insets3;
        orientablePanel.add((Component)this.tfBc, gridBagConstraints);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = insets;
        orientablePanel.add((Component)this.createRecipientsList(this.modelTo), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.weighty = 1.0;
        orientablePanel.add((Component)this.createRecipientsList(this.modelCc), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = insets3;
        gridBagConstraints.weighty = 1.0;
        orientablePanel.add((Component)this.createRecipientsList(this.modelBc), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        return orientablePanel;
    }

    private JComponent createRecipientsList(ListModel listModel) {
        OrientableList orientableList = new OrientableList(listModel);
        orientableList.addMouseListener(new ListMouseListener());
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(orientableList);
        int n = UIUtils.getColumnWidth(10, orientableList);
        orientableScrollPane.setPreferredSize(new Dimension(n, n));
        return orientableScrollPane;
    }

    private JPanel buildSelectionPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        orientablePanel.setBorder(this.sideBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 13;
        Insets insets = new Insets(0, n, 0, 0);
        Insets insets2 = new Insets(0, n, 0, n);
        OrientableLabel orientableLabel = new OrientableLabel(StringResources.START_SEARCH_DATE_C);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        orientablePanel.add((Component)orientableLabel, gridBagConstraints);
        orientableLabel = new OrientableLabel(StringResources.NUMBER_OF_DAYS_TO_SEARCH_C);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = insets2;
        orientablePanel.add((Component)orientableLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.dsDate = new DateSelector();
        this.dsDate.setIcon(ImageResources.ICON_ACT_VIEW_CALENDAR);
        orientablePanel.add((Component)this.dsDate, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.spinnerDaysCount = new IntegerSpinner(new SpinnerNumberModel(7, 1, 365, 1));
        this.spinnerDaysCount.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.spinnerDaysCount.setComponentOrientation(UIUtils.getComponentOrientation());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 10;
        orientablePanel.add((Component)this.spinnerDaysCount, gridBagConstraints);
        return orientablePanel;
    }

    public void setMVCModel(Object object) {
        if (object instanceof GWBusySearch) {
            GWBusySearch gWBusySearch = (GWBusySearch)object;
            this.setStartDate(gWBusySearch.getStartDate());
            this.fillListModel(gWBusySearch.getRecipientsList().getRecipientDescriptions(1), this.modelTo, true);
            this.fillListModel(gWBusySearch.getRecipientsList().getRecipientDescriptions(2), this.modelCc, true);
            this.fillListModel(gWBusySearch.getRecipientsList().getRecipientDescriptions(4), this.modelBc, true);
            this.spinnerDaysCount.setValue(new Integer(gWBusySearch.getDaysCount()));
            this.validate();
        } else if (object instanceof List) {
            List list = (List)object;
            this.fillListModel(list, this.modelTo, 1);
            this.fillListModel(list, this.modelCc, 2);
            this.fillListModel(list, this.modelBc, 4);
            this.validate();
        }
    }

    private void fillListModel(List list, DefaultListModel defaultListModel, boolean bl) {
        if (bl) {
            defaultListModel.clear();
        }
        for (int i = 0; i < list.size(); ++i) {
            defaultListModel.add(i, new ListLabel((RecipientDescription)list.get(i)));
        }
    }

    private void fillListModel(List list, DefaultListModel defaultListModel, int n) {
        defaultListModel.clear();
        for (int i = 0; i < list.size(); ++i) {
            Recipient recipient = (Recipient)list.get(i);
            if ((recipient.getCopyType() & n) != n) continue;
            defaultListModel.addElement(new ListLabel(recipient));
        }
    }

    public void setStartDate(Date date) {
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.setTime(date);
        this.dsDate.setDate(gregorianCalendar);
    }

    public Date getStartDate() {
        return this.dsDate.getDate().getTime();
    }

    public int getDaysCount() {
        return (Integer)this.spinnerDaysCount.getValue();
    }

    public RecipientDescriptionsList getRecepientDescriptinsList() {
        RecipientDescriptionsList recipientDescriptionsList = new RecipientDescriptionsList();
        recipientDescriptionsList.addAllRecipientDiscriptions(this.createRecipeintDescriptionsList(this.modelTo, 1));
        recipientDescriptionsList.addAllRecipientDiscriptions(this.createRecipeintDescriptionsList(this.modelCc, 2));
        recipientDescriptionsList.addAllRecipientDiscriptions(this.createRecipeintDescriptionsList(this.modelBc, 4));
        return recipientDescriptionsList;
    }

    private ArrayList createRecipeintDescriptionsList(DefaultListModel defaultListModel, int n) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            ListLabel listLabel = (ListLabel)defaultListModel.elementAt(i);
            RecipientDescription recipientDescription = listLabel.getRecipientDescription();
            Addressable addressable = recipientDescription.getRecipient().getAddressable();
            RecipientDescriptionsList.addRecipientDescriptionToList(arrayList, addressable, n, recipientDescription.getState(), recipientDescription.isSelected());
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SearchListener
    implements SearchResultListener {
        private DefaultListModel listModel;

        public SearchListener(DefaultListModel defaultListModel) {
            this.listModel = defaultListModel;
        }

        private boolean isRecpientExistInModel(Recipient recipient, DefaultListModel defaultListModel) {
            boolean bl = false;
            ArrayList arrayList = InviteToMeetingDialog.this.createRecipeintDescriptionsList(defaultListModel, recipient.getCopyType());
            for (int i = 0; i < arrayList.size(); ++i) {
                RecipientDescription recipientDescription = (RecipientDescription)arrayList.get(i);
                if (!BusySearchFrame.getRecipientID(recipientDescription.getRecipient()).equals(BusySearchFrame.getRecipientID(recipient))) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public void searchFinished(SearchEvent searchEvent) {
            Addressable addressable = searchEvent.getFoundContact();
            if (addressable != null) {
                int n = 1;
                if (this.listModel.equals(InviteToMeetingDialog.this.modelCc)) {
                    n = 2;
                } else if (this.listModel.equals(InviteToMeetingDialog.this.modelBc)) {
                    n = 4;
                }
                Recipient recipient = new Recipient(addressable, n);
                if (this.isRecpientExistInModel(recipient, this.listModel)) {
                    logger.debug((Object)("recipient - " + recipient.getAddressable().getDisplayName() + " exists in the list"));
                    return;
                }
                ListLabel listLabel = new ListLabel(new RecipientDescription(recipient));
                this.listModel.add(this.listModel.size(), listLabel);
            }
        }
    }

    private class PopupPropertyChanged
    implements PropertyChangeListener {
        private JList focusedList;

        private PopupPropertyChanged() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!(InviteToMeetingDialog.this.recipientActionsPopup.getFocusedComponent() instanceof JList) || !(propertyChangeEvent.getNewValue() instanceof Integer)) {
                return;
            }
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.focusedList = (JList)InviteToMeetingDialog.this.recipientActionsPopup.getFocusedComponent();
            if (n == RecipientActionsPopup.EDIT) {
                this.doEdit();
            } else if (n == RecipientActionsPopup.CUT) {
                this.doCopy();
                this.doDelete();
            } else if (n == RecipientActionsPopup.COPY) {
                this.doCopy();
            } else if (n == RecipientActionsPopup.DELETE) {
                this.doDelete();
                InviteToMeetingDialog.this.recipientActionsPopup.setBuffer(null);
            } else if (n == RecipientActionsPopup.PASTE) {
                this.doPaste();
            } else if (n == RecipientActionsPopup.SELECT_ALL) {
                this.doSelectAll();
            }
        }

        private void doEdit() {
            OrientableTextField orientableTextField = new OrientableTextField();
            if (this.focusedList.getModel().equals(InviteToMeetingDialog.this.modelTo)) {
                orientableTextField = InviteToMeetingDialog.this.tfTo;
            } else if (this.focusedList.getModel().equals(InviteToMeetingDialog.this.modelCc)) {
                orientableTextField = InviteToMeetingDialog.this.tfCc;
            } else if (this.focusedList.getModel().equals(InviteToMeetingDialog.this.modelBc)) {
                orientableTextField = InviteToMeetingDialog.this.tfBc;
            }
            if (this.focusedList.getSelectedValues().length > 0) {
                RecipientDescription recipientDescription = ((ListLabel)this.focusedList.getSelectedValue()).getRecipientDescription();
                ((JTextComponent)orientableTextField).setText(recipientDescription.getRecipient().getAddressable().getDisplayName());
                ((DefaultListModel)this.focusedList.getModel()).removeElement(this.focusedList.getSelectedValue());
            }
        }

        private void doCopy() {
            ArrayList<RecipientDescription> arrayList = new ArrayList<RecipientDescription>();
            for (int i = 0; i < this.focusedList.getSelectedValues().length; ++i) {
                arrayList.add(((ListLabel)this.focusedList.getSelectedValues()[i]).getRecipientDescription());
            }
            InviteToMeetingDialog.this.recipientActionsPopup.setBuffer(arrayList);
        }

        private void doDelete() {
            for (int i = this.focusedList.getSelectedValues().length - 1; i > -1; --i) {
                ((DefaultListModel)this.focusedList.getModel()).removeElement(this.focusedList.getSelectedValues()[i]);
            }
        }

        private void doPaste() {
            ArrayList arrayList = InviteToMeetingDialog.this.recipientActionsPopup.getBuffer();
            for (int i = 0; i < this.focusedList.getModel().getSize(); ++i) {
                RecipientDescription recipientDescription = ((ListLabel)this.focusedList.getModel().getElementAt(i)).getRecipientDescription();
                for (int j = arrayList.size() - 1; j > -1; --j) {
                    if (!recipientDescription.isSameRecipient((RecipientDescription)arrayList.get(j))) continue;
                    arrayList.remove(j);
                }
            }
            InviteToMeetingDialog.this.fillListModel(arrayList, (DefaultListModel)this.focusedList.getModel(), false);
        }

        private void doSelectAll() {
            int[] nArray = new int[this.focusedList.getModel().getSize()];
            for (int i = 0; i < this.focusedList.getModel().getSize(); ++i) {
                nArray[i] = i;
            }
            this.focusedList.setSelectedIndices(nArray);
        }
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() instanceof JList) {
                JList jList = (JList)mouseEvent.getSource();
                InviteToMeetingDialog.this.recipientActionsPopup.setFocusedComponent(jList);
                InviteToMeetingDialog.this.recipientActionsPopup.show(jList, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class RecipientListChangeAdapter
    implements ListDataListener {
        private RecipientListChangeAdapter() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.doListChange();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.doListChange();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.doListChange();
        }

        private void doListChange() {
            if (InviteToMeetingDialog.this.modelTo.getSize() > 0 || InviteToMeetingDialog.this.modelCc.getSize() > 0 || InviteToMeetingDialog.this.modelBc.getSize() > 0) {
                InviteToMeetingDialog.this.btnOK.setEnabled(true);
            } else {
                InviteToMeetingDialog.this.btnOK.setEnabled(false);
            }
        }
    }

    private class RecipientsFocusListener
    extends FocusAdapter {
        private RecipientsFocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            SearchTextField searchTextField = (SearchTextField)focusEvent.getSource();
            searchTextField.updateListener();
            searchTextField.setText("");
        }
    }

    private class RecipientInputKeyAdapter
    extends KeyAdapter {
        private RecipientInputKeyAdapter() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            InviteToMeetingDialog inviteToMeetingDialog = InviteToMeetingDialog.this;
            if (keyEvent.getKeyChar() == '\n') {
                SearchTextField searchTextField = (SearchTextField)keyEvent.getSource();
                if (inviteToMeetingDialog.btnOK.isEnabled() && searchTextField.getText().equals("")) {
                    inviteToMeetingDialog.disableDefaultAction = false;
                    inviteToMeetingDialog.btnOK.getAction().actionPerformed(null);
                } else {
                    searchTextField.updateListener();
                    searchTextField.setText("");
                    inviteToMeetingDialog.disableDefaultAction = true;
                }
            }
        }
    }

    private class BtnAddressBookAction
    extends AbstractAction {
        private BtnAddressBookAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList arrayList = new ArrayList();
            this.fillRecipientListFromDescriptionsList(InviteToMeetingDialog.this.createRecipeintDescriptionsList(InviteToMeetingDialog.this.modelTo, 1), arrayList);
            this.fillRecipientListFromDescriptionsList(InviteToMeetingDialog.this.createRecipeintDescriptionsList(InviteToMeetingDialog.this.modelCc, 2), arrayList);
            this.fillRecipientListFromDescriptionsList(InviteToMeetingDialog.this.createRecipeintDescriptionsList(InviteToMeetingDialog.this.modelBc, 4), arrayList);
            DLSelectorDialog dLSelectorDialog = new DLSelectorDialog(InviteToMeetingDialog.this, arrayList, InviteToMeetingDialog.this.getController());
            dLSelectorDialog.showMe();
        }

        private void fillRecipientListFromDescriptionsList(ArrayList arrayList, ArrayList arrayList2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(((RecipientDescription)arrayList.get(i)).getRecipient());
            }
        }
    }

    private class BtnOkAction
    extends AbstractAction {
        public BtnOkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InviteToMeetingDialog inviteToMeetingDialog = InviteToMeetingDialog.this;
            if (!inviteToMeetingDialog.disableDefaultAction || !inviteToMeetingDialog.tfTo.isFocusOwner() && !inviteToMeetingDialog.tfCc.isFocusOwner() && !inviteToMeetingDialog.tfBc.isFocusOwner()) {
                try {
                    String string = ControlsUtils.getUserGuid(InviteToMeetingDialog.this.controller);
                    if (GWCommandManager.getInstance(string).composeBusySearch(InviteToMeetingDialog.this.getRecepientDescriptinsList(), new Date(), 1, new TimeInterval(new Date(), new Date())) == null) {
                        JOptionPane.showMessageDialog(null, StringResources.BYSY_SEARCH_NO_VALID_USERS);
                        InviteToMeetingDialog.this.setActionCompleteSuccessfully(false);
                    } else {
                        InviteToMeetingDialog.this.setActionCompleteSuccessfully(true);
                        GWDialog.disposeDialog(InviteToMeetingDialog.this);
                    }
                }
                catch (GWCommandException gWCommandException) {
                    gWCommandException.printStackTrace();
                }
            }
        }
    }

    static class ListLabel
    extends OrientableLabel {
        private RecipientDescription recipientDescription = new RecipientDescription();

        public ListLabel(Recipient recipient) {
            this.recipientDescription = new RecipientDescription(recipient);
        }

        public ListLabel(RecipientDescription recipientDescription) {
            this.recipientDescription = recipientDescription;
        }

        public RecipientDescription getRecipientDescription() {
            return this.recipientDescription;
        }

        public String toString() {
            return this.recipientDescription.getRecipient().getAddressable().getDisplayName();
        }
    }
}

