/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.novell.gw.ab.Address;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.ab.GroupContact;
import com.novell.gw.ab.Recipient;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class RecipientDescriptionsList {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$busysearch$RecipientDescriptionsList == null ? (class$com$novell$gw$jclient$application$controls$busysearch$RecipientDescriptionsList = RecipientDescriptionsList.class$("com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList")) : class$com$novell$gw$jclient$application$controls$busysearch$RecipientDescriptionsList));
    private List recipientDescriptions = new ArrayList();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$busysearch$RecipientDescriptionsList;

    public RecipientDescriptionsList() {
    }

    public int size() {
        return this.recipientDescriptions.size();
    }

    public RecipientDescriptionsList(List list) {
        this.recipientDescriptions.clear();
        if (list.size() == 0) {
            return;
        }
        if (list.get(0) instanceof RecipientDescription) {
            this.recipientDescriptions.addAll(list);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                Recipient recipient = (Recipient)list.get(i);
                Addressable addressable = recipient.getAddressable();
                RecipientDescriptionsList.addRecipientDescriptionToList(this.recipientDescriptions, addressable, recipient.getCopyType(), 0, true);
            }
        }
    }

    public void clear() {
        this.recipientDescriptions.clear();
    }

    public void addAllRecipientDiscriptions(List list) {
        this.recipientDescriptions.addAll(list);
    }

    public List getRecipientDescriptions(int n) {
        ArrayList<RecipientDescription> arrayList = new ArrayList<RecipientDescription>();
        for (int i = 0; i < this.recipientDescriptions.size(); ++i) {
            RecipientDescription recipientDescription = (RecipientDescription)this.recipientDescriptions.get(i);
            if ((recipientDescription.getRecipient().getCopyType() & n) != n || recipientDescription.getRecipient().isUnresolved()) continue;
            arrayList.add(recipientDescription);
        }
        return arrayList;
    }

    public int getFailedSize() {
        int n = 0;
        for (int i = 0; i < this.recipientDescriptions.size(); ++i) {
            RecipientDescription recipientDescription = (RecipientDescription)this.recipientDescriptions.get(i);
            if (!recipientDescription.isFailed()) continue;
            ++n;
        }
        return n;
    }

    public List getResolvedList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.recipientDescriptions.size(); ++i) {
            if (((RecipientDescription)this.recipientDescriptions.get(i)).getRecipient().isUnresolved()) continue;
            arrayList.add(this.recipientDescriptions.get(i));
        }
        return arrayList;
    }

    public void setNewRecipientDescription(RecipientDescription recipientDescription) {
        for (int i = 0; i < this.recipientDescriptions.size(); ++i) {
            RecipientDescription recipientDescription2 = (RecipientDescription)this.recipientDescriptions.get(i);
            if (!BusySearchFrame.getRecipientID(recipientDescription2.getRecipient()).equals(BusySearchFrame.getRecipientID(recipientDescription.getRecipient()))) continue;
            this.recipientDescriptions.set(i, recipientDescription);
        }
    }

    public DistributionList getDistributionList() {
        DistributionList distributionList = new DistributionList();
        for (int i = 0; i < this.recipientDescriptions.size(); ++i) {
            RecipientDescription recipientDescription = (RecipientDescription)this.recipientDescriptions.get(i);
            distributionList.addRecipient(recipientDescription.getRecipient());
        }
        return distributionList;
    }

    public List getSelectedRecipients(int n) {
        ArrayList<Recipient> arrayList = new ArrayList<Recipient>();
        for (int i = 0; i < this.recipientDescriptions.size(); ++i) {
            RecipientDescription recipientDescription = (RecipientDescription)this.recipientDescriptions.get(i);
            if (!recipientDescription.isSelected() || (recipientDescription.getRecipient().getCopyType() & n) != n && n != -1 || recipientDescription.getRecipient().isUnresolved()) continue;
            arrayList.add(recipientDescription.getRecipient());
        }
        return arrayList;
    }

    public static void addRecipientDescriptionToList(List list, Addressable addressable, int n, int n2, boolean bl) {
        Object object;
        RecipientDescription recipientDescription = null;
        if (addressable instanceof Address && (addressable.getAddressableType() == 7 || addressable.getAddressableType() == 2)) {
            try {
                object = ControlsUtils.itemListToList(EngineCommandManager.getAddressBookManager().findContactsByName(addressable.getDisplayName()));
                addressable = (Contact)object.get(0);
            }
            catch (EngineException engineException) {
                logger.error((Object)engineException);
            }
        }
        if (addressable instanceof GroupContact) {
            object = (GroupContact)addressable;
            try {
                Enumeration enumeration = object.getMembers().getEnumeration();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!(e instanceof Contact)) continue;
                    recipientDescription = new RecipientDescription(new Recipient((Addressable)((Contact)e), n), n2, bl);
                    list.add(recipientDescription);
                }
            }
            catch (EngineException engineException) {
                logger.error((Object)engineException, (Throwable)engineException);
            }
        } else {
            recipientDescription = new RecipientDescription(new Recipient(addressable, n), n2, bl);
            list.add(recipientDescription);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

