/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.controls.busysearch.RecipientTreeController;
import com.novell.gw.jclient.application.controls.folderstree.TextTreeRenderer;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class RecipientTree
extends JTree
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$busysearch$RecipientTree == null ? (class$com$novell$gw$jclient$application$controls$busysearch$RecipientTree = RecipientTree.class$("com.novell.gw.jclient.application.controls.busysearch.RecipientTree")) : class$com$novell$gw$jclient$application$controls$busysearch$RecipientTree));
    private RecipientTreeController recipientTreeController;
    private RecipientDescriptionsList recipientList = new RecipientDescriptionsList();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$busysearch$RecipientTree;

    public RecipientTree(RecipientDescriptionsList recipientDescriptionsList, MVCController mVCController) {
        this(mVCController);
        this.recipientList = recipientDescriptionsList;
        this.refreshView();
    }

    public RecipientTree(MVCController mVCController) {
        this.recipientTreeController = new RecipientTreeController(this, mVCController);
        this.setModel(new RecipientsTreeModel());
        this.setCellRenderer(new RecipientsTreeRenderrer());
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.addMouseListener(new NodeCheckListener());
        this.setRootVisible(false);
        this.setMinimumSize(new Dimension(180, 270));
        this.setRowHeight(-1);
    }

    private void refreshView() {
        ((DefaultMutableTreeNode)this.getModel().getRoot()).removeAllChildren();
        ((RecipientsTreeModel)this.getModel()).setTo(this.recipientList.getRecipientDescriptions(1));
        ((RecipientsTreeModel)this.getModel()).setCC(this.recipientList.getRecipientDescriptions(2));
        ((RecipientsTreeModel)this.getModel()).setBC(this.recipientList.getRecipientDescriptions(4));
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        for (int i = defaultMutableTreeNode.getChildCount() - 1; i > -1; --i) {
            this.expandRow(i);
        }
        this.validate();
    }

    public void setController(MVCController mVCController) {
        this.recipientTreeController = (RecipientTreeController)mVCController;
    }

    public MVCController getController() {
        return this.recipientTreeController;
    }

    public void setMVCModel(Object object) {
        if (object instanceof RecipientDescriptionsList) {
            this.recipientList = (RecipientDescriptionsList)object;
            this.refreshView();
        }
    }

    public Object getMVCModel() {
        return null;
    }

    private void doSelectionChanged() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            for (int j = 0; j < defaultMutableTreeNode2.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(j);
                if (!(defaultMutableTreeNode3 instanceof RecipientNode)) continue;
                RecipientNode recipientNode = (RecipientNode)defaultMutableTreeNode3;
                RecipientDescription recipientDescription = (RecipientDescription)recipientNode.getUserObject();
                recipientDescription.setSelected(recipientNode.isSelected());
                this.recipientList.setNewRecipientDescription(recipientDescription);
            }
        }
        Command command = new Command(690, this.recipientList);
        this.getController().processCommand(command);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NodeCheckListener
    extends MouseAdapter {
        private NodeCheckListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TreeNode treeNode;
            Object object;
            int n;
            int n2 = mouseEvent.getX();
            TreePath treePath = RecipientTree.this.getPathForLocation(n2, n = mouseEvent.getY());
            Rectangle rectangle = RecipientTree.this.getPathBounds(treePath);
            if (rectangle == null || treePath == null) {
                return;
            }
            boolean bl = false;
            if (UIUtils.getComponentOrientation().isLeftToRight()) {
                bl = n2 - rectangle.x < 16;
            } else {
                boolean bl2 = bl = Math.abs(n2 - (rectangle.x + rectangle.width - 8)) <= 8;
            }
            if (bl && (object = treePath.getLastPathComponent()) instanceof SelectionNode && ((treeNode = ((SelectionNode)object).getParent()) instanceof ListNode && ((ListNode)treeNode).isSelected() || object instanceof ListNode)) {
                SelectionNode selectionNode;
                selectionNode.setSelected(!(selectionNode = (SelectionNode)object).isSelected());
                ((RecipientsTreeModel)RecipientTree.this.getModel()).reload(selectionNode);
                RecipientTree.this.doSelectionChanged();
            }
        }
    }

    private class TreeLabel
    extends OrientableLabel {
        private boolean isSelected;
        private boolean hasFocus;

        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        public void paint(Graphics graphics) {
            String string = this.getText();
            if (string != null && 0 < string.length()) {
                if (this.isSelected) {
                    graphics.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    graphics.setColor(UIManager.getColor("Tree.textBackground"));
                }
                Dimension dimension = this.getPreferredSize();
                int n = 0;
                Icon icon = this.getIcon();
                if (icon != null) {
                    n = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                if (this.getComponentOrientation().isLeftToRight()) {
                    graphics.fillRect(n, 0, dimension.width - 1 - n, dimension.height);
                } else {
                    graphics.fillRect(0, 0, dimension.width - 1 - n, dimension.height);
                }
                if (this.hasFocus) {
                    if (this.getComponentOrientation().isLeftToRight()) {
                        graphics.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                        graphics.drawRect(n, 0, dimension.width - 1 - n, dimension.height - 1);
                    } else {
                        graphics.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                        graphics.drawRect(0, 0, dimension.width - 1 - n, dimension.height - 1);
                    }
                }
            }
            super.paint(graphics);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension != null) {
                dimension = new Dimension(dimension.width + 3, dimension.height);
            }
            return dimension;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setFocus(boolean bl) {
            this.hasFocus = bl;
        }
    }

    private class SelectionNode
    extends DefaultMutableTreeNode {
        protected boolean isSelected = true;

        public SelectionNode(Object object) {
            super(object);
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }
    }

    private class ListNode
    extends SelectionNode {
        public ListNode(String string) {
            super(string);
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (!this.isLeaf()) {
                for (int i = 0; i < this.children.size(); ++i) {
                    ((RecipientNode)this.children.elementAt(i)).setSelected(bl);
                }
            }
        }

        public void add(MutableTreeNode mutableTreeNode) {
            if (!(mutableTreeNode instanceof RecipientNode)) {
                throw new IllegalArgumentException();
            }
            super.add(mutableTreeNode);
        }
    }

    private class RecipientNode
    extends SelectionNode {
        private int state = 1;

        public RecipientNode(RecipientDescription recipientDescription) {
            super(recipientDescription);
            this.state = recipientDescription.getState();
        }

        public String toString() {
            Object object = this.getUserObject();
            if (object instanceof RecipientDescription && ((RecipientDescription)object).getRecipient() != null) {
                return ((RecipientDescription)object).getRecipient().getAddressable().getDisplayName();
            }
            return "";
        }

        public int getState() {
            return this.state;
        }
    }

    private class RecipientsTreeRenderrer
    extends OrientablePanel
    implements TreeCellRenderer,
    TextTreeRenderer {
        private int size;
        private JCheckBox check = new OrientableCheckBox();
        private TreeLabel lbText = new TreeLabel();
        private ImageIcon imgBusy;
        private ImageIcon imgOutOfOffice;
        private ImageIcon imgTentative;
        private ImageIcon imgAvailable;

        public RecipientsTreeRenderrer() {
            this.setLayout(new FlowLayout(3, 0, 0));
            this.setBackground(Color.WHITE);
            this.add(this.check);
            this.add(this.lbText);
            this.check.setBackground(UIManager.getColor("Tree.textBackground"));
            this.check.setPreferredSize(new Dimension(this.check.getPreferredSize().width, UIUtils.TREE_ROW_HEIGHT));
            this.lbText.setForeground(UIManager.getColor("Tree.textForeground"));
            this.imgBusy = new ImageIcon(this.getSquareRectangleAsImage(BusySearchFrame.COLOR_BUSY));
            this.imgOutOfOffice = new ImageIcon(this.getSquareRectangleAsImage(BusySearchFrame.COLOR_OUT_OF_OFFICE));
            this.imgTentative = new ImageIcon(this.getSquareRectangleAsImage(BusySearchFrame.COLOR_TENTATIVE));
            this.imgAvailable = new ImageIcon(this.getSquareRectangleAsImage(BusySearchFrame.COLOR_AVAILABLE));
        }

        private Image getSquareRectangleAsImage(Color color) {
            this.size = 12;
            BufferedImage bufferedImage = new BufferedImage(this.size, this.size, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, this.size, this.size);
            if (!color.equals(BusySearchFrame.COLOR_AVAILABLE)) {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(0, 0, this.size - 1, this.size - 1);
            }
            return bufferedImage;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            if (object instanceof SelectionNode) {
                this.check.setSelected(((SelectionNode)object).isSelected());
            }
            if (object instanceof RecipientNode) {
                TreeNode treeNode = ((RecipientNode)object).getParent();
                if (treeNode instanceof ListNode) {
                    boolean bl5 = ((ListNode)treeNode).isSelected();
                    this.lbText.setSelected(bl5 && bl);
                }
                this.lbText.setFont(jTree.getFont());
                switch (((RecipientNode)object).getState()) {
                    case 1: {
                        this.lbText.setIcon(this.imgTentative);
                        break;
                    }
                    case 0: {
                        this.lbText.setIcon(this.imgAvailable);
                        break;
                    }
                    case 3: {
                        this.lbText.setIcon(this.imgOutOfOffice);
                        break;
                    }
                    case 4: {
                        this.lbText.setIcon(this.imgOutOfOffice);
                        break;
                    }
                    case 2: {
                        this.lbText.setIcon(this.imgBusy);
                        break;
                    }
                    default: {
                        this.lbText.setIcon(this.imgAvailable);
                        break;
                    }
                }
            } else if (object instanceof ListNode) {
                this.lbText.setFont(Utils.deriveFont(jTree.getFont(), 1));
                this.lbText.setSelected(bl);
                this.setEnabled(true);
                this.lbText.setEnabled(true);
                if (bl2) {
                    this.lbText.setIcon(ImageResources.ICON_FOLDER_OPENED);
                } else {
                    this.lbText.setIcon(ImageResources.ICON_FOLDER_CLOSED);
                }
            }
            this.lbText.setText(string);
            this.lbText.setFocus(bl4);
            return this;
        }

        public int getTextX() {
            return 0;
        }
    }

    private class RecipientsTreeModel
    extends DefaultTreeModel {
        private DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        private ListNode toNode = new ListNode(StringResources.TO);
        private ListNode ccNode = new ListNode(StringResources.CC);
        private ListNode bcNode = new ListNode(StringResources.BC);

        public RecipientsTreeModel() {
            super(null);
            this.setRoot(this.root);
        }

        private void setListNode(ListNode listNode, List list) {
            if (listNode == null || list.size() == 0) {
                return;
            }
            listNode.removeAllChildren();
            listNode.setSelected(true);
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!(e instanceof RecipientDescription)) continue;
                RecipientDescription recipientDescription = (RecipientDescription)e;
                RecipientNode recipientNode = new RecipientNode(recipientDescription);
                recipientNode.setSelected(recipientDescription.isSelected());
                listNode.add(recipientNode);
            }
            this.root.add(listNode);
            this.reload(this.root);
        }

        public Object getRoot() {
            return this.root;
        }

        public void setTo(List list) {
            this.setListNode(this.toNode, list);
        }

        public void setCC(List list) {
            this.setListNode(this.ccNode, list);
        }

        public void setBC(List list) {
            this.setListNode(this.bcNode, list);
        }
    }
}

