/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filechoser;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.filechoser.GWFileFilter;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class GWFileChooser
extends JDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$filechoser$GWFileChooser == null ? (class$com$novell$gw$jclient$application$controls$filechoser$GWFileChooser = GWFileChooser.class$("com.novell.gw.jclient.application.controls.filechoser.GWFileChooser")) : class$com$novell$gw$jclient$application$controls$filechoser$GWFileChooser));
    private JFileChooser chooser = new JFileChooser();
    private BorderLayout borderlayout = new BorderLayout();
    private String[] selectedPaths = null;
    private String fileName = " ";
    private JTextComponent tfFileName;
    private boolean canceled = false;
    private File suggestedFile;
    public final int DIALOG_HEIGHT = 500;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$filechoser$GWFileChooser;

    public GWFileChooser(Frame frame, String string, File file, int n, int n2, boolean bl) {
        this(frame, string, file, null, n, n2, bl);
    }

    public GWFileChooser(Frame frame, String string, File file, File file2, int n, int n2, boolean bl) {
        super(frame, string, true);
        this.init(n2, file, n, bl, file2);
    }

    public GWFileChooser(Dialog dialog, String string, File file, int n, int n2, boolean bl) {
        this(dialog, string, file, null, n, n2, bl);
    }

    public GWFileChooser(Dialog dialog, String string, File file, File file2, int n, int n2, boolean bl) {
        super(dialog, string, true);
        this.init(n2, file, n, bl, file2);
    }

    private void init(int n, File file, int n2, boolean bl, File file2) {
        this.chooser.setDialogType(n);
        this.chooser.setCurrentDirectory(file);
        this.chooser.setFileSelectionMode(n2);
        this.chooser.setMultiSelectionEnabled(bl);
        this.suggestedFile = file2;
        boolean bl2 = ApplicationOptions.getInstance().getBoolean("SHOW_HIDDEN_FILES");
        this.chooser.setFileHidingEnabled(!bl2);
        if (file2 != null) {
            this.fileName = file2.getPath();
            this.chooser.setSelectedFile(file2);
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            logger.debug((Object)"Error during creating ChooserDialog object");
            logger.error((Object)exception, (Throwable)exception);
        }
        ((JComponent)this.getContentPane()).setPreferredSize(new Dimension(500, 500));
        this.pack();
    }

    public JFileChooser getChooser() {
        return this.chooser;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.chooser.setFileFilter(fileFilter);
    }

    public FileFilter getAcceptAllFileFilter() {
        return this.chooser.getAcceptAllFileFilter();
    }

    public void setAcceptAllFileFilter(boolean bl) {
        this.chooser.setAcceptAllFileFilterUsed(bl);
    }

    public void removeChoosableFileFilter(FileFilter fileFilter) {
        this.chooser.removeChoosableFileFilter(fileFilter);
    }

    public void addChoosableFileFilter(FileFilter fileFilter) {
        this.chooser.addChoosableFileFilter(fileFilter);
    }

    private void jbInit() {
        UIUtils.centerWindowOnScreen(this);
        this.getContentPane().setLayout(this.borderlayout);
        if (this.getParent() != null) {
            this.chooser.setLocale(this.getParent().getLocale());
        }
        if (!OS.isMacOS()) {
            this.chooser.setApproveButtonMnemonic(5);
        }
        this.getContentPane().add((Component)this.chooser, "Center");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JFileChooser) {
                    String string = actionEvent.getActionCommand();
                    GWFileChooser.this.chooser;
                    if (string.equalsIgnoreCase("ApproveSelection")) {
                        GWFileChooser.this.onSelect();
                    } else {
                        GWFileChooser.this.onCancel();
                    }
                }
            }
        };
        this.chooser.addActionListener(actionListener);
        if (OS.isMacOS()) {
            this.lookingForFileNameField();
            if (this.fileName != null) {
                this.tfFileName.setText(this.fileName);
            }
        }
    }

    void onSelect() {
        if (this.chooser.isMultiSelectionEnabled()) {
            File[] fileArray = this.chooser.getSelectedFiles();
            this.selectedPaths = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                this.selectedPaths[i] = file.getAbsolutePath();
            }
        } else {
            File file = this.chooser.getSelectedFile();
            String string = file.getParentFile().getAbsolutePath();
            String string2 = file.getName();
            if (this.suggestedFile != null) {
                string2 = Utils.validateExtention(string2, this.suggestedFile.getName());
            }
            String string3 = string + Utils.FILE_SEPARATOR + string2;
            this.selectedPaths = new String[]{string3};
        }
        this.setVisible(false);
    }

    void onCancel() {
        this.canceled = true;
        this.selectedPaths = null;
        this.setVisible(false);
    }

    public String[] getResult() {
        if (this.selectedPaths != null) {
            for (int i = 0; i < this.selectedPaths.length; ++i) {
                FileFilter fileFilter;
                String string = this.selectedPaths[i];
                String string2 = Utils.getExtention(string);
                if (string2 == null) {
                    string2 = "";
                }
                if (!string2.equals("") && !string2.equals(string) || !((fileFilter = this.chooser.getFileFilter()) instanceof GWFileFilter)) continue;
                GWFileFilter gWFileFilter = (GWFileFilter)fileFilter;
                this.selectedPaths[i] = string + gWFileFilter.getExtension();
            }
        }
        return this.selectedPaths;
    }

    public void setSelectedFile(File file) {
        this.chooser.setSelectedFile(file);
    }

    private void lookingForFileNameField() {
        for (int i = 0; i < this.chooser.getComponentCount(); ++i) {
            JComponent jComponent = (JComponent)this.chooser.getComponent(i);
            this.tfFileName = this.findFileNameField(jComponent);
            if (this.tfFileName != null) break;
        }
    }

    JTextField findFileNameField(JComponent jComponent) {
        JTextField jTextField = null;
        int n = jComponent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(i);
            if (jComponent2 instanceof JTextField) {
                return (JTextField)jComponent2;
            }
            if (this.findFileNameField(jComponent2) == null) continue;
            return this.findFileNameField(jComponent2);
        }
        return jTextField;
    }

    JFileChooser getFileChooser() {
        return this.chooser;
    }

    public void setCurrentDirectory(File file) {
        this.chooser.setCurrentDirectory(file);
        this.chooser.updateUI();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

