/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.resources.GWIcons;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.folderstree.TextTreeRenderer;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.apache.log4j.Logger;

public class GWFoldersTreeRendererColor
extends OrientablePanel
implements TreeCellRenderer,
TextTreeRenderer {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$folderstree$GWFoldersTreeRendererColor == null ? (class$com$novell$gw$jclient$application$controls$folderstree$GWFoldersTreeRendererColor = GWFoldersTreeRendererColor.class$("com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeRendererColor")) : class$com$novell$gw$jclient$application$controls$folderstree$GWFoldersTreeRendererColor));
    private boolean treeHasFocus = false;
    private boolean selected;
    protected boolean selectDragedFolder;
    protected boolean selectPopupFolder;
    private JLabel lbName;
    private JLabel lbCount;
    private JLabel lbUnOpenedItems;
    private Color activeSelectionBackground = UIManager.getColor("Tree.selectionBackground");
    private Color inactiveSelectionBackground;
    private static final Color DEFAULT_BACKGROUND = Color.WHITE;
    private static final Color DEFAULT_FOREGROUND = Color.BLACK;
    private static final Color COMMON_COUNT_COLOR = new Color(0, 178, 180);
    private static final Color TRASH_COUNT_COLOR = new Color(180, 0, 0);
    public static final Color BOX_COLOR = new Color(8, 36, 106);
    private boolean isCachingMode = false;
    private static boolean isGTKLAF = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$folderstree$GWFoldersTreeRendererColor;

    public GWFoldersTreeRendererColor() {
        this.lbName = new SelectionLabel();
        this.lbCount = new JLabel();
        this.lbUnOpenedItems = new JLabel();
        this.lbName.setBorder(BorderFactory.createEmptyBorder());
        this.lbCount.setBorder(BorderFactory.createEmptyBorder());
        if (isGTKLAF) {
            this.lbCount.setOpaque(true);
            this.lbUnOpenedItems.setOpaque(true);
        }
        this.lbUnOpenedItems.setBorder(BorderFactory.createEmptyBorder());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.add((Component)this.lbUnOpenedItems, gridBagConstraints);
            this.add((Component)this.lbName, gridBagConstraints);
            this.add((Component)this.lbCount, gridBagConstraints);
        } else {
            this.add((Component)this.lbCount, gridBagConstraints);
            this.add((Component)this.lbName, gridBagConstraints);
            this.add((Component)this.lbUnOpenedItems, gridBagConstraints);
        }
        this.inactiveSelectionBackground = UIManager.getColor("Tree.textBackground");
        this.isCachingMode = EngineCommandManager.getCurrentMode() == 6;
    }

    public void setNodeIcon(ImageIcon imageIcon) {
        this.lbName.setIcon(imageIcon);
    }

    public int getTextX() {
        return 36;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2;
        this.setForeground(DEFAULT_FOREGROUND);
        this.setBackground(DEFAULT_BACKGROUND);
        Object object3 = ((DefaultMutableTreeNode)object).getUserObject();
        if (object3 instanceof AbstractFolder) {
            Object object4;
            object2 = (AbstractFolder)object3;
            String string = ((AbstractFolder)object2).getName() + ' ';
            if (!((AbstractFolder)object2).isExist()) {
                object4 = this.lbName.getFont().deriveFont(1);
                this.lbName.setFont((Font)object4);
            } else {
                object4 = this.lbName.getFont().deriveFont(0);
                this.lbName.setFont((Font)object4);
            }
            this.lbName.setText(string);
            this.updateCountLabel((AbstractFolder)object2);
            object4 = null;
            if (OS.isMacOS() || isGTKLAF) {
                object4 = GWIcons.EMPTY_ICON;
            }
            if (object2 instanceof SentItemsFolder) {
                if (this.isCachingMode && ((AbstractFolder)object2).hasUnopenedItems()) {
                    this.lbUnOpenedItems.setIcon(ImageResources.ICON_UNSENT_ITEMS);
                } else {
                    this.lbUnOpenedItems.setIcon((Icon)object4);
                }
            } else if (object2 instanceof CalendarFolder) {
                if (((AbstractFolder)object2).hasUnopenedItems()) {
                    this.lbUnOpenedItems.setIcon(ImageResources.ICON_CLOCK_CAL_ITEMS);
                } else {
                    this.lbUnOpenedItems.setIcon((Icon)object4);
                }
            } else if (((AbstractFolder)object2).hasUnopenedItems() && !bl2 && !(object2 instanceof TrashFolder)) {
                this.lbUnOpenedItems.setIcon(ImageResources.ICON_UNOPENED_ITEMS);
            } else {
                this.lbUnOpenedItems.setIcon((Icon)object4);
            }
        }
        if (isGTKLAF) {
            if (bl) {
                this.lbCount.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.lbUnOpenedItems.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.lbName.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.lbCount.setBackground(jTree.getBackground());
                this.lbUnOpenedItems.setBackground(jTree.getBackground());
                this.lbName.setForeground(UIManager.getColor("Label.foreground"));
            }
        }
        if (bl4) {
            this.lbName.setBackground(this.activeSelectionBackground);
        } else {
            this.lbName.setBackground(Color.WHITE);
        }
        this.selected = bl;
        object2 = ((DefaultMutableTreeNode)object).getUserObject();
        this.setNodeIcon(ControlsUtils.getImageForFolder((AbstractFolder)object2, false));
        return this;
    }

    private void updateCountLabel(AbstractFolder abstractFolder) {
        this.lbCount.setForeground(abstractFolder instanceof TrashFolder ? TRASH_COUNT_COLOR : COMMON_COUNT_COLOR);
        this.lbCount.setText(abstractFolder.getDisplayCountString());
    }

    public void setTreeFocused(boolean bl) {
        this.treeHasFocus = bl;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.lbUnOpenedItems.getPreferredSize().width + this.lbName.getPreferredSize().width + this.lbCount.getPreferredSize().width, UIUtils.TREE_ROW_HEIGHT);
        return dimension;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SelectionLabel
    extends OrientableLabel {
        public SelectionLabel() {
            this.setBorder(BorderFactory.createLineBorder(Color.red));
        }

        public void paint(Graphics graphics) {
            boolean bl = this.getComponentOrientation().isLeftToRight();
            GWFoldersTreeRendererColor gWFoldersTreeRendererColor = GWFoldersTreeRendererColor.this;
            Color color = DEFAULT_BACKGROUND;
            if (gWFoldersTreeRendererColor.selected) {
                Color color2 = color = gWFoldersTreeRendererColor.treeHasFocus ? gWFoldersTreeRendererColor.activeSelectionBackground : gWFoldersTreeRendererColor.inactiveSelectionBackground;
            }
            if (isGTKLAF) {
                color = UIManager.getColor("Tree.selectionBackground");
            }
            int n = 0;
            Icon icon = this.getIcon();
            if (icon != null && !isGTKLAF) {
                n = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
            }
            graphics.setColor(color);
            if (gWFoldersTreeRendererColor.selected) {
                graphics.fillRect(bl ? n : 0, 0, this.getWidth() - n, this.getHeight());
                if (!isGTKLAF) {
                    graphics.setColor(BOX_COLOR);
                    this.paintBox(graphics, bl, n);
                }
            }
            if (gWFoldersTreeRendererColor.hasFocus() && GWFoldersTreeRendererColor.this.treeHasFocus || gWFoldersTreeRendererColor.selectPopupFolder) {
                graphics.setColor(color.darker());
                this.paintBox(graphics, bl, n);
            }
            super.paint(graphics);
        }

        private void paintBox(Graphics graphics, boolean bl, int n) {
            graphics.drawRect(bl ? n : 0, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
        }
    }
}

