/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.folderstree.TextTreeRenderer;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class GWTree
extends JTree
implements Autoscroll {
    private Popup popupTip = null;
    private String toolTipText;
    private JLabel tip;
    private static final Color tipBorderColor = new Color(100, 100, 255);
    private static final Color tipBodyColor = new Color(225, 225, 255);
    protected int row_height = this.getRowHeight();
    protected int lastSelectedRow = -1;
    private boolean popupContainerCloseDisabled = false;
    static /* synthetic */ Class class$javax$swing$JPopupMenu;

    public GWTree() {
        this.initToolTips();
    }

    private void initToolTips() {
        this.tip = new OrientableLabel();
        this.tip.setOpaque(true);
        this.tip.setVerticalTextPosition(0);
        this.tip.setHorizontalTextPosition(0);
        this.tip.setBackground(tipBodyColor);
        this.tip.setBorder(new LineBorder(tipBorderColor, 1));
        this.tip.addMouseListener(new MouseAdapter(){

            private void dispatchEventToTree(MouseEvent mouseEvent) {
                GWTree gWTree = GWTree.this;
                gWTree.dispatchEvent(mouseEvent);
            }

            private MouseEvent convertToTree(MouseEvent mouseEvent) {
                Serializable serializable;
                GWTree gWTree = GWTree.this;
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
                SwingUtilities.convertPointFromScreen(point, gWTree);
                int n = GWTree.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                Point point2 = new Point(0, 0);
                if (n < 0) {
                    if (gWTree.isShowing()) {
                        point2 = gWTree.getLocationOnScreen();
                    } else {
                        serializable = (JPopupMenu)SwingUtilities.getAncestorOfClass(class$javax$swing$JPopupMenu == null ? (class$javax$swing$JPopupMenu = GWTree.class$("javax.swing.JPopupMenu")) : class$javax$swing$JPopupMenu, gWTree);
                        point2 = serializable != null ? serializable.getInvoker().getLocationOnScreen() : gWTree.getParent().getLocationOnScreen();
                    }
                }
                serializable = new MouseEvent(gWTree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x - point2.x, point.y - point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                return serializable;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                GWTree.this.setPopupContainerCloseDisabled(mouseEvent.isPopupTrigger());
                this.dispatchEventToTree(this.convertToTree(mouseEvent));
                GWTree.this.hideTipPopup();
                if (!mouseEvent.isPopupTrigger()) {
                    GWTree.this.checkClosingParentPopup();
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                GWTree.this.setPopupContainerCloseDisabled(mouseEvent.isPopupTrigger());
                this.dispatchEventToTree(this.convertToTree(mouseEvent));
                if (!mouseEvent.isPopupTrigger()) {
                    GWTree.this.hideTipPopup();
                    GWTree.this.checkClosingParentPopup();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                GWTree.this.setPopupContainerCloseDisabled(mouseEvent.isPopupTrigger());
                this.dispatchEventToTree(this.convertToTree(mouseEvent));
                GWTree.this.hideTipPopup();
                if (!mouseEvent.isPopupTrigger()) {
                    GWTree.this.checkClosingParentPopup();
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                GWTree.this.hideTipPopup();
            }
        });
        this.addMouseMotionListener(new ToolTipListener());
    }

    private void checkClosingParentPopup() {
        JPopupMenu jPopupMenu = (JPopupMenu)SwingUtilities.getAncestorOfClass(class$javax$swing$JPopupMenu == null ? (class$javax$swing$JPopupMenu = GWTree.class$("javax.swing.JPopupMenu")) : class$javax$swing$JPopupMenu, this);
        if (jPopupMenu != null) {
            jPopupMenu.setVisible(false);
        }
    }

    protected void doPopup(MouseEvent mouseEvent) {
    }

    private void hideTipPopup() {
        if (this.popupTip != null) {
            this.popupTip.hide();
        }
        this.popupTip = null;
        this.toolTipText = null;
        this.setPopupContainerCloseDisabled(false);
    }

    public Insets getAutoscrollInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        Rectangle rectangle = this.getVisibleRect();
        if (rectangle != null) {
            insets.top = rectangle.y + this.row_height;
            insets.left = rectangle.x + this.row_height;
            insets.bottom = this.getHeight() - (rectangle.y + rectangle.height) + this.row_height;
            insets.right = this.getWidth() - (rectangle.x + rectangle.width) + this.row_height;
        }
        return insets;
    }

    public void autoscroll(Point point) {
        UIUtils.scrollComponent(point, this, this.row_height);
        this.repaintDragFolder(point);
    }

    private int getRowAt(int n) {
        return Math.max(0, Math.min(this.getRowCount() - 1, n / this.row_height));
    }

    public void repaintDragFolder(Point point) {
        int n = this.getRowAt(point.y);
        if (this.lastSelectedRow != n) {
            int n2 = this.lastSelectedRow;
            this.lastSelectedRow = n;
            if (n2 != -1) {
                this.repaint(n2);
            }
            this.repaint(n);
        }
    }

    private void repaint(int n) {
        Rectangle rectangle = this.getRowBounds(n);
        if (rectangle != null) {
            this.repaint(rectangle);
        }
    }

    protected void setToolTipFont(Font font) {
        this.tip.setFont(font);
    }

    private void showTipPopup(Dimension dimension, int n, int n2) {
        this.hideTipPopup();
        Point point = this.getLocationOnScreen();
        this.tip.setPreferredSize(dimension);
        this.popupTip = PopupFactory.getSharedInstance().getPopup(this, this.tip, point.x + n, point.y + n2);
        this.popupTip.show();
        this.setPopupContainerCloseDisabled(true);
    }

    public boolean isPopupContainerCloseDisabled() {
        return this.popupContainerCloseDisabled;
    }

    public void setPopupContainerCloseDisabled(boolean bl) {
        this.popupContainerCloseDisabled = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ToolTipListener
    implements MouseMotionListener {
        private ToolTipListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            GWTree gWTree = GWTree.this;
            Container container = gWTree.getParent();
            Point point = mouseEvent.getPoint();
            TreePath treePath = gWTree.getPathForLocation(point.x, point.y);
            int n = gWTree.getRowForLocation(point.x, point.y);
            if (treePath != null) {
                Cloneable cloneable;
                Serializable serializable;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                String string = object.toString();
                if (string.equals(GWTree.this.toolTipText)) {
                    return;
                }
                GWTree.this.hideTipPopup();
                Rectangle rectangle = gWTree.getPathBounds(treePath);
                Rectangle rectangle2 = gWTree.getVisibleRect();
                int n2 = rectangle2.x;
                int n3 = rectangle2.x + rectangle2.width;
                int n4 = rectangle.x + ((TextTreeRenderer)((Object)gWTree.getCellRenderer())).getTextX();
                int n5 = rectangle.x + rectangle.width;
                if (container instanceof JViewport) {
                    serializable = (JViewport)container;
                    cloneable = ((JViewport)serializable).getViewRect();
                    n2 = cloneable.x;
                    n3 = cloneable.x + cloneable.width;
                }
                if (n4 > n2 && n5 < n3) {
                    GWTree.this.toolTipText = null;
                    return;
                }
                GWTree.this.toolTipText = string;
                GWTree.this.tip.setText(GWTree.this.toolTipText);
                serializable = GWTree.this.tip.getFontMetrics(GWTree.this.tip.getFont());
                cloneable = new Dimension(((FontMetrics)serializable).stringWidth(GWTree.this.toolTipText) + 2, ((FontMetrics)serializable).getHeight() + 2);
                int n6 = rectangle.y;
                if (container instanceof JViewport) {
                    JViewport jViewport = (JViewport)container;
                    Point point2 = jViewport.getViewPosition();
                    if (point2.x > n4) {
                        n4 = jViewport.getLocation().x;
                    }
                }
                GWTree.this.showTipPopup((Dimension)cloneable, n4 - 1, n6);
            }
        }
    }
}

