/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.ScrollPaneBorderHighlightFocusListener;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTree;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeModelUtils;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeSerializer;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTreeRenderer;
import com.novell.gw.jclient.application.controls.folderstree.dnd.FoldersTreeDropTargetListener;
import com.novell.gw.jclient.application.controls.folderstree.dnd.MainGWFoldersTreeDragGestureListener;
import com.novell.gw.jclient.application.controls.menus.FolderPopupMenu;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.items.TableItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class MainGWFoldersTree
extends GWFoldersTree {
    private static int TIMER_DELAY = 400;
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$folderstree$MainGWFoldersTree == null ? (class$com$novell$gw$jclient$application$controls$folderstree$MainGWFoldersTree = MainGWFoldersTree.class$("com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree")) : class$com$novell$gw$jclient$application$controls$folderstree$MainGWFoldersTree));
    protected TreeRefreshTimer timer;
    private AbstractFolder dragTargetFolder;
    private AbstractFolder popupFolder;
    public AbstractFolder lastSelectedFolder;
    private GWFoldersTreeSelectionListener selectionListener;
    protected GWFolderTreeExpansionListener expansionListener = new GWFolderTreeExpansionListener();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$folderstree$MainGWFoldersTree;
    static /* synthetic */ Class class$com$appframework$ApplicationFrame;

    public MainGWFoldersTree(MVCController mVCController, String string) {
        super(mVCController, string);
        this.timer = new TreeRefreshTimer(TIMER_DELAY, new TimerAction());
        this.setDropTarget(new DropTarget(this, 3, new FoldersTreeDropTargetListener(this)));
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 2, new MainGWFoldersTreeDragGestureListener(this));
        this.scrollsOnExpand = true;
        MainGWFoldersTreeRenderer mainGWFoldersTreeRenderer = new MainGWFoldersTreeRenderer(this);
        this.setCellRenderer(mainGWFoldersTreeRenderer);
        this.selectionListener = new GWFoldersTreeSelectionListener();
        this.addMouseListener(new MainGWFoldersTreeMouseListener());
        GWFoldersTreeSerializer.restore(this);
        this.addTreeExpansionListener(this.expansionListener);
        this.addFocusListener(new ScrollPaneBorderHighlightFocusListener(this));
        this.addFocusListener(new MainTreeFocusListener());
    }

    public String getUIClassID() {
        if (PLAFChanger.isMetalLAF() || PLAFChanger.isWindowsLAF()) {
            return "FoldersTreeUI";
        }
        return "TreeUI";
    }

    public static AbstractFolder getFolderForPath(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        if (defaultMutableTreeNode.getUserObject() instanceof AbstractFolder) {
            AbstractFolder abstractFolder = (AbstractFolder)defaultMutableTreeNode.getUserObject();
            return abstractFolder;
        }
        return null;
    }

    public void repaintDragFolder(Point point) {
        super.repaintDragFolder(point);
        AbstractFolder abstractFolder = MainGWFoldersTree.getFolderForPath(this.getPathForRow(this.lastSelectedRow));
        this.setDragTargetFolder(abstractFolder);
    }

    public void selectMailBox() {
        this.selectNode(this.getMailBoxNode(), true);
        this.scrollRowToVisible(this.getSelectionRows()[0]);
        Rectangle rectangle = this.getPathBounds(this.getSelectionPath());
        this.scrollRectToVisible(rectangle);
        String string = ((ApplicationFrame)SwingUtilities.getAncestorOfClass(class$com$appframework$ApplicationFrame == null ? (class$com$appframework$ApplicationFrame = MainGWFoldersTree.class$("com.appframework.ApplicationFrame")) : class$com$appframework$ApplicationFrame, this)).getUserGuid();
        this.selectDefaultItem(FoldersCache.getMailboxFolder(string));
    }

    public void refreshTree(boolean bl) {
        AbstractFolder abstractFolder = this.getSelectedFolder();
        this.removeTreeSelectionListener(this.selectionListener);
        this.removeTreeExpansionListener(this.expansionListener);
        super.refreshTree(bl);
        GWFoldersTreeSerializer.restore(this);
        if (bl) {
            this.lastSelectedFolder = null;
        }
        if (abstractFolder != null) {
            String string = ControlsUtils.getUserGuid(this.controller);
            if (!(abstractFolder instanceof QueryFolder)) {
                abstractFolder = EngineCommandManager.getInstance(string).findFolderInCurrentDataStore(abstractFolder);
            }
            this.selectNode(this.getFolderNode(abstractFolder), bl);
        } else {
            this.selectMailBox();
        }
        if (!Arrays.asList(this.getTreeSelectionListeners()).contains(this.selectionListener)) {
            this.addTreeSelectionListener(this.selectionListener);
        }
        this.addTreeExpansionListener(this.expansionListener);
    }

    public AbstractFolder getSelectedFolder() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            return (AbstractFolder)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        }
        return null;
    }

    public void selectFolder(AbstractFolder abstractFolder) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getFolderNode(abstractFolder);
        if (defaultMutableTreeNode != null) {
            this.selectNode(defaultMutableTreeNode, false);
        }
    }

    private void selectNode(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        this.removeTreeSelectionListener(this.selectionListener);
        AbstractFolder abstractFolder = (AbstractFolder)defaultMutableTreeNode.getUserObject();
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.setSelectionPath(treePath);
        if (!abstractFolder.equals(this.lastSelectedFolder)) {
            this.executeRule(false);
            this.lastSelectedFolder = (AbstractFolder)defaultMutableTreeNode.getUserObject();
            this.executeRule(true);
            Command command = new Command(10, this.lastSelectedFolder);
            command.setAttribute("FOCUSED", this.isFocusOwner());
            this.getController().processCommand(command);
            command = new Command(1090, this.lastSelectedFolder);
            command.setAttribute("FORCE_REFRESH", bl);
            this.getController().processCommand(command);
        }
        if (!Arrays.asList(this.getTreeSelectionListeners()).contains(this.selectionListener)) {
            this.addTreeSelectionListener(this.selectionListener);
        }
    }

    private void executeRule(boolean bl) {
        try {
            if (this.lastSelectedFolder != null) {
                this.lastSelectedFolder.getNativeFolder().executeRules(bl);
            }
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException);
        }
    }

    private DefaultMutableTreeNode getMailBoxNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = GWFoldersTreeModelUtils.getMailboxTreeNode((DefaultMutableTreeNode)this.getModel().getRoot());
        if (defaultMutableTreeNode == null) {
            logger.debug((Object)"MAILBOX IS UNAVALIABLE FOR SYSTEM");
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getFolderNode(AbstractFolder abstractFolder) {
        DefaultMutableTreeNode defaultMutableTreeNode = GWFoldersTreeModelUtils.getFolderTreeNode((DefaultMutableTreeNode)this.getModel().getRoot(), abstractFolder);
        if (defaultMutableTreeNode == null) {
            return this.getMailBoxNode();
        }
        return defaultMutableTreeNode;
    }

    public AbstractFolder getPopupFolder() {
        return this.popupFolder;
    }

    public void setPopupFolder(AbstractFolder abstractFolder) {
        this.popupFolder = abstractFolder;
    }

    public AbstractFolder getDragTargetFolder() {
        return this.dragTargetFolder;
    }

    public void setDragTargetFolder(AbstractFolder abstractFolder) {
        this.dragTargetFolder = abstractFolder;
    }

    private void selectDefaultItem(AbstractFolder abstractFolder) {
        String string = ControlsUtils.getUserGuid(this.controller);
        TableItem tableItem = GWCommandManager.getInstance(string).getFirstItem(abstractFolder);
        if (tableItem != null) {
            Command command = new Command(870, tableItem);
            this.getController().processCommand(command);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MainTreeFocusListener
    extends FocusAdapter {
        private MainTreeFocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            MainGWFoldersTree.this.drawItFocused(false);
        }

        public void focusGained(FocusEvent focusEvent) {
            TreePath treePath = MainGWFoldersTree.this.getSelectionPath();
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (object instanceof DefaultMutableTreeNode) {
                AbstractFolder abstractFolder = (AbstractFolder)((DefaultMutableTreeNode)object).getUserObject();
                Command command = new Command(10, abstractFolder);
                command.setAttribute("FOCUSED", Boolean.TRUE);
                MainGWFoldersTree.this.getController().processCommand(command);
                MainGWFoldersTree.this.drawItFocused(true);
            }
        }
    }

    public class GWFolderTreeExpansionListener
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.doSave();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.doSave();
        }

        private void doSave() {
            GWFoldersTreeSerializer.save(MainGWFoldersTree.this);
        }
    }

    private class TimerAction
    implements ActionListener {
        private TimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainGWFoldersTree mainGWFoldersTree = MainGWFoldersTree.this;
            TreePath treePath = mainGWFoldersTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            boolean bl = false;
            if (object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (!defaultMutableTreeNode.getUserObject().equals(MainGWFoldersTree.this.lastSelectedFolder)) {
                    bl = true;
                }
                mainGWFoldersTree.selectNode(defaultMutableTreeNode, true);
            }
            if (bl) {
                MainGWFoldersTree.this.selectDefaultItem(MainGWFoldersTree.this.lastSelectedFolder);
            }
        }
    }

    private class TreeRefreshTimer
    extends Timer {
        public TreeRefreshTimer(int n, TimerAction timerAction) {
            super(n, timerAction);
            this.setRepeats(false);
        }

        public void flash() {
            this.stop();
            this.fireActionPerformed(new ActionEvent(this, 0, null, System.currentTimeMillis(), 0));
        }

        public void start() {
            Command command = new Command(470);
            MainGWFoldersTree.this.getController().processCommand(command);
            super.start();
        }
    }

    private class GWFoldersTreeSelectionListener
    implements TreeSelectionListener {
        private GWFoldersTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            MainGWFoldersTree.this.timer.restart();
        }
    }

    private class MainGWFoldersTreeMouseListener
    implements MouseListener {
        private MainGWFoldersTreeMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!MainGWFoldersTree.this.isFocusOwner()) {
                MainGWFoldersTree.this.requestFocus();
            }
            this.doPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                MainGWFoldersTree.this.timer.flash();
            }
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = MainGWFoldersTree.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n < 0) {
                    return;
                }
                TreePath treePath = MainGWFoldersTree.this.getPathForRow(n);
                if (treePath == null) {
                    return;
                }
                MainGWFoldersTree.this.popupFolder = (AbstractFolder)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                ActionList actionList = MainGWFoldersTree.this.getController().getActionList();
                if (actionList instanceof ApplicationFrameActionList) {
                    FolderPopupMenu folderPopupMenu = FolderPopupMenu.createFolderPopupMenu(MainGWFoldersTree.this.popupFolder, (ApplicationFrameActionList)actionList);
                    ((JPopupMenu)folderPopupMenu).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    MainGWFoldersTree.this.repaint();
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

