/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.cache.IDObjectsCollection;
import com.novell.gw.engine.EngineLocale;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import com.novell.gw.message.Appointment;
import com.novell.gw.message.Message;
import com.novell.gw.message.Note;
import com.novell.gw.message.Task;
import java.awt.Color;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public final class GWCalendarUtils {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$GWCalendarUtils == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$GWCalendarUtils = GWCalendarUtils.class$("com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils")) : class$com$novell$gw$jclient$application$controls$gwcalendar$GWCalendarUtils));
    public static String[] dayNames = new String[]{StringResources.SUNDAY, StringResources.MONDAY, StringResources.TUESDAY, StringResources.WEDNESDAY, StringResources.THURSDAY, StringResources.FRIDAY, StringResources.SATURDAY};
    public static String[] dayMediumNames = new String[]{StringResources.SUNDAY_SHORT, StringResources.MONDAY_SHORT, StringResources.TUESDAY_SHORT, StringResources.WEDNESDAY_SHORT, StringResources.THURSDAY_SHORT, StringResources.FRIDAY_SHORT, StringResources.SATURDAY_SHORT};
    public static String[] dayShortestNames = new String[]{StringResources.SUNDAY_SHORTEST, StringResources.MONDAY_SHORTEST, StringResources.TUESDAY_SHORTEST, StringResources.WEDNESDAY_SHORTEST, StringResources.THURSDAY_SHORTEST, StringResources.FRIDAY_SHORTEST, StringResources.SATURDAY_SHORTEST};
    public static String[] monthNames = new String[]{StringResources.JANUARY, StringResources.FEBRUARY, StringResources.MARCH, StringResources.APRIL, StringResources.MAY, StringResources.JUNE, StringResources.JULY, StringResources.AUGUST, StringResources.SEPTEMBER, StringResources.OCTOBER, StringResources.NOVEMBER, StringResources.DECEMBER};
    public static String[] monthShortNames = new String[]{StringResources.JANUARY_SHORT, StringResources.FEBRUARY_SHORT, StringResources.MARCH_SHORT, StringResources.APRIL_SHORT, StringResources.MAY_SHORT, StringResources.JUNE_SHORT, StringResources.JULY_SHORT, StringResources.AUGUST_SHORT, StringResources.SEPTEMBER_SHORT, StringResources.OCTOBER_SHORT, StringResources.NOVEMBER_SHORT, StringResources.DECEMBER_SHORT};
    public static DateFormat HOUR_FORMAT = new SimpleDateFormat("h", EngineCommandManager.getLocale());
    public static DateFormat MIN_FORMAT = new SimpleDateFormat("mm", EngineCommandManager.getLocale());
    public static DateFormat AMPM_FORMAT = new SimpleDateFormat("aa", EngineCommandManager.getLocale());
    private static DateFormat dateFormat;
    private static DateFormat dateFormatFull;
    private static DateFormat dateFormatMedium;
    private static DateFormat timeFormatMedium;
    private static DateFormat timeFormatShort;
    private static DateFormat timeFormatHMMA;
    private static DateFormat dateTimeFormat;
    private static DateFormat dateTimeFormatWithDayOfWeek;
    public static final int ONE_MINUTE_MILISECS = 60000;
    public static final int ONE_HOUR_MILISECS = 3600000;
    public static final int ONE_HALFHOUR_MILISECS = 1800000;
    public static final int ONE_DAY_MILISECS = 86400000;
    public static final int DEFAULT_DURATION_IN_MILISECS = 3600000;
    public static final int DEFAULT_DURATION_IN_MINUTES = 60;
    protected static DateFormatSymbols dateFormatSymbols;
    private static DateFormat timeFormatDDMM;
    private static DateFormat timeHMFormat;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$GWCalendarUtils;

    public static GregorianCalendar getToday() {
        TimeZone timeZone = OptionManager.getInstance().getDateTimeOptions().getTimeZone();
        return new GregorianCalendar(timeZone, EngineCommandManager.getLocale());
    }

    public static GregorianCalendar getTodayUTC() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(EngineCommandManager.getLocale());
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        return gregorianCalendar;
    }

    public static int getZoneOffset() {
        TimeZone timeZone = OptionManager.getInstance().getDateTimeOptions().getTimeZone();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        return timeZone.getOffset(gregorianCalendar.getTimeInMillis());
    }

    public static String calendarToString(GregorianCalendar gregorianCalendar) {
        return GWCalendarUtils.calendarToString(gregorianCalendar.getTime());
    }

    public static String calendarToString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return simpleDateFormat.format(date);
    }

    public static GregorianCalendar getDateForDayOfWeek(GregorianCalendar gregorianCalendar, int n) {
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        gregorianCalendar2.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), 0, 0, 0);
        int n2 = gregorianCalendar2.getFirstDayOfWeek() - 1;
        int n3 = gregorianCalendar2.get(7);
        if (n3 == 1 && n2 == 1) {
            n3 = 8;
        }
        gregorianCalendar2.add(5, -n3 + n + n2);
        return gregorianCalendar2;
    }

    public static TimeInterval getDayTimeInterval(Date date) {
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        gregorianCalendar2.set(11, 23);
        gregorianCalendar2.set(12, 59);
        gregorianCalendar2.set(13, 59);
        gregorianCalendar.set(14, 999);
        return new TimeInterval(gregorianCalendar.getTimeInMillis(), gregorianCalendar2.getTimeInMillis());
    }

    public static TimeInterval getDayTimeInterval(Date date, Date date2) {
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        GregorianCalendar gregorianCalendar2 = GWCalendarUtils.getToday();
        gregorianCalendar2.setTime(date2);
        gregorianCalendar2.set(11, 23);
        gregorianCalendar2.set(12, 59);
        gregorianCalendar2.set(13, 59);
        gregorianCalendar.set(14, 999);
        return new TimeInterval(gregorianCalendar.getTimeInMillis(), gregorianCalendar2.getTimeInMillis());
    }

    public static TimeInterval getMonthTimeInterval(Date date) {
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(5, 1);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        gregorianCalendar2.set(5, gregorianCalendar2.getActualMaximum(5));
        gregorianCalendar2.set(11, 23);
        gregorianCalendar2.set(12, 59);
        gregorianCalendar2.set(13, 59);
        gregorianCalendar.set(14, 999);
        return new TimeInterval(gregorianCalendar.getTimeInMillis(), gregorianCalendar2.getTimeInMillis());
    }

    public static int getMonthBusyDays(int n, int n2, AbstractFolder abstractFolder) {
        try {
            return GWCommandManager.getMonthBusyDays(n, n2, abstractFolder);
        }
        catch (GWException gWException) {
            ErrorDialog.processGWException(gWException);
            return 0;
        }
    }

    public static DateFormat getTimeHMFormat() {
        if (timeHMFormat == null) {
            timeHMFormat = new SimpleDateFormat("HH:mm");
            timeHMFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        return timeHMFormat;
    }

    public static boolean isAMPM() {
        String string = GWCalendarUtils.getTimeFormat().format(GWCalendarUtils.getTodayUTC().getTime()).toUpperCase();
        return string.indexOf("AM") > 0 || string.indexOf("PM") > 0;
    }

    public static DateFormat getDateTimeFormat() {
        if (dateTimeFormat == null) {
            dateTimeFormat = DateFormat.getDateTimeInstance(3, 3, EngineCommandManager.getLocale());
            dateTimeFormat.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }
        return dateTimeFormat;
    }

    public static DateFormat getDateTimeFormatWithDayOfWeek() {
        if (dateTimeFormatWithDayOfWeek == null) {
            dateTimeFormatWithDayOfWeek = DateFormat.getDateTimeInstance(0, 3, EngineCommandManager.getLocale());
            dateTimeFormatWithDayOfWeek.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }
        return dateTimeFormatWithDayOfWeek;
    }

    public static DateFormat getTimeFormat() {
        return GWCalendarUtils.getTimeFormatHMMA();
    }

    public static DateFormat getTimeFormatMedium() {
        if (timeFormatMedium == null) {
            timeFormatMedium = DateFormat.getTimeInstance(2, EngineCommandManager.getLocale());
            timeFormatMedium.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }
        return timeFormatMedium;
    }

    public static DateFormat getTimeFormatShort() {
        if (timeFormatShort == null) {
            timeFormatShort = DateFormat.getTimeInstance(3, EngineCommandManager.getLocale());
            timeFormatShort.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }
        return timeFormatShort;
    }

    public static DateFormat getTimeFormatHMMA() {
        if (timeFormatHMMA == null) {
            timeFormatHMMA = "ja".equals(EngineLocale.getCurrent().getLocale().getLanguage()) ? new SimpleDateFormat("a h:mm", GWCalendarUtils.getDateFormatSymbols()) : DateFormat.getTimeInstance(3, EngineCommandManager.getLocale());
            if (timeFormatHMMA instanceof SimpleDateFormat) {
                ((SimpleDateFormat)timeFormatHMMA).setDateFormatSymbols(GWCalendarUtils.getDateFormatSymbols());
            }
            timeFormatHMMA.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }
        return timeFormatHMMA;
    }

    private static DateFormatSymbols getDateFormatSymbols() {
        if (dateFormatSymbols == null) {
            dateFormatSymbols = new DateFormatSymbols(EngineCommandManager.getLocale());
            dateFormatSymbols.setAmPmStrings(new String[]{StringResources.AM, StringResources.PM});
        }
        return dateFormatSymbols;
    }

    public static DateFormat getDateFormat() {
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateInstance(3, EngineCommandManager.getLocale());
            dateFormat.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }
        return dateFormat;
    }

    public static DateFormat getDateFormatFull() {
        if (dateFormatFull == null) {
            String string = "EEEEE, MMMMM d, yyyy";
            try {
                dateFormatFull = new SimpleDateFormat(StringResources.DATE_FORMAT_FULL.equals(StringResources.getUNDEFINED_RESOURCE()) ? string : StringResources.DATE_FORMAT_FULL, EngineCommandManager.getLocale());
            }
            catch (Exception exception) {
                logger.warn((Object)("Incorrect date format received from resources. Date format:" + StringResources.DATE_FORMAT_FULL));
                logger.error((Object)exception, (Throwable)exception);
                dateFormatFull = new SimpleDateFormat(string);
            }
        }
        return dateFormatFull;
    }

    public static DateFormat getDateFormatMedium() {
        if (dateFormatMedium == null) {
            dateFormatMedium = "CT".equals(EngineLocale.getCurrent().getCode()) || "KR".equals(EngineLocale.getCurrent().getCode()) || "US".equals(EngineLocale.getCurrent().getCode()) ? new SimpleDateFormat("MM/dd/yyyy") : ("BR".equals(EngineLocale.getCurrent().getCode()) ? new SimpleDateFormat("dd-MM-yyyy") : ("JP".equals(EngineLocale.getCurrent().getCode()) ? new SimpleDateFormat("yyyy-MM-dd") : ("ES".equals(EngineLocale.getCurrent().getCode()) ? new SimpleDateFormat("dd.MM.yyyy") : DateFormat.getDateInstance(2, EngineCommandManager.getLocale()))));
            dateFormatMedium.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }
        return dateFormatMedium;
    }

    public static DateFormat getDateFormatMMDD() {
        if (timeFormatDDMM == null) {
            timeFormatDDMM = new SimpleDateFormat("MM/dd", EngineCommandManager.getLocale());
            timeFormatDDMM.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }
        return timeFormatDDMM;
    }

    public static long getDifferenceInSeconds(Date date, Date date2) {
        return (date.getTime() - date2.getTime()) / 1000L;
    }

    public static long getDifferenceInMinutes(Date date, Date date2) {
        return (date.getTime() - date2.getTime()) / 60000L;
    }

    public static long getDifferenceInHours(Date date, Date date2) {
        return (date.getTime() - date2.getTime()) / 3600000L;
    }

    public static long getDifferenceInDays(Date date, Date date2) {
        return (date.getTime() - date2.getTime()) / 86400000L;
    }

    public static boolean isSameDate(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) {
        if (gregorianCalendar == null || gregorianCalendar2 == null) {
            return false;
        }
        return GWCalendarUtils.isSameDate(gregorianCalendar.getTime(), gregorianCalendar2.getTime());
    }

    public static boolean isSameDate(Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        String string = GWCalendarUtils.getDateFormat().format(date);
        String string2 = GWCalendarUtils.getDateFormat().format(date2);
        return string.equals(string2);
    }

    public static String getDurationText(long l) {
        long l2 = l / 86400000L;
        long l3 = (l - l2 * 86400000L) / 3600000L;
        long l4 = (l - l2 * 86400000L - l3 * 3600000L) / 60000L;
        StringBuffer stringBuffer = new StringBuffer();
        if (l2 > 0L) {
            stringBuffer.append(l2);
            stringBuffer.append(" ");
            stringBuffer.append(l2 == 1L ? StringResources.DAY : StringResources.DAYS);
        }
        if (l3 > 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(l3);
            stringBuffer.append(" ");
            stringBuffer.append(l3 == 1L ? StringResources.HOUR : StringResources.HOURS);
        }
        if (l4 > 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(l4);
            stringBuffer.append(" ");
            stringBuffer.append(l4 == 1L ? StringResources.MINUTE : StringResources.MINUTES);
        }
        return "(" + stringBuffer.toString() + ")";
    }

    public static GregorianCalendar initCalendar(GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = GWCalendarUtils.getToday();
        gregorianCalendar2.set(1, gregorianCalendar.get(1));
        gregorianCalendar2.set(2, gregorianCalendar.get(2));
        gregorianCalendar2.set(5, 1);
        int n = gregorianCalendar2.get(7);
        int n2 = gregorianCalendar2.getFirstDayOfWeek();
        int n3 = 1;
        while (n2 != n) {
            n2 = n2 == 7 ? 1 : ++n2;
            ++n3;
        }
        gregorianCalendar2.add(5, -n3);
        return gregorianCalendar2;
    }

    public static IDObjectsCollection getCalendarItems(ItemList itemList, Date date, String string) {
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.setTime(date);
        if (gregorianCalendar.get(11) == 0 && gregorianCalendar.get(12) == 0) {
            gregorianCalendar.set(11, 12);
        }
        Date date2 = gregorianCalendar.getTime();
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        if (itemList == null) {
            return iDObjectsCollection;
        }
        if (string.equals("Task")) {
            IDObjectsCollection iDObjectsCollection2 = GWCalendarUtils.toIDObjectsCollection(itemList.getTasks(date2));
            logger.debug((Object)(":: get tasks. date: [" + date2 + "]. items found: [" + iDObjectsCollection2.size() + "]"));
            iDObjectsCollection.addCollection(iDObjectsCollection2);
        } else if (string.equals("Note")) {
            IDObjectsCollection iDObjectsCollection3 = GWCalendarUtils.toIDObjectsCollection(itemList.getNotes(date2));
            logger.debug((Object)(":: get notes. date: [" + date2 + "]. items found: [" + iDObjectsCollection3.size() + "]"));
            iDObjectsCollection.addCollection(iDObjectsCollection3);
        } else if (string.equals("Appointment")) {
            IDObjectsCollection iDObjectsCollection4 = GWCalendarUtils.toIDObjectsCollection(itemList.getAppointments(date2));
            logger.debug((Object)(":: get appointments. date: [" + date2 + "]. items found: [" + iDObjectsCollection4.size() + "]"));
            iDObjectsCollection.addCollection(iDObjectsCollection4);
        } else if (string.equals("AllDayEvent")) {
            IDObjectsCollection iDObjectsCollection5 = GWCalendarUtils.toIDObjectsCollection(itemList.getAllDayEvents(date2));
            logger.debug((Object)(":: get alldayevents. date: [" + date2 + "]. items found: [" + iDObjectsCollection5.size() + "]"));
            iDObjectsCollection.addCollection(iDObjectsCollection5);
        } else if (string.equals("AppointmentAndAllDayEvent")) {
            IDObjectsCollection iDObjectsCollection6 = GWCalendarUtils.toIDObjectsCollection(itemList.getCalendarItems(date2, 8));
            logger.debug((Object)(":: get alldayevents and appointments. date: [" + date2 + "]. items found: [" + iDObjectsCollection6.size() + "]"));
            iDObjectsCollection.addCollection(iDObjectsCollection6);
        }
        return iDObjectsCollection;
    }

    private static IDObjectsCollection toIDObjectsCollection(Item[] itemArray) {
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        try {
            for (int i = 0; i < itemArray.length; ++i) {
                Item item = itemArray[i];
                if (!(item instanceof Message)) continue;
                AbstractItem abstractItem = GWItemFactory.gwObjectToItem((Message)item);
                iDObjectsCollection.addIDObject(abstractItem);
            }
        }
        catch (GWCommandException gWCommandException) {
            ErrorDialog.processGWException(gWCommandException);
        }
        return iDObjectsCollection;
    }

    public static void fillCalendarItems(ItemList itemList, Date date, IDObjectsCollection iDObjectsCollection, IDObjectsCollection iDObjectsCollection2, IDObjectsCollection iDObjectsCollection3) {
        if (itemList == null || date == null) {
            return;
        }
        Item[] itemArray = itemList.getCalendarItems(date);
        logger.debug((Object)(":: fillCalendarItems. date: [" + date + "]. items found: [" + itemArray.length + "]"));
        try {
            for (int i = 0; i < itemArray.length; ++i) {
                Item item = itemArray[i];
                if (item instanceof Task) {
                    iDObjectsCollection2.addIDObject(GWItemFactory.gwObjectToItem((Message)((Task)item)));
                    continue;
                }
                if (item instanceof Appointment) {
                    iDObjectsCollection.addIDObject(GWItemFactory.gwObjectToItem((Message)((Appointment)item)));
                    continue;
                }
                if (item instanceof Note) {
                    iDObjectsCollection3.addIDObject(GWItemFactory.gwObjectToItem((Message)((Note)item)));
                    continue;
                }
                logger.warn((Object)("Invalid calendar item received. Calendar item: [" + item + "]"));
            }
        }
        catch (GWCommandException gWCommandException) {
            ErrorDialog.processGWException(gWCommandException);
        }
    }

    public static IDObjectsCollection getNotes(ItemList itemList, Date date) {
        return GWCalendarUtils.getCalendarItems(itemList, date, "Note");
    }

    public static IDObjectsCollection getTasks(ItemList itemList, Date date) {
        return GWCalendarUtils.getCalendarItems(itemList, date, "Task");
    }

    public static IDObjectsCollection getAppointments(ItemList itemList, Date date) {
        return GWCalendarUtils.getCalendarItems(itemList, date, "Appointment");
    }

    public static IDObjectsCollection getAllDayEvents(ItemList itemList, Date date) {
        return GWCalendarUtils.getCalendarItems(itemList, date, "AllDayEvent");
    }

    public static int getClockPosition() {
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        int n = gregorianCalendar.get(11);
        int n2 = gregorianCalendar.get(12);
        int n3 = n * 60 + n2;
        n3 = (int)((float)n3 * AppointmentPanel.PX_PER_MINUTE);
        return n3;
    }

    public static boolean isToday(Date date) {
        String string = GWCalendarUtils.getDateFormat().format(GWCalendarUtils.getToday().getTime());
        String string2 = GWCalendarUtils.getDateFormat().format(date);
        return string2.equals(string);
    }

    public static GregorianCalendar getZero(GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        gregorianCalendar2.set(11, 24);
        gregorianCalendar2.set(12, 0);
        gregorianCalendar2.set(13, 0);
        gregorianCalendar2.set(14, 0);
        return gregorianCalendar2;
    }

    public static int getMinutes(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar.get(11) * 60 + gregorianCalendar.get(12);
    }

    public static boolean inMonthRange(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) {
        return gregorianCalendar.get(2) == gregorianCalendar2.get(2) && gregorianCalendar.get(1) == gregorianCalendar2.get(1);
    }

    public static int getChangeMask(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) {
        if (gregorianCalendar == null) {
            return 7;
        }
        int n = gregorianCalendar.get(5);
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(1);
        int n4 = gregorianCalendar2.get(5);
        int n5 = gregorianCalendar2.get(2);
        int n6 = gregorianCalendar2.get(1);
        int n7 = 0;
        if (n != n4) {
            n7 |= 1;
        }
        if (n2 != n5) {
            n7 |= 2;
        }
        if (n3 != n6) {
            n7 |= 4;
        }
        return n7;
    }

    public static Date[] CalendarToDate(GregorianCalendar[] gregorianCalendarArray) {
        Date[] dateArray = new Date[gregorianCalendarArray.length];
        for (int i = 0; i < gregorianCalendarArray.length; ++i) {
            GregorianCalendar gregorianCalendar = gregorianCalendarArray[i];
            dateArray[i] = gregorianCalendar.getTime();
        }
        return dateArray;
    }

    public static GregorianCalendar[] DateToCalendar(Date[] dateArray) {
        GregorianCalendar[] gregorianCalendarArray = new GregorianCalendar[dateArray.length];
        for (int i = 0; i < dateArray.length; ++i) {
            Date date = dateArray[i];
            GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
            gregorianCalendar.setTime(date);
            gregorianCalendarArray[i] = gregorianCalendar;
        }
        return gregorianCalendarArray;
    }

    public static void clearTime(GregorianCalendar gregorianCalendar) {
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
    }

    public static IDObjectsCollection getAppointmentsForTimeInterval(IDObjectsCollection iDObjectsCollection, TimeInterval timeInterval) {
        IDObjectsCollection iDObjectsCollection2 = new IDObjectsCollection();
        for (int i = 0; i < iDObjectsCollection.size(); ++i) {
            AppointmentItem appointmentItem = (AppointmentItem)iDObjectsCollection.getIDObjectAt(i);
            if (!appointmentItem.isInTimeInterval(timeInterval)) continue;
            iDObjectsCollection2.addIDObject(appointmentItem);
        }
        return iDObjectsCollection2;
    }

    public static Color getShowAsLevelColor(int n) {
        if (n == 160) {
            return Color.WHITE;
        }
        if (n == 190) {
            return ColorConstants.TENTATIVE_APPOINTMENT_COLOR;
        }
        if (n == 210) {
            return ColorConstants.BUSY_APPOINTMENT_COLOR;
        }
        if (n == 251) {
            return ColorConstants.OUT_OF_OFFICE_APPOINTMENT_COLOR;
        }
        throw new IllegalStateException("Unknown appointment show as level");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

