/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.components.ArrayIcon;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class MultilineLabel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$MultilineLabel == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$MultilineLabel = MultilineLabel.class$("com.novell.gw.jclient.application.controls.gwcalendar.MultilineLabel")) : class$com$novell$gw$jclient$application$controls$gwcalendar$MultilineLabel));
    private volatile int labelHeight = 0;
    protected Insets insets = new Insets(2, 2, 2, 2);
    protected int iconTextGap = 3;
    protected int iconIconGap = 2;
    protected int iconXOffset = 2;
    protected int iconYOffset = 4;
    protected String text = "";
    private ImageIcon statusIcon = null;
    private List substrings = new ArrayList();
    private int oldWidth = 0;
    protected boolean isMultiLine = true;
    protected boolean isLTR = UIUtils.getComponentOrientation().isLeftToRight();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$MultilineLabel;

    public MultilineLabel() {
        this("");
    }

    public MultilineLabel(String string) {
        this.setText(string);
    }

    public void setText(String string) {
        this.text = string == null ? "" : string;
    }

    public void setStatusIcon(ImageIcon imageIcon) {
        this.statusIcon = imageIcon;
    }

    public void setStatusIcon(ArrayList arrayList) {
        if (arrayList.size() == 1) {
            this.setStatusIcon((ImageIcon)arrayList.get(0));
        } else if (arrayList.size() > 1) {
            this.setStatusIcon(new ArrayIcon(arrayList.toArray(new Icon[arrayList.size()]), 1, 0));
        }
    }

    public ImageIcon getStatusIcon() {
        return this.statusIcon;
    }

    protected int getStatusIconWidth() {
        return this.statusIcon != null ? this.statusIcon.getIconWidth() : 0;
    }

    public Dimension getPreferredSize() {
        if (this.isMultiLine) {
            return new Dimension(this.getWidth(), this.getPreferredHeight(this.getWidth()));
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = SwingUtilities.computeStringWidth(fontMetrics, this.text);
        int n2 = this.insets.top + fontMetrics.getHeight() + this.insets.bottom;
        int n3 = this.insets.left + this.getStatusIconWidth() + this.iconTextGap + n + this.insets.right;
        return new Dimension(n3, n2);
    }

    public int getPreferredHeight(int n) {
        this.updateSubstrings(n);
        return this.labelHeight;
    }

    private void updateSubstrings(int n) {
        if (this.oldWidth != n) {
            this.substrings.clear();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (this.isMultiLine) {
                this.substrings = UIUtils.breakStringIntoSubstrings(this.text, fontMetrics, n - (this.insets.left + this.insets.right) * 2 - this.getStatusIconWidth());
            } else {
                this.substrings.add(this.text);
            }
            this.labelHeight = this.insets.top + fontMetrics.getHeight() * this.substrings.size() + this.insets.bottom;
            this.oldWidth = n;
        }
    }

    public final void paint(Graphics graphics) {
        graphics = UIUtils.enableAntialiasing(graphics);
        super.paint(graphics);
        this.paintSelection(graphics);
        this.paintIcons(graphics);
        this.paintMultilineText(graphics);
    }

    protected void paintIcons(Graphics graphics) {
        if (this.statusIcon != null) {
            int n = this.isLTR ? this.iconXOffset : this.getWidth() - this.statusIcon.getIconWidth();
            this.statusIcon.paintIcon(this, graphics, n, this.iconYOffset);
        }
    }

    protected int getIconX(int n, int n2) {
        int n3 = n;
        n3 = this.isLTR ? n : this.getWidth() - n2 - n;
        return n3;
    }

    protected int getTextStartX() {
        return this.insets.left + this.getStatusIconWidth() + this.iconTextGap;
    }

    private void paintMultilineText(Graphics graphics) {
        this.updateSubstrings(this.getWidth());
        graphics.setColor(this.getForeground());
        for (int i = 0; i < this.substrings.size(); ++i) {
            int n;
            String string = (String)this.substrings.get(i);
            if (this.isLTR) {
                n = this.getTextStartX();
            } else {
                int n2 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), string);
                n = this.getWidth() - this.getTextStartX() - n2;
            }
            graphics.drawString(string, n, graphics.getFontMetrics().getHeight() * (i + 1) - 2);
        }
    }

    protected int getSelectionX(int n) {
        if (this.isLTR) {
            return n;
        }
        return this.getWidth() - n;
    }

    protected abstract void paintSelection(Graphics var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

