/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarScrollPane;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarView;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarViewController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.LabelFocusListener;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigateCreateItem;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigationCreateItemKeyboardListener;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ActiveHourLabelsPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.CalendarBoxesPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.YearlyCalendar;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class DailyView
extends CalendarView
implements NavigateCreateItem {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$daily$dailyview$DailyView == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$daily$dailyview$DailyView = DailyView.class$("com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview.DailyView")) : class$com$novell$gw$jclient$application$controls$gwcalendar$daily$dailyview$DailyView));
    private static DateFormat CAPTION_DATE_FORMAT = GWCalendarUtils.getDateFormatFull();
    private JSplitPane spltTaskNotes;
    private JSplitPane spltAppointments;
    private AppointmentPanel pnlAppointment;
    private AppointmentsClockPanel appointmentClockPanel;
    private JComponent compNotes;
    private JComponent compTasks;
    private JComponent compAllDayEvents;
    private CalendarBoxesPanel tasksBoxesPanel;
    private CalendarBoxesPanel notesBoxesPanel;
    private CalendarBoxesPanel allDayEventsBoxesPanel;
    private YearlyCalendar calendar;
    private boolean calendarAdjusting;
    private boolean isVertSplitVisible;
    private JComponent compAppointments;
    private static final int ALL_DAY_ITEMS_PANEL_HEIGHT = 50;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$daily$dailyview$DailyView;

    public DailyView(GregorianCalendar gregorianCalendar, TypesToggle typesToggle, MVCController mVCController) {
        super(gregorianCalendar, typesToggle, mVCController);
        super.change(new CalendarStateEvent(true, 0));
    }

    protected MVCController createController(MVCController mVCController) {
        return new CalendarViewController(this, mVCController);
    }

    protected void buildUI() {
        super.buildUI();
        this.setFocusable(false);
        this.buildNotesPanel();
        this.buildTasksPanel();
        this.buildAllDayPanel();
        this.buildAppointmentsPanel();
        this.spltTaskNotes = new GWSplitPane(0, this.compNotes, this.compTasks);
        this.spltTaskNotes.setOneTouchExpandable(false);
        this.spltTaskNotes.setResizeWeight(0.5);
        this.spltTaskNotes.setBorder(BorderFactory.createEmptyBorder());
        this.spltTaskNotes.addPropertyChangeListener(new DividerPositionListener("CALENDAR_DAILY_TASKNOTES_SPLITPOS" + this.optionFrameName, this.spltTaskNotes));
        this.spltAppointments = new GWSplitPane(1, this.compAppointments, this.spltTaskNotes);
        this.spltAppointments.setOneTouchExpandable(false);
        this.spltAppointments.setResizeWeight(0.5);
        this.spltAppointments.setBorder(BorderFactory.createEmptyBorder());
        this.spltAppointments.addPropertyChangeListener(new DividerPositionListener("CALENDAR_DAILY_APPOINTMENTS_SPLITPOS" + this.optionFrameName, this.spltAppointments));
        this.calendar = new YearlyCalendar(this.currentDay, false, this.getController(), true);
        this.calendar.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.calendar.addValueChangeListener(new CalendarListener());
        this.add((Component)this.spltAppointments, "Center");
        this.add((Component)this.calendar, "Before");
        Rectangle rectangle = AppointmentPanel.getWorkTimeRectangle();
        this.appointmentClockPanel.scrollRectToVisible(rectangle);
        this.adjustView();
    }

    private void buildAppointmentsPanel() {
        this.compAppointments = new OrientablePanel(new BorderLayout());
        this.compAppointments.setBackground(Color.WHITE);
        this.compAppointments.setMinimumSize(new Dimension(0, 0));
        this.compAppointments.setBorder(null);
        this.compAppointments.setBorder(BorderFactory.createEmptyBorder());
        HeaderLabel headerLabel = new HeaderLabel(" " + StringResources.APPOINTMENTS_C);
        headerLabel.setBorder(BorderFactory.createEmptyBorder());
        this.compAppointments.add((Component)headerLabel, "North");
        this.appointmentClockPanel = new AppointmentsClockPanel();
        this.appointmentClockPanel.setBorder(BorderFactory.createEmptyBorder());
        this.appointmentClockPanel.addFocusListener(new LabelFocusListener(headerLabel));
        CalendarScrollPane calendarScrollPane = new CalendarScrollPane(this.appointmentClockPanel);
        calendarScrollPane.setBorder(BorderFactory.createEmptyBorder());
        calendarScrollPane.getViewport().setBackground(ColorConstants.clrCurrDayBack);
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.setBorder(BorderFactory.createEmptyBorder());
        orientablePanel.add((Component)this.compAllDayEvents, "North");
        orientablePanel.add((Component)calendarScrollPane, "Center");
        this.compAppointments.add((Component)orientablePanel, "Center");
    }

    private void buildNotesPanel() {
        this.compNotes = new OrientablePanel(new BorderLayout());
        this.compNotes.setBackground(Color.WHITE);
        this.compNotes.setMinimumSize(new Dimension(0, 0));
        this.compNotes.setBorder(BorderFactory.createEmptyBorder());
        HeaderLabel headerLabel = new HeaderLabel(" " + StringResources.REMINDER_NOTES_C);
        headerLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorConstants.HEADER_BORDER_COLOR));
        this.compNotes.add((Component)headerLabel, "North");
        this.notesBoxesPanel = new CalendarBoxesPanel(this.getController(), "Note", 1, false);
        this.notesBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        this.notesBoxesPanel.addFocusListener(new LabelFocusListener(headerLabel));
        CalendarScrollPane calendarScrollPane = new CalendarScrollPane(this.notesBoxesPanel);
        calendarScrollPane.setBorder(BorderFactory.createEmptyBorder());
        calendarScrollPane.getViewport().setBackground(ColorConstants.clrCurrDayBack);
        this.compNotes.add((Component)calendarScrollPane, "Center");
    }

    private void buildTasksPanel() {
        this.compTasks = new OrientablePanel(new BorderLayout());
        this.compTasks.setBackground(Color.white);
        this.compTasks.setMinimumSize(new Dimension(0, 0));
        this.compTasks.setBorder(BorderFactory.createEmptyBorder());
        HeaderLabel headerLabel = new HeaderLabel(" " + StringResources.TASKS_C);
        headerLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorConstants.HEADER_BORDER_COLOR));
        this.compTasks.add((Component)headerLabel, "North");
        this.tasksBoxesPanel = new CalendarBoxesPanel(this.getController(), "Task", 1, false);
        this.tasksBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        this.tasksBoxesPanel.addFocusListener(new LabelFocusListener(headerLabel));
        CalendarScrollPane calendarScrollPane = new CalendarScrollPane(this.tasksBoxesPanel);
        calendarScrollPane.setBorder(BorderFactory.createEmptyBorder());
        calendarScrollPane.getViewport().setBackground(ColorConstants.clrCurrDayBack);
        this.compTasks.add((Component)calendarScrollPane, "Center");
    }

    private void buildAllDayPanel() {
        this.allDayEventsBoxesPanel = new CalendarBoxesPanel(this.getController(), "AllDayEvent", 1, false);
        this.allDayEventsBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        this.compAllDayEvents = CalendarUtils.createLeftCaptionAndScrollPane(this.allDayEventsBoxesPanel, ImageResources.ITM_ALL_DAY_EVENT_LARGE, BorderFactory.createMatteBorder(0, 1, 0, 1, ColorConstants.HEADER_BORDER_COLOR));
        this.compAllDayEvents.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, ColorConstants.HEADER_BORDER_COLOR));
        this.compAllDayEvents.setPreferredSize(new Dimension(0, 50));
    }

    protected int getViewType() {
        return 0;
    }

    protected void prepareRefresh(boolean bl) {
        this.refreshedInterval = GWCalendarUtils.getDayTimeInterval(this.currentDay.getTime());
        this.calendarAdjusting = true;
        this.calendar.setCurrentDate(this.currentDay);
        if (bl) {
            this.calendar.validateBusyDays(this.getFolder());
        }
        this.calendarAdjusting = false;
    }

    protected void refreshTasks(ItemList itemList, TimeInterval timeInterval) {
        this.tasksBoxesPanel.loadItemsForDate(this.currentDay, itemList, timeInterval);
    }

    protected void refreshNotes(ItemList itemList, TimeInterval timeInterval) {
        this.notesBoxesPanel.loadItemsForDate(this.currentDay, itemList, timeInterval);
    }

    protected void refreshAppointments(ItemList itemList, TimeInterval timeInterval) {
        if (timeInterval == null || timeInterval != null && timeInterval.contains(this.currentDay)) {
            this.lblTitle.setText(" " + CAPTION_DATE_FORMAT.format(this.currentDay.getTime()));
            this.pnlAppointment.loadItemsForDate(this.currentDay.getTime(), itemList);
        }
    }

    protected void refreshAllDayEvents(ItemList itemList, TimeInterval timeInterval) {
        this.allDayEventsBoxesPanel.loadItemsForDate(this.currentDay, itemList, timeInterval);
    }

    public HashMap getAppointmentHashMap() {
        return this.pnlAppointment.getAppointmentHashMap(this.getItemList());
    }

    public int getAppointmentsColumns() {
        return this.pnlAppointment.getAppointmentsColumns();
    }

    private void adjustView() {
        if (!this.typesToggle.isShowAppointments()) {
            this.spltAppointments.remove(this.compAppointments);
        }
        if (!this.typesToggle.isShowNotes()) {
            this.spltTaskNotes.remove(this.compNotes);
        }
        if (!this.typesToggle.isShowTasks()) {
            this.spltTaskNotes.remove(this.compTasks);
        }
        if (!this.typesToggle.isShowNotes() && !this.typesToggle.isShowTasks()) {
            this.spltAppointments.remove(this.spltTaskNotes);
            this.isVertSplitVisible = false;
        } else {
            this.isVertSplitVisible = true;
        }
        this.adjustSplitters();
    }

    private void adjustSplitters() {
        int n = ApplicationOptions.getInstance().getInteger("CALENDAR_DAILY_APPOINTMENTS_SPLITPOS" + this.optionFrameName, -1);
        this.spltAppointments.setDividerLocation(n);
        n = ApplicationOptions.getInstance().getInteger("CALENDAR_DAILY_TASKNOTES_SPLITPOS" + this.optionFrameName, -1);
        this.spltTaskNotes.setDividerLocation(n);
    }

    protected void adjustTasks() {
        if (this.typesToggle.isShowTasks()) {
            if (!this.isVertSplitVisible) {
                this.spltAppointments.add(this.spltTaskNotes);
                this.isVertSplitVisible = true;
            }
            this.spltTaskNotes.add(this.compTasks);
        } else {
            this.spltTaskNotes.remove(this.compTasks);
            if (!this.typesToggle.isShowNotes()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        }
        this.adjustSplitters();
    }

    protected void adjustNotes() {
        if (this.typesToggle.isShowNotes()) {
            if (!this.isVertSplitVisible) {
                this.spltAppointments.add(this.spltTaskNotes);
                this.isVertSplitVisible = true;
            }
            if (this.typesToggle.isShowTasks()) {
                this.spltTaskNotes.remove(this.compTasks);
                this.spltTaskNotes.add(this.compNotes);
                this.spltTaskNotes.add(this.compTasks);
            } else {
                this.spltTaskNotes.add(this.compNotes);
            }
        } else {
            this.spltTaskNotes.remove(this.compNotes);
            if (!this.typesToggle.isShowTasks()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        }
        this.adjustSplitters();
    }

    protected void adjustAppointments() {
        if (this.typesToggle.isShowAppointments()) {
            this.spltAppointments.add(this.compAppointments);
            if (!this.typesToggle.isShowTasks() && !this.typesToggle.isShowNotes()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        } else {
            this.spltAppointments.remove(this.compAppointments);
        }
        this.adjustSplitters();
    }

    protected void adjustClock() {
        if (this.typesToggle.isShowAppointments()) {
            int n = -1;
            if (GWCalendarUtils.isSameDate(this.currentDay, GWCalendarUtils.getToday())) {
                n = GWCalendarUtils.getClockPosition();
            }
            this.pnlAppointment.adjustClock(n);
            this.appointmentClockPanel.adjustClock(n);
        }
    }

    protected void adjustCurrentDay() {
        if (this.refreshedInterval.contains(this.currentDay.getTime())) {
            this.needRefresh(false);
        } else {
            this.needRefresh(true);
            this.refresh(false);
        }
    }

    public void requestFocus() {
        this.appointmentClockPanel.requestFocus();
    }

    private void navigate(int n, int n2) {
        this.pnlAppointment.navigate(n, n2);
    }

    public void navigateUP() {
        this.navigate(12, -30);
    }

    public void navigateDOWN() {
        this.navigate(12, 30);
    }

    public void navigateLEFT() {
        this.navigate(5, -1);
    }

    public void navigateRIGHT() {
        this.navigate(5, 1);
    }

    public void quickCreateItem(char c) {
        this.pnlAppointment.handleQuickCreateItem(c);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class HeaderLabel
    extends OrientableLabel {
        public HeaderLabel(String string) {
            super(string);
            this.setOpaque(true);
            this.setPreferredSize(CalendarView.HEADER_LABEL_SIZE);
            this.setMinimumSize(new Dimension(0, 0));
        }
    }

    private class CalendarListener
    implements DateValueChangeListener {
        private CalendarListener() {
        }

        public void valueChanged(DateChangeEvent dateChangeEvent) {
            if (DailyView.this.calendarAdjusting) {
                return;
            }
            Command command = new Command(70, dateChangeEvent.getDate().getTime());
            DailyView.this.getController().processCommand(command);
        }
    }

    private class AppointmentsClockPanel
    extends OrientablePanel {
        private JPanel pnlHours;
        private int clockPosition = -1;

        public AppointmentsClockPanel() {
            super(new BorderLayout());
            this.buildUI();
        }

        private void buildUI() {
            DailyView.this.pnlAppointment = new AppointmentPanel(DailyView.this.getController(), this);
            this.setFocusable(true);
            this.addKeyListener(new NavigationCreateItemKeyboardListener(DailyView.this));
            this.pnlHours = new ActiveHourLabelsPanel(BorderFactory.createLineBorder(ColorConstants.HEADER_BORDER_COLOR, 1), DailyView.this.getController());
            OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
            orientablePanel.setBorder(BorderFactory.createEmptyBorder());
            orientablePanel.add((Component)this.pnlHours, "Before");
            orientablePanel.add((Component)DailyView.this.pnlAppointment, "Center");
            this.add((Component)orientablePanel, "Center");
        }

        public void adjustClock(int n) {
            this.clockPosition = n;
            this.repaint();
        }

        public void paint(Graphics graphics) {
            graphics = UIUtils.enableAntialiasing(graphics);
            super.paint(graphics);
            if (this.clockPosition >= 0) {
                int n = this.pnlHours.getWidth() - ImageResources.CLOCK_SMALL.getImage().getWidth(this) / 2;
                int n2 = this.clockPosition - ImageResources.CLOCK_SMALL.getImage().getHeight(this) / 2;
                graphics.drawImage(ImageResources.CLOCK_SMALL.getImage(), n, n2, null);
            }
        }
    }
}

