/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.cache.IDObjectsCollection;
import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.appframework.selection.SelectionManagersFactory;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TypingWindow;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentParam;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemDragGestureListener;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemDropTargetListener;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DateWatchPanel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.message.Appointment;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.peer.ComponentPeer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class AppointmentPanel
extends DateWatchPanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$AppointmentPanel == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$AppointmentPanel = AppointmentPanel.class$("com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel")) : class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$AppointmentPanel));
    private static final int DEFAULT_TYPING_CONTROL_HEIGHT = 40;
    public static final int HEIGHT = 96;
    public static final int MAX_HOURS = 24;
    public static final int TIME_STEP = 15;
    public static final int QUARTER_LABEL_HEIGHT = PLAFChanger.getFontSize() - 3;
    public static final float PX_PER_MINUTE = (float)(QUARTER_LABEL_HEIGHT * 4) / 60.0f;
    float[] halfHourDash = new float[]{20.0f, 5.0f};
    float[] quarterHourDash = new float[]{5.0f, 5.0f};
    BasicStroke DEFAULT_LINE_STROKE = new BasicStroke(1.0f);
    BasicStroke CLOCK_LINE_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, this.quarterHourDash, 0.0f);
    BasicStroke HOUR_LINE_STROKE = new BasicStroke(2.0f);
    private HashMap hmApps;
    private BigInteger overlappedTimes = new BigInteger("0", 2);
    private int columnCount = 1;
    private ArrayList appointments;
    private int clockPosition = -1;
    public static final int MORNING_TIME = 8;
    public static final int EVENING_TIME = 20;
    private LabelMouseClick labelClickListener;
    private Rectangle dragRect;
    Dimension min = new Dimension(5, QUARTER_LABEL_HEIGHT);
    private long csTime;
    private long ceTime;
    private JComponent focusOwner;
    private GregorianCalendar day = GWCalendarUtils.getToday();
    private int showAsLevel = 160;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$AppointmentPanel;

    public AppointmentPanel(MVCController mVCController, JComponent jComponent) {
        super(mVCController);
        this.focusOwner = jComponent;
        this.appointments = new ArrayList();
        this.labelClickListener = new LabelMouseClick();
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(10, QUARTER_LABEL_HEIGHT * 96));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        int n = 0;
        while (n < 96) {
            gridBagConstraints.gridy = n++;
            OrientablePanel orientablePanel = new OrientablePanel();
            orientablePanel.setMinimumSize(this.min);
            orientablePanel.setPreferredSize(this.min);
            orientablePanel.setOpaque(false);
            this.add((Component)orientablePanel, gridBagConstraints);
        }
        this.hmApps = new HashMap();
        PanelMouseClick panelMouseClick = new PanelMouseClick();
        this.addMouseListener(panelMouseClick);
        this.setDropTarget(new DropTarget(this, 3, new CalendarItemDropTargetListener(this, this.getController())));
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    private void refresh(ItemList itemList) {
        Object object;
        this.updateAppointmentsHashMap(itemList);
        if (this.columnCount > 1) {
            this.defineAppointmentWidth();
        }
        boolean bl = this.isVisible();
        this.setLightVisible(false);
        this.removeAppointments();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        Iterator iterator = this.hmApps.keySet().iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            object = (Integer)iterator.next();
            AppointmentParam appointmentParam = (AppointmentParam)this.hmApps.get(object);
            gridBagConstraints.gridx = (Integer)object % 100 - 1;
            if (gridBagConstraints.gridx > 20) {
                bl2 = true;
                continue;
            }
            gridBagConstraints.gridy = (Integer)object / 100;
            gridBagConstraints.gridwidth = appointmentParam.getWidth();
            ActiveItemLabel activeItemLabel = new ActiveItemLabel(true, appointmentParam.getAppointmentItem(), GWCalendarUtils.getShowAsLevelColor(appointmentParam.getAppointmentItem().getShowAsLevel()), this.getController(), false);
            activeItemLabel.setMinimumSize(this.min);
            activeItemLabel.setBorder(new LineBorder(Color.BLACK, 1));
            this.appointments.add(activeItemLabel);
            activeItemLabel.addMouseListener(this.labelClickListener);
            String string = ControlsUtils.getUserGuid(this.getController());
            CalendarItemDragGestureListener calendarItemDragGestureListener = new CalendarItemDragGestureListener(activeItemLabel, string);
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(activeItemLabel, 3, calendarItemDragGestureListener);
            gridBagConstraints.gridheight = appointmentParam.getGridHeigh();
            this.add((Component)activeItemLabel, gridBagConstraints);
        }
        this.setLightVisible(bl);
        this.validate();
        this.repaint();
        if (bl2) {
            object = StringResources.TOO_MANY_APPOINTMENTS_SCHEDULED_FOR;
            JOptionPane.showMessageDialog(this, object);
        }
    }

    private void setLightVisible(boolean bl) {
        if (bl) {
            ComponentPeer componentPeer = this.getPeer();
            if (componentPeer != null) {
                componentPeer.show();
            }
        } else {
            ComponentPeer componentPeer = this.getPeer();
            if (componentPeer != null) {
                componentPeer.hide();
            }
        }
    }

    private void removeAppointments() {
        int n = this.appointments.size();
        for (int i = 0; i < n; ++i) {
            ActiveItemLabel activeItemLabel = (ActiveItemLabel)this.appointments.get(i);
            LevelManager.getInstance().release(activeItemLabel.getController().getLevel());
            this.remove(activeItemLabel);
        }
        this.appointments.clear();
    }

    private void updateAppointmentsHashMap(ItemList itemList) {
        this.hmApps.clear();
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.setTime(this.day.getTime());
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        long l = gregorianCalendar.getTimeInMillis() / 60000L;
        long l2 = l + 1440L;
        IDObjectsCollection iDObjectsCollection = GWCalendarUtils.getAppointments(itemList, this.day.getTime());
        Vector vector = new Vector();
        int n = 1;
        boolean bl = false;
        int n2 = iDObjectsCollection.size();
        block0: for (int i = 0; i < n2; ++i) {
            AppointmentItem appointmentItem = (AppointmentItem)iDObjectsCollection.getIDObjectAt(i);
            long l3 = l;
            long l4 = appointmentItem.getStartDate().getTime() / 60000L;
            long l5 = appointmentItem.getEndDate().getTime() / 60000L;
            if (l5 < l || l4 > l2) continue;
            if (l4 < l && l5 < l2) {
                l4 = l;
            }
            for (int j = 0; j < 96; ++j) {
                if (l5 - l4 < 15L) {
                    if (Math.abs(l3 - l4) < 15L) {
                        n = 2;
                        bl = true;
                    }
                } else if (l4 - 1L < l3 && l5 + 1L > l3) {
                    bl = true;
                    n = (int)(l5 - l4) / 15;
                    if (n > 96) {
                        n = 96;
                    }
                }
                if (bl) {
                    this.updateColumnView(vector, j, n, appointmentItem);
                    bl = false;
                    continue block0;
                }
                l3 += 15L;
            }
        }
        this.columnCount = vector.size();
        this.createOverlappedTimes(vector);
    }

    private void updateColumnView(Vector vector, int n, int n2, AppointmentItem appointmentItem) {
        String string = new String("");
        for (int i = n + n2; i > 0; --i) {
            string = i > n ? string + "1" : string + "0";
        }
        BigInteger bigInteger = new BigInteger(string, 2);
        BigInteger bigInteger2 = new BigInteger(string, 2);
        int n3 = vector.size();
        int n4 = 1;
        if (n3 == 0) {
            vector.add(bigInteger);
        } else {
            boolean bl = false;
            for (int i = 0; i < n3; ++i) {
                BigInteger bigInteger3 = (BigInteger)vector.get(i);
                if (bigInteger.and(bigInteger3).equals(BigInteger.ZERO)) {
                    vector.set(i, bigInteger.or(bigInteger3));
                    bl = false;
                    n4 = i + 1;
                    break;
                }
                bl = true;
            }
            if (bl) {
                vector.add(bigInteger);
                n4 = vector.size();
            }
        }
        AppointmentParam appointmentParam = new AppointmentParam(appointmentItem, n2);
        appointmentParam.setLook(bigInteger2);
        this.hmApps.put(new Integer(n * 100 + n4), appointmentParam);
    }

    private void createOverlappedTimes(Vector vector) {
        if (this.columnCount > 1) {
            this.overlappedTimes = BigInteger.ZERO;
            BigInteger bigInteger = BigInteger.ONE;
            for (int i = 0; i < 96; ++i) {
                int n = 0;
                for (int j = 0; j < this.columnCount; ++j) {
                    BigInteger bigInteger2 = (BigInteger)vector.get(j);
                    if (!(bigInteger2 = bigInteger2.and(bigInteger)).equals(BigInteger.ZERO)) {
                        ++n;
                    }
                    if (n <= 1) continue;
                    this.overlappedTimes = this.overlappedTimes.or(bigInteger);
                    break;
                }
                bigInteger = bigInteger.shiftLeft(1);
            }
        }
    }

    private void defineAppointmentWidth() {
        Iterator iterator = this.hmApps.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            AppointmentParam appointmentParam = (AppointmentParam)this.hmApps.get(n);
            int n2 = 1;
            Iterator iterator2 = this.hmApps.keySet().iterator();
            while (iterator2.hasNext()) {
                Integer n3 = (Integer)iterator2.next();
                if (n.intValue() == n3.intValue()) continue;
                AppointmentParam appointmentParam2 = (AppointmentParam)this.hmApps.get(n3);
                if (appointmentParam.getLook().and(appointmentParam2.getLook()).equals(BigInteger.ZERO)) continue;
                ++n2;
            }
            if (n2 != true) continue;
            int n4 = this.columnCount / n2;
            appointmentParam.setWidth(n4);
        }
    }

    public static Rectangle getWorkTimeRectangle() {
        return new Rectangle(0, QUARTER_LABEL_HEIGHT * 4 * 8, 100, 300);
    }

    public HashMap getAppointmentHashMap(ItemList itemList) {
        this.updateAppointmentsHashMap(itemList);
        return this.hmApps;
    }

    public int getAppointmentsColumns() {
        return this.columnCount;
    }

    public BigInteger getOverlappedTimes() {
        return this.overlappedTimes;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)UIUtils.enableAntialiasing(graphics);
        this.drawNightColors(graphics2D);
        this.drawHoursLines(graphics2D);
        if (this.clockPosition >= 0) {
            graphics2D.setStroke(this.CLOCK_LINE_STROKE);
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(0, this.clockPosition, this.getWidth(), this.clockPosition);
            graphics2D.setStroke(this.DEFAULT_LINE_STROKE);
        }
        this.drawHighlightedHourRow(graphics2D);
        this.drawDragRect(graphics2D);
        super.paint(graphics);
    }

    private void drawNightColors(Graphics2D graphics2D) {
        int n = QUARTER_LABEL_HEIGHT * 4 * 8;
        graphics2D.setColor(ColorConstants.clrDayBack);
        graphics2D.fillRect(0, 0, this.getWidth(), n);
        int n2 = n;
        n = QUARTER_LABEL_HEIGHT * 4 * 13;
        graphics2D.setColor(GWCalendarUtils.getShowAsLevelColor(this.showAsLevel));
        graphics2D.fillRect(0, n2, this.getWidth(), n);
        n2 += n;
        n = QUARTER_LABEL_HEIGHT * 4 * 4;
        graphics2D.setColor(ColorConstants.clrDayBack);
        graphics2D.fillRect(0, n2, this.getWidth(), n);
    }

    private void drawHoursLines(Graphics2D graphics2D) {
        for (int i = 0; i < 24; ++i) {
            this.drawHourLine(graphics2D, i);
            this.drawHalfHourLine(graphics2D, i);
        }
        this.drawHourLine(graphics2D, 24);
        graphics2D.setStroke(this.DEFAULT_LINE_STROKE);
    }

    private void drawHalfHourLine(Graphics2D graphics2D, int n) {
        graphics2D.setColor(ColorConstants.clrHalfHourBorder);
        graphics2D.setStroke(this.DEFAULT_LINE_STROKE);
        graphics2D.drawLine(0, QUARTER_LABEL_HEIGHT * (2 + 4 * n), this.getWidth(), QUARTER_LABEL_HEIGHT * (2 + 4 * n));
    }

    private void drawHourLine(Graphics2D graphics2D, int n) {
        graphics2D.setColor(ColorConstants.HEADER_BORDER_COLOR);
        graphics2D.setStroke(this.HOUR_LINE_STROKE);
        graphics2D.drawLine(0, QUARTER_LABEL_HEIGHT * 4 * n, this.getWidth(), QUARTER_LABEL_HEIGHT * 4 * n);
    }

    public void loadItemsForDate(Date date, ItemList itemList) {
        if (itemList != null) {
            this.showAsLevel = this.getShowAsLevel(itemList.getAllDayEvents(date));
        }
        this.day.setTime(date);
        this.adjustClock(-1);
        this.refresh(itemList);
    }

    private int getShowAsLevel(Item[] itemArray) {
        int n = 160;
        for (int i = 0; i < itemArray.length; ++i) {
            Appointment appointment = (Appointment)itemArray[i];
            int n2 = appointment.getShowAsLevel();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public GregorianCalendar getDay() {
        return this.day;
    }

    public void adjustClock(int n) {
        this.clockPosition = n;
        this.repaint();
    }

    public AppointmentItem getSelectedItem() {
        for (int i = 0; i < this.appointments.size(); ++i) {
            ActiveItemLabel activeItemLabel = (ActiveItemLabel)this.appointments.get(i);
            if (!activeItemLabel.isSelected()) continue;
            return (AppointmentItem)activeItemLabel.getItem();
        }
        return null;
    }

    private void drawHighlightedHourRow(Graphics2D graphics2D) {
        if (!GWCalendarUtils.isSameDate(this.getDay(), this.getCurrentDate())) {
            return;
        }
        Rectangle rectangle = this.getCurrentHourRect();
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(this.HOUR_LINE_STROKE);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setStroke(this.DEFAULT_LINE_STROKE);
    }

    public Rectangle getCurrentHourRect() {
        int n = this.getCurrentDate().get(11) * 60 + this.getCurrentDate().get(12);
        int n2 = (int)((float)n * PX_PER_MINUTE);
        int n3 = n2 / (QUARTER_LABEL_HEIGHT * 2);
        Rectangle rectangle = new Rectangle(2, n3 * (QUARTER_LABEL_HEIGHT * 2), this.getWidth() - 4, QUARTER_LABEL_HEIGHT * 2 - 2);
        return rectangle;
    }

    public void setCurrentDate(Date date) {
        super.setCurrentDate(date);
        this.csTime = this.getCurrentDate().getTimeInMillis();
        this.ceTime = this.csTime + 1800000L;
        this.validateCurrentSelection();
        this.scrollRectToVisible(this.getCurrentHourRect());
        this.repaint();
    }

    private boolean needAdjustCurrentSelection() {
        if (!GWCalendarUtils.isSameDate(this.getDay(), this.getCurrentDate()) || !this.getFocusOwner().isFocusOwner()) {
            return false;
        }
        AbstractItem abstractItem = SelectionManagersFactory.getInstance().getManager(this.getController()).getItem();
        if (abstractItem == null || !(abstractItem instanceof AppointmentItem)) {
            return true;
        }
        AppointmentItem appointmentItem = (AppointmentItem)abstractItem;
        return !this.isInsideCurrentRect(appointmentItem);
    }

    public boolean isInsideCurrentRect(AppointmentItem appointmentItem) {
        long l = appointmentItem.getStartDate().getTime();
        long l2 = appointmentItem.getEndDate().getTime();
        return this.csTime > l && this.csTime < l2 || this.ceTime < l2 && this.ceTime > l;
    }

    private void validateCurrentSelection() {
        if (!this.needAdjustCurrentSelection()) {
            return;
        }
        for (int i = 0; i < this.appointments.size(); ++i) {
            ActiveItemLabel activeItemLabel = (ActiveItemLabel)this.appointments.get(i);
            AbstractCalendarItem abstractCalendarItem = (AbstractCalendarItem)activeItemLabel.getItem();
            if (!this.isInsideCurrentRect((AppointmentItem)abstractCalendarItem)) continue;
            activeItemLabel.select();
            return;
        }
    }

    private void drawDragRect(Graphics2D graphics2D) {
        if (this.dragRect == null) {
            return;
        }
        graphics2D.setColor(Color.BLUE);
        graphics2D.setStroke(this.HOUR_LINE_STROKE);
        graphics2D.drawRect(this.dragRect.x, this.dragRect.y, this.dragRect.width, this.dragRect.height);
        graphics2D.setStroke(this.DEFAULT_LINE_STROKE);
        graphics2D.setColor(Color.BLACK);
    }

    private Date getDateAtPoint(Point point) {
        int n = point.y / (QUARTER_LABEL_HEIGHT * 2);
        if (n < 0) {
            return null;
        }
        n *= 1800000;
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.setTime(this.day.getTime());
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.add(14, n);
        return gregorianCalendar.getTime();
    }

    public void highlightDragHours(Point point, long l) {
        int n = 2;
        int n2 = point.y;
        int n3 = this.getWidth() - 4;
        long l2 = l / 15L * (long)QUARTER_LABEL_HEIGHT;
        int n4 = (int)l2 - 2;
        this.dragRect = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle = new Rectangle(n, n2 - 20, n3, n4 + 40);
        this.scrollRectToVisible(rectangle);
        this.repaint();
    }

    public void clearHighlightDragHours() {
        this.dragRect = null;
        this.repaint();
    }

    private void handleClick(Point point) {
        Date date = this.getDateAtPoint(point);
        this.adjustCurrentTime(date);
    }

    private JComponent getFocusOwner() {
        return this.focusOwner;
    }

    public void navigate(int n, int n2) {
        this.getCurrentDate().add(n, n2);
        this.adjustCurrentTime(this.getCurrentDate().getTime());
        this.scrollRectToVisible(this.getCurrentHourRect());
    }

    public void handleQuickCreateItem(char c) {
        Rectangle rectangle = this.getCurrentHourRect();
        Point point = new Point(rectangle.x, rectangle.y);
        SwingUtilities.convertPointToScreen(point, this);
        Dimension dimension = new Dimension(rectangle.width, 40);
        TypingWindow.getInstance(SwingUtilities.windowForComponent(this)).show("Appointment", (GregorianCalendar)this.getCurrentDate().clone(), String.valueOf(c), point, dimension, this.getController());
    }

    public Date getDragDate() {
        if (this.dragRect != null) {
            return this.getDateAtPoint(new Point(this.dragRect.x, this.dragRect.y));
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PanelMouseClick
    extends MouseAdapter {
        private PanelMouseClick() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (OS.isDoubleClick(mouseEvent)) {
                Date date = AppointmentPanel.this.getDateAtPoint(mouseEvent.getPoint());
                if (date == null) {
                    return;
                }
                GWCalendar.createNewCalendarItem("Appointment", date, AppointmentPanel.this.getController(), true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!AppointmentPanel.this.getFocusOwner().isFocusOwner()) {
                AppointmentPanel.this.getFocusOwner().grabFocus();
            }
            Point point = mouseEvent.getPoint();
            AppointmentPanel.this.handleClick(point);
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Date date = AppointmentPanel.this.getDateAtPoint(mouseEvent.getPoint());
                if (date == null) {
                    return;
                }
                MVCController mVCController = AppointmentPanel.this.getController();
                GWCalendarPopup gWCalendarPopup = new GWCalendarPopup("Appointment", date, mVCController);
                gWCalendarPopup.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class LabelMouseClick
    extends MouseAdapter {
        private LabelMouseClick() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!AppointmentPanel.this.isFocusOwner()) {
                AppointmentPanel.this.grabFocus();
            }
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            SwingUtilities.convertPointFromScreen(point, AppointmentPanel.this);
            if (!AppointmentPanel.this.getFocusOwner().isFocusOwner()) {
                AppointmentPanel.this.getFocusOwner().grabFocus();
            }
            AppointmentPanel.this.handleClick(point);
        }
    }
}

