/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.drag.DragManager;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JLabel;

public class CalendarItemDragGestureListener
implements DragGestureListener {
    private ActiveItemLabel label;
    private String userID;

    public CalendarItemDragGestureListener(ActiveItemLabel activeItemLabel, String string) {
        this.label = activeItemLabel;
        this.userID = string;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        AbstractItem abstractItem;
        if (dragGestureEvent.getTriggerEvent() instanceof MouseEvent && ((MouseEvent)dragGestureEvent.getTriggerEvent()).getButton() == 2) {
            return;
        }
        if ((dragGestureEvent.getDragAction() & 3) > 0 && (abstractItem = this.label.getItem()) instanceof AbstractCalendarItem) {
            dragGestureEvent.getSourceAsDragGestureRecognizer().setSourceActions(2);
            BufferedImage bufferedImage = new BufferedImage(100, 100, 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
            JLabel jLabel = new JLabel(ImageResources.ICON_MESSAGE);
            jLabel.paint(graphics2D);
            ImageResources.ICON_START_QUERY_FOLDER.getImage();
            DragManager.getInstance().setItem(abstractItem);
            dragGestureEvent.startDrag(DragSource.DefaultMoveNoDrop, bufferedImage, new Point(0, 0), new CalendarItemWrapper((AbstractCalendarItem)abstractItem), new CalendarItemDragSourceListener());
        }
    }

    private class CalendarItemDragSourceListener
    extends DragSourceAdapter {
        private int userAction;

        private CalendarItemDragSourceListener() {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            this.userAction = dragSourceDragEvent.getUserAction();
            if (this.userAction == 1) {
                dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
            } else if (this.userAction == 2) {
                dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            this.userAction = dragSourceDragEvent.getUserAction();
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            if (this.userAction == 1) {
                dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
            } else if (this.userAction == 2) {
                dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragManager.getInstance().setItem(null);
        }
    }

    private class CalendarItemWrapper
    implements Transferable {
        private DataFlavor[] flavors;
        private AbstractCalendarItem item;

        public CalendarItemWrapper(AbstractCalendarItem abstractCalendarItem) {
            this.item = abstractCalendarItem;
            GWFlavors.itemsFlavor.setUserGuid(CalendarItemDragGestureListener.this.userID);
            this.flavors = new DataFlavor[]{GWFlavors.itemsFlavor};
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return Arrays.asList(this.flavors).contains(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(GWFlavors.itemsFlavor)) {
                ItemList itemList = GWCommandManager.getInstance(CalendarItemDragGestureListener.this.userID).getItemListForItem(this.item);
                int[] nArray = new int[]{itemList.indexOf((Item)this.item.getNativeItem())};
                return itemList.getTransferItems(nArray);
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

