/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.drag.DragManager;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.item.MoveItemCallBack;
import com.novell.gw.jclient.application.actions.send.ActionSend;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.compose.FrameComposeAppointment;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.sendoptions.AppSendOptions;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CalendarItemDropTargetListener
extends DropTargetAdapter {
    private static final Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$CalendarItemDropTargetListener == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$CalendarItemDropTargetListener = CalendarItemDropTargetListener.class$("com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemDropTargetListener")) : class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$CalendarItemDropTargetListener));
    private AppointmentPanel panel;
    private MVCController controller;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$CalendarItemDropTargetListener;

    public CalendarItemDropTargetListener(AppointmentPanel appointmentPanel, MVCController mVCController) {
        this.panel = appointmentPanel;
        this.controller = mVCController;
    }

    private void moveItem(Transferable transferable) throws UnresolvedAddressException, GWCommandException {
        logger.debug((Object)"moveItem entered");
        AbstractItem abstractItem = DragManager.getInstance().getItem();
        if (abstractItem instanceof AppointmentItem) {
            AppointmentItem appointmentItem = (AppointmentItem)abstractItem;
            Date date = this.panel.getDragDate();
            if (date == null) {
                logger.debug((Object)"Abnormal function termination - new start date is NULL!");
                return;
            }
            Date[] dateArray = new Date[]{date};
            long l = appointmentItem.getDuration();
            Date date2 = new Date(date.getTime() + l);
            logger.debug((Object)("newStartDate = " + GWCalendarUtils.getDateTimeFormat().format(date)));
            logger.debug((Object)("newEndDate = " + GWCalendarUtils.getDateTimeFormat().format(date2)));
            if (appointmentItem.isPersonal()) {
                appointmentItem.setStartDates(dateArray);
                appointmentItem.setEndDate(date2);
                MoveItemCallBack moveItemCallBack = new MoveItemCallBack();
                String string = ControlsUtils.getUserGuid(this.controller);
                GWCommandManager.getInstance(string).modifyItem(appointmentItem, moveItemCallBack);
            } else if (appointmentItem.canResend()) {
                JOptionPane jOptionPane = new JOptionPane(StringResources.RESCHEDULE_QUESTION, 3, 1){

                    public int getMaxCharactersPerLineCount() {
                        return 100;
                    }
                };
                JDialog jDialog = jOptionPane.createDialog(null, StringResources.NOVELL_GROUPWISE);
                jDialog.pack();
                jDialog.setVisible(true);
                Object object = jOptionPane.getValue();
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    switch (n) {
                        case 0: {
                            FrameCompose frameCompose = this.createResendFrame(appointmentItem, dateArray, date2);
                            ActionSend actionSend = (ActionSend)frameCompose.getAppActionList().getAction("Send");
                            actionSend.setDisableSignature(true);
                            frameCompose.showMe();
                            GlobalCommand globalCommand = new GlobalCommand(480, frameCompose);
                            frameCompose.getController().processCommand(globalCommand);
                            break;
                        }
                        case 1: {
                            FrameCompose frameCompose = this.createResendFrame(appointmentItem, dateArray, date2);
                            GlobalCommand globalCommand = new GlobalCommand(480, frameCompose);
                            frameCompose.getController().processCommand(globalCommand);
                            ActionSend actionSend = (ActionSend)frameCompose.getAppActionList().getAction("Send");
                            actionSend.setDisableSignature(true);
                            actionSend.actionPerformed(null);
                            actionSend.setDisableSignature(false);
                            break;
                        }
                    }
                }
            }
        }
        logger.debug((Object)"moveItem exited");
    }

    private FrameCompose createResendFrame(AppointmentItem appointmentItem, Date[] dateArray, Date date) throws GWCommandException {
        AppointmentItem appointmentItem2 = (AppointmentItem)GWEngineUtils.composeResendItem(appointmentItem);
        appointmentItem2.setStartDates(dateArray);
        appointmentItem2.setEndDate(date);
        AppSendOptions appSendOptions = new AppSendOptions(null);
        appointmentItem2.getComposeItemSendOptions(appSendOptions);
        FrameComposeAppointment frameComposeAppointment = new FrameComposeAppointment(appointmentItem2, GWClient.getApplication(), true, ControlsUtils.getUserGuid(this.controller));
        frameComposeAppointment.getItemEdit().setSendOptions(appSendOptions);
        return frameComposeAppointment;
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        String string = ControlsUtils.getUserGuid(this.controller);
        if (dropTargetDragEvent.getCurrentDataFlavorsAsList().contains(GWFlavors.itemsFlavor) && string.equals(GWFlavors.itemsFlavor.getUserGuid())) {
            AbstractItem abstractItem = DragManager.getInstance().getItem();
            long l = 60L;
            if (abstractItem instanceof AbstractCalendarItem) {
                l = ((AbstractCalendarItem)abstractItem).getDuration() / 60000L;
            }
            this.panel.highlightDragHours(dropTargetDragEvent.getLocation(), l);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.panel.clearHighlightDragHours();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            if (dropTargetDropEvent.getCurrentDataFlavorsAsList().contains(GWFlavors.itemsFlavor)) {
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                Transferable transferable = dropTargetDropEvent.getTransferable();
                this.moveItem(transferable);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
        finally {
            dropTargetDropEvent.dropComplete(true);
            this.panel.clearHighlightDragHours();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

